/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.webui.activity;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.news.model.News;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/news/webui/activity/UINewsActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.EditCommentActionListener.class})})
public class UINewsActivity
extends BaseUIActivity {
    public static final String ACTIVITY_TYPE = "news";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private News news;

    public News getNews() {
        return this.news;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public String getUserFullName(String userId) {
        String fullName = "";
        org.exoplatform.social.core.identity.model.Identity identity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", userId, true);
        if (identity != null) {
            fullName = identity.getProfile().getFullName();
        }
        return fullName;
    }

    public String getUserProfileURL(String userId) {
        return LinkProvider.getUserProfileUri((String)userId);
    }

    public boolean canEditNews(ExoSocialActivity activity) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        String authenticatedUserId = currentUser.getId();
        SpaceService spaceService = Utils.getSpaceService();
        Space currentSpace = spaceService.getSpaceById(this.news.getSpaceId());
        return authenticatedUserId.equals(activity.getPosterId()) || spaceService.isSuperManager(authenticatedUser) || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.isMemberOf(currentSpace.getGroupId(), MANAGER_MEMBERSHIP_NAME);
    }

    public boolean canPinNews(ExoSocialActivity activity) {
        return ConversationState.getCurrent().getIdentity().isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }
}

