/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.webui.activity;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.news.webui.activity.UINewsActivity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;

public class UINewsActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(UINewsActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        NewsService newsService = (NewsService)CommonsUtils.getService(NewsService.class);
        try {
            News news;
            String newsId = (String)activity.getTemplateParams().get("newsId");
            if (newsId != null && (news = newsService.getNewsById(newsId)) != null) {
                ((UINewsActivity)uiActivity).setNews(news);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting news of activity " + activity.getId()), (Throwable)e);
        }
    }
}

