/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.news.NewsAttachmentsService;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.NewsUtils;
import org.exoplatform.news.connector.NewsSearchConnector;
import org.exoplatform.news.connector.NewsSearchResult;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.notification.plugin.MentionInNewsNotificationPlugin;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.news.queryBuilder.NewsQueryBuilder;
import org.exoplatform.news.search.NewsESSearchConnector;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.social.ckeditor.HTMLUploadImageProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class NewsServiceImpl
implements NewsService {
    public static final String[] SHARE_NEWS_PERMISSIONS = new String[]{"read"};
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PINNED_NEWS_NODES_FOLDER = "Pinned";
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String PLATFORM_ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String MIX_NEWS_MODIFIERS = "mix:newsModifiers";
    public static final String MIX_NEWS_MODIFIERS_PROP = "exo:newsModifiersIds";
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s<]+)|@([^\\s<]+)$");
    private static final String HTML_AT_SYMBOL_PATTERN = "@";
    private static final String HTML_AT_SYMBOL_ESCAPED_PATTERN = "&#64;";
    private static final String LAST_PUBLISHER = "publication:lastUser";
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private DataDistributionType dataDistributionType;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private UploadService uploadService;
    private LinkManager linkManager;
    private HTMLUploadImageProcessor imageProcessor;
    private PublicationService publicationService;
    private PublicationManager publicationManager;
    private WCMPublicationService wCMPublicationService;
    private NewsSearchConnector newsSearchConnector;
    private NewsAttachmentsService newsAttachmentsService;
    private IndexingService indexingService;
    private NewsESSearchConnector newsESSearchConnector;
    private UserACL userACL;
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImpl.class);

    public NewsServiceImpl(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager dataDistributionManager, SpaceService spaceService, ActivityManager activityManager, IdentityManager identityManager, UploadService uploadService, HTMLUploadImageProcessor imageProcessor, LinkManager linkManager, PublicationService publicationService, PublicationManager publicationManager, WCMPublicationService wCMPublicationService, NewsSearchConnector newsSearchConnector, NewsAttachmentsService newsAttachmentsService, IndexingService indexingService, NewsESSearchConnector newsESSearchConnector, UserACL userACL) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.imageProcessor = imageProcessor;
        this.linkManager = linkManager;
        this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.publicationService = publicationService;
        this.publicationManager = publicationManager;
        this.wCMPublicationService = wCMPublicationService;
        this.newsSearchConnector = newsSearchConnector;
        this.newsAttachmentsService = newsAttachmentsService;
        this.indexingService = indexingService;
        this.newsESSearchConnector = newsESSearchConnector;
        this.userACL = userACL;
    }

    @Override
    public News createNews(News news) throws Exception {
        if (StringUtils.isEmpty((CharSequence)news.getId())) {
            news = this.createNewsDraft(news);
        } else {
            this.postNewsActivity(news);
            this.updateNews(news);
            this.sendNotification(news, NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        }
        if (news.isPinned()) {
            this.pinNews(news.getId());
        }
        NewsUtils.broadcastEvent("exo.news.postArticle", news.getId(), news.getAuthor());
        return news;
    }

    @Override
    public News getNewsById(String newsId, boolean editMode) {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        try {
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByUUID(newsId);
            return this.convertNodeToNews(node, editMode);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while retrieving news with id " + newsId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<News> getNews(NewsFilter filter) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<News> listNews = new ArrayList<News>();
        NewsQueryBuilder queyBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queyBuilder.buildQuery(filter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            ((QueryImpl)query).setOffset((long)filter.getOffset());
            ((QueryImpl)query).setLimit((long)filter.getLimit());
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node iterNode = it.nextNode();
                News news = this.convertNodeToNews(iterNode, filter.isDraftNews());
                listNews.add(news);
            }
            ArrayList<News> arrayList = listNews;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean canArchiveNews(String newsAuthor) {
        Identity currentIdentity = this.getCurrentIdentity();
        return currentIdentity != null && (currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.getUserId().equals(newsAuthor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNewsCount(NewsFilter filter) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queryBuilder.buildQuery(filter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            int count = 0;
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                it.nextNode();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public News updateNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(news.getId());
        if (newsNode != null) {
            String oldBody = newsNode.getProperty("exo:body").getString();
            Set<String> previousMentions = NewsUtils.processMentions(oldBody);
            newsNode.setProperty("exo:title", news.getTitle());
            newsNode.setProperty("exo:name", news.getTitle());
            newsNode.setProperty("exo:summary", news.getSummary());
            String processedBody = this.imageProcessor.processImages(news.getBody(), newsNode, "images");
            news.setBody(processedBody);
            newsNode.setProperty("exo:body", processedBody);
            newsNode.setProperty("exo:dateModified", Calendar.getInstance());
            if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
                this.attachIllustration(newsNode, news.getUploadId());
            } else if ("".equals(news.getUploadId())) {
                this.removeIllustration(newsNode);
            }
            news.setAttachments(this.newsAttachmentsService.updateNewsAttachments(news, newsNode));
            newsNode.save();
            if (StringUtils.isNotBlank((CharSequence)news.getTitle()) && !news.getTitle().equals(newsNode.getName())) {
                String srcPath = newsNode.getPath();
                String destPath = (newsNode.getParent().getPath().equals("/") ? "" : newsNode.getParent().getPath()) + "/" + Utils.cleanName((String)news.getTitle()).trim();
                session.getWorkspace().move(srcPath, destPath);
            }
            if ("published".equals(news.getPublicationState())) {
                this.publicationService.changeState(newsNode, "published", new HashMap());
                if (newsNode.isNodeType(MIX_NEWS_MODIFIERS)) {
                    newsNode.removeMixin(MIX_NEWS_MODIFIERS);
                    newsNode.save();
                }
                if (StringUtils.isNotEmpty((CharSequence)news.getId()) && news.getCreationDate() != null) {
                    News newMentionedNews = news;
                    if (!previousMentions.isEmpty()) {
                        previousMentions.forEach(username -> newMentionedNews.setBody(newMentionedNews.getBody().replaceAll(HTML_AT_SYMBOL_PATTERN + username, "")));
                    }
                    this.sendNotification(newMentionedNews, NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
                }
                this.indexingService.reindex("news", String.valueOf(news.getId()));
            } else if ("draft".equals(news.getPublicationState())) {
                this.publicationService.changeState(newsNode, "draft", new HashMap());
                org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", this.getCurrentUserId());
                String currentIdentityId = currentIdentity.getId();
                if (!newsNode.isNodeType(MIX_NEWS_MODIFIERS)) {
                    newsNode.addMixin(MIX_NEWS_MODIFIERS);
                }
                Object[] newsModifiers = new Value[]{};
                boolean alreadyExist = false;
                if (newsNode.hasProperty(MIX_NEWS_MODIFIERS_PROP)) {
                    newsModifiers = newsNode.getProperty(MIX_NEWS_MODIFIERS_PROP).getValues();
                    alreadyExist = Arrays.stream(newsModifiers).map(value -> {
                        try {
                            return value.getString();
                        }
                        catch (RepositoryException e) {
                            return null;
                        }
                    }).anyMatch(newsModifier -> newsModifier.equals(currentIdentityId));
                }
                if (!alreadyExist) {
                    newsNode.setProperty(MIX_NEWS_MODIFIERS_PROP, (Value[])ArrayUtils.add((Object[])newsModifiers, (Object)new StringValue(currentIdentityId)));
                    newsNode.save();
                }
            }
        }
        return news;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(news.getId());
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + news.getId());
        }
        if (!newsNode.hasProperty("exo:viewers")) {
            newsNode.setProperty("exo:viewers", "");
        }
        String newsViewers = newsNode.getProperty("exo:viewers").getString();
        boolean isCurrentUserInNewsViewers = false;
        if (!newsViewers.isEmpty()) {
            String[] newsViewersArray = newsViewers.split(",");
            isCurrentUserInNewsViewers = Arrays.stream(newsViewersArray).anyMatch(userId::equals);
        }
        if (!isCurrentUserInNewsViewers) {
            if (news.getViewsCount() == null) {
                news.setViewsCount(1L);
            } else {
                news.setViewsCount(news.getViewsCount() + 1L);
            }
            newsViewers = newsViewers.isEmpty() ? newsViewers.concat(userId) : newsViewers.concat(",").concat(userId);
            newsNode.setProperty("exo:viewsCount", news.getViewsCount().longValue());
            newsNode.setProperty("exo:viewers", newsViewers);
            newsNode.save();
        }
    }

    @Override
    public void pinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNewsById(newsId, false);
        Node newsNode = session.getNodeByUUID(newsId);
        Node pinnedRootNode = this.getPinnedNewsFolder();
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsNode.canAddMixin("exo:privilegeable")) {
            newsNode.addMixin("exo:privilegeable");
        }
        ((ExtendedNode)newsNode).setPermission("*:/platform/users", SHARE_NEWS_PERMISSIONS);
        this.newsAttachmentsService.makeAttachmentsPublic(newsNode);
        this.linkManager.createLink(newsFolderNode, "exo:symlink", newsNode, null);
        newsNode.setProperty("exo:pinned", true);
        newsNode.save();
        NewsUtils.broadcastEvent("exo.news.PublishArticle", news.getId(), this.getCurrentUserId());
        this.sendNotification(news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_IN_NEWS);
    }

    @Override
    public void unpinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNewsById(newsId, false);
        if (news == null) {
            throw new Exception("Unable to find a news with an id equal to: " + newsId);
        }
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:pinned", false);
        if (newsNode.isNodeType("exo:privilegeable")) {
            ((ExtendedNode)newsNode).removePermission("*:/platform/users");
        }
        newsNode.save();
        this.newsAttachmentsService.unmakeAttachmentsPublic(newsNode);
        Node pinnedRootNode = this.getPinnedNewsFolder();
        if (pinnedRootNode == null) {
            throw new Exception("Unable to find the root pinned folder: /Application Data/News/pinned");
        }
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsFolderNode == null) {
            throw new Exception("Unable to find the parent node of the current pinned node");
        }
        Node pinnedNode = newsFolderNode.getNode(newsNode.getName());
        if (pinnedNode == null) {
            throw new Exception("Unable to find the current pinned node");
        }
        pinnedNode.remove();
        newsFolderNode.save();
    }

    private Node getPinnedNewsFolder() throws Exception {
        Node pinnedRootNode;
        Node newsRootNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
        if (!applicationDataNode.hasNode(NEWS_NODES_FOLDER)) {
            newsRootNode = applicationDataNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            applicationDataNode.save();
        } else {
            newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER);
        }
        if (!newsRootNode.hasNode(PINNED_NEWS_NODES_FOLDER)) {
            pinnedRootNode = newsRootNode.addNode(PINNED_NEWS_NODES_FOLDER, "nt:unstructured");
            newsRootNode.save();
        } else {
            pinnedRootNode = newsRootNode.getNode(PINNED_NEWS_NODES_FOLDER);
        }
        return pinnedRootNode;
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.canViewNews(news, userIdentity.getRemoteId())) {
            throw new IllegalAccessException("User with id " + userIdentity.getRemoteId() + "doesn't have access to news");
        }
        String newsId = news.getId();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ExtendedNode newsNode = (ExtendedNode)this.getNewsNodeById(newsId, sessionProvider);
            if (newsNode == null) {
                throw new ObjectNotFoundException("News with id " + newsId + "wasn't found");
            }
            if (newsNode.canAddMixin("exo:privilegeable")) {
                newsNode.addMixin("exo:privilegeable");
            }
            newsNode.setPermission("*:" + space.getGroupId(), SHARE_NEWS_PERMISSIONS);
            newsNode.save();
            if (sharedActivityId != null) {
                if (newsNode.hasProperty("exo:activities")) {
                    String activities = newsNode.getProperty("exo:activities").getString();
                    activities = activities.concat(";").concat(space.getId()).concat(":").concat(sharedActivityId);
                    newsNode.setProperty("exo:activities", activities);
                } else {
                    newsNode.setProperty("exo:activities", sharedActivityId);
                }
                newsNode.save();
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while sharing news with id " + newsId + " to space " + space.getId() + " by user" + userIdentity.getId(), e);
        }
    }

    @Override
    public void deleteNews(String newsId, boolean isDraft) throws Exception {
        String newActivities;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node node = session.getNodeByUUID(newsId);
        if (node.hasProperty("exo:activities") && StringUtils.isNotEmpty((CharSequence)(newActivities = node.getProperty("exo:activities").getString()))) {
            if (isDraft && node.hasProperty("publication:currentState") && node.getProperty("publication:currentState").getString().equals("draft")) {
                String versionNodeUUID = node.hasProperty("publication:liveRevision") ? node.getProperty("publication:liveRevision").getString() : null;
                String versionName = node.getVersionHistory().getSession().getNodeByUUID(versionNodeUUID).getName();
                if (!versionName.isEmpty()) {
                    node.restore(versionName, true);
                    if (!node.isCheckedOut()) {
                        node.checkout();
                    }
                    this.publicationService.changeState(node, "published", new HashMap());
                    return;
                }
            }
            Stream.of(newActivities.split(";")).map(activity -> activity.split(":")[1]).forEach(newsActivityId -> this.activityManager.deleteActivity(newsActivityId));
        }
        Utils.removeDeadSymlinks((Node)node, (boolean)false);
        node.remove();
        session.save();
    }

    @Override
    public News convertNodeToNews(Node node, boolean editMode) throws Exception {
        org.exoplatform.social.core.identity.model.Identity draftUpdaterIdentity;
        org.exoplatform.social.core.identity.model.Identity identity;
        Node originalNode;
        if (node == null) {
            return null;
        }
        if (!editMode && node.getProperty("publication:currentState").getString().equals("draft") && node.hasProperty("publication:liveRevision")) {
            String versionNodeUUID = node.getProperty("publication:liveRevision").getString();
            Node versionNode = node.getVersionHistory().getSession().getNodeByUUID(versionNodeUUID);
            node = versionNode.getNode("jcr:frozenNode");
        }
        News news = new News();
        if (node.hasProperty("jcr:frozenUuid")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            originalNode = node.getSession().getNodeByUUID(uuid);
            news.setId(originalNode.getUUID());
        } else {
            originalNode = node;
            news.setId(node.getUUID());
        }
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        news.setTitle(this.getStringProperty(node, "exo:title"));
        news.setSummary(this.getStringProperty(node, "exo:summary"));
        String body = this.getStringProperty(node, "exo:body");
        String sanitizedBody = HTMLSanitizer.sanitize((String)body);
        sanitizedBody = StringEscapeUtils.unescapeHtml((String)sanitizedBody);
        sanitizedBody = sanitizedBody.replaceAll(HTML_AT_SYMBOL_ESCAPED_PATTERN, HTML_AT_SYMBOL_PATTERN);
        news.setBody(this.substituteUsernames(portalOwner, sanitizedBody));
        news.setAuthor(this.getStringProperty(node, "exo:author"));
        news.setCanArchive(this.canArchiveNews(news.getAuthor()));
        news.setCreationDate(this.getDateProperty(node, "exo:dateCreated"));
        news.setPublicationDate(this.getPublicationDate(node));
        news.setUpdater(this.getLastUpdater(node));
        news.setUpdateDate(this.getLastUpdatedDate(node));
        news.setDraftUpdater(this.getStringProperty(node, "exo:lastModifier"));
        news.setDraftUpdateDate(this.getDateProperty(node, "exo:dateModified"));
        news.setPath(this.getPath(node));
        if (node.hasProperty("publication:currentState")) {
            news.setPublicationState(node.getProperty("publication:currentState").getString());
        }
        if (originalNode.hasProperty("exo:pinned")) {
            news.setPinned(originalNode.getProperty("exo:pinned").getBoolean());
        }
        if (originalNode.hasProperty("exo:archived")) {
            news.setArchived(originalNode.getProperty("exo:archived").getBoolean());
        }
        if (originalNode.hasProperty("exo:spaceId")) {
            news.setSpaceId(node.getProperty("exo:spaceId").getString());
        }
        news.setCanEdit(this.canEditNews(news.getAuthor(), news.getSpaceId()));
        news.setCanDelete(this.canDeleteNews(news.getAuthor(), news.getSpaceId()));
        news.setCanPublish(this.canPinNews());
        StringBuilder newsUrl = new StringBuilder("");
        if (originalNode.hasProperty("exo:activities")) {
            String strActivities = originalNode.getProperty("exo:activities").getString();
            if (StringUtils.isNotEmpty((CharSequence)strActivities)) {
                String[] activities = strActivities.split(";");
                StringBuilder memberSpaceActivities = new StringBuilder();
                Identity currentIdentity = this.getCurrentIdentity();
                String currentUsername = currentIdentity == null ? null : currentIdentity.getUserId();
                String newsActivityId = activities[0].split(":")[1];
                news.setActivityId(newsActivityId);
                Space newsPostedInSpace = this.spaceService.getSpaceById(activities[0].split(":")[0]);
                if (currentUsername != null && this.spaceService.isMember(newsPostedInSpace, currentUsername)) {
                    newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/activity?id=").append(newsActivityId);
                    news.setUrl(newsUrl.toString());
                } else {
                    newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/news/detail?newsId=").append(news.getId());
                    news.setUrl(newsUrl.toString());
                }
                memberSpaceActivities.append(activities[0]).append(";");
                for (int i = 1; i < activities.length; ++i) {
                    Space space = this.spaceService.getSpaceById(activities[i].split(":")[0]);
                    ExoSocialActivity exoSocialActivity = this.activityManager.getActivity(activities[i].split(":")[1]);
                    if (space == null || currentUsername == null || !this.spaceService.isMember(space, currentUsername) || exoSocialActivity == null) continue;
                    memberSpaceActivities.append(activities[i]).append(";");
                }
                news.setActivities(memberSpaceActivities.toString());
            } else {
                newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/news/detail?newsId=").append(news.getId());
                news.setUrl(newsUrl.toString());
            }
        }
        if (node.hasProperty("publication:startPublishedDate")) {
            news.setSchedulePostDate(node.getProperty("publication:startPublishedDate").getString());
        }
        if (!node.hasProperty("exo:viewsCount")) {
            news.setViewsCount(0L);
        } else {
            news.setViewsCount(node.getProperty("exo:viewsCount").getLong());
        }
        if (node.hasNode("illustration")) {
            Node illustrationContentNode = node.getNode("illustration").getNode("jcr:content");
            byte[] bytes = IOUtils.toByteArray((InputStream)illustrationContentNode.getProperty("jcr:data").getStream());
            news.setIllustration(bytes);
            news.setIllustrationUpdateDate(illustrationContentNode.getProperty("exo:dateModified").getDate().getTime());
            news.setIllustrationURL("/portal/rest/v1/news/" + news.getId() + "/illustration");
        }
        news.setAttachments(this.newsAttachmentsService.getNewsAttachments(node));
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        if (space != null) {
            String spaceName = space.getDisplayName();
            String currentUser = this.getCurrentUserId();
            boolean hiddenSpace = space.getVisibility().equals("hidden") && !this.spaceService.isMember(space, currentUser) && !this.spaceService.isSuperManager(currentUser);
            news.setHiddenSpace(hiddenSpace);
            boolean isSpaceMember = this.spaceService.isSuperManager(this.getCurrentUserId()) || this.spaceService.isMember(space, this.getCurrentUserId());
            news.setSpaceMember(isSpaceMember);
            news.setSpaceDisplayName(spaceName);
            if (StringUtils.isNotEmpty((CharSequence)space.getGroupId())) {
                String spaceGroupId = space.getGroupId().split("/")[2];
                news.setSpaceAvatarUrl(space.getAvatarUrl());
                String spaceUrl = "/portal/g/:spaces:" + spaceGroupId + "/" + space.getPrettyName();
                news.setSpaceUrl(spaceUrl);
            }
        }
        if ((identity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor(), true)) != null && identity.getProfile() != null) {
            news.setAuthorDisplayName(identity.getProfile().getFullName());
            news.setAuthorAvatarUrl(identity.getProfile().getAvatarUrl());
        }
        if ((draftUpdaterIdentity = this.identityManager.getOrCreateIdentity("organization", news.getDraftUpdater(), true)) != null && draftUpdaterIdentity.getProfile() != null) {
            news.setDraftUpdaterDisplayName(draftUpdaterIdentity.getProfile().getFullName());
        }
        return news;
    }

    void postNewsActivity(News news) throws Exception {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateIdentity("organization", news.getAuthor(), false);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("");
        activity.setBody("");
        activity.setType("news");
        activity.setUserId(poster.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("newsId", news.getId());
        activity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.updateNewsActivities((ExoSocialActivity)activity, news);
    }

    private String getNodeRelativePath(Calendar now) {
        return now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
    }

    private void attachIllustration(Node newsNode, String uploadId) throws Exception {
        UploadResource uploadedResource = this.uploadService.getUploadResource(uploadId);
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + uploadId + ", it may not exist");
        }
        boolean illustrationExists = newsNode.hasNode("illustration");
        Node illustrationNode = illustrationExists ? newsNode.getNode("illustration") : newsNode.addNode("illustration", "nt:file");
        illustrationNode.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = illustrationExists ? illustrationNode.getNode("jcr:content") : illustrationNode.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        Calendar now = Calendar.getInstance();
        resourceNode.setProperty("jcr:lastModified", now);
        resourceNode.setProperty("exo:dateModified", now);
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            newsNode.save();
        }
    }

    private void removeIllustration(Node newsNode) throws Exception {
        if (newsNode.hasNode("illustration")) {
            newsNode.getNode("illustration").remove();
            newsNode.save();
        }
    }

    private Node getSpaceNewsRootNode(String spaceId, Session session) throws RepositoryException {
        Node spaceNewsRootNode;
        Space space = this.spaceService.getSpaceById(spaceId);
        String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
        String spaceParentPath = groupPath + space.getGroupId();
        Node spaceRootNode = (Node)session.getItem(spaceParentPath);
        if (!spaceRootNode.hasNode(NEWS_NODES_FOLDER)) {
            spaceNewsRootNode = spaceRootNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            if (spaceNewsRootNode.canAddMixin("exo:privilegeable")) {
                spaceNewsRootNode.addMixin("exo:privilegeable");
            }
            HashMap<CallSite, String[]> permissions = new HashMap<CallSite, String[]>();
            permissions.put((CallSite)((Object)("*:" + space.getGroupId())), PermissionType.ALL);
            ((ExtendedNode)spaceNewsRootNode).setPermissions(permissions);
            spaceRootNode.save();
        } else {
            spaceNewsRootNode = spaceRootNode.getNode(NEWS_NODES_FOLDER);
        }
        return spaceNewsRootNode;
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private Date getDateProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    @Override
    public News createNewsDraft(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node spaceNewsRootNode = this.getSpaceNewsRootNode(news.getSpaceId(), session);
        Calendar creationCalendar = Calendar.getInstance();
        if (news.getCreationDate() != null) {
            creationCalendar.setTime(news.getCreationDate());
        } else {
            news.setCreationDate(creationCalendar.getTime());
        }
        String newsNodeName = !news.getTitle().equals("") ? news.getTitle() : "Untitled";
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(spaceNewsRootNode, this.getNodeRelativePath(creationCalendar));
        Node newsDraftNode = newsFolderNode.addNode(Utils.cleanName((String)newsNodeName).trim(), "exo:news");
        newsDraftNode.addMixin("exo:datetime");
        newsDraftNode.setProperty("exo:title", news.getTitle());
        newsDraftNode.setProperty("exo:summary", news.getSummary());
        newsDraftNode.setProperty("exo:body", news.getBody());
        newsDraftNode.setProperty("exo:author", news.getAuthor());
        newsDraftNode.setProperty("exo:dateCreated", creationCalendar);
        newsDraftNode.setProperty("exo:viewsCount", 0L);
        newsDraftNode.setProperty("exo:viewers", "");
        newsDraftNode.setProperty("exo:activities", "");
        Calendar updateCalendar = Calendar.getInstance();
        if (news.getUpdateDate() != null) {
            updateCalendar.setTime(news.getUpdateDate());
        } else {
            news.setUpdateDate(updateCalendar.getTime());
        }
        newsDraftNode.setProperty("exo:dateModified", updateCalendar);
        newsDraftNode.setProperty("exo:pinned", false);
        newsDraftNode.setProperty("exo:archived", false);
        newsDraftNode.setProperty("exo:spaceId", news.getSpaceId());
        LifecyclesConfig.Lifecycle lifecycle = this.publicationManager.getLifecycle("newsLifecycle");
        String lifecycleName = ((WebpagePublicationPlugin)this.wCMPublicationService.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
        if (newsDraftNode.canAddMixin("publication:authoring")) {
            newsDraftNode.addMixin("publication:authoring");
            newsDraftNode.setProperty(LAST_PUBLISHER, news.getAuthor());
            newsDraftNode.setProperty("publication:lifecycle", lifecycle.getName());
        }
        this.publicationService.enrollNodeInLifecycle(newsDraftNode, lifecycleName);
        this.publicationService.changeState(newsDraftNode, "draft", new HashMap());
        newsDraftNode.setProperty("exo:body", this.imageProcessor.processImages(news.getBody(), newsDraftNode, "images"));
        spaceNewsRootNode.save();
        if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
            this.attachIllustration(newsDraftNode, news.getUploadId());
        }
        news.setId(newsDraftNode.getUUID());
        return news;
    }

    @Override
    public List<NewsESSearchResult> search(org.exoplatform.social.core.identity.model.Identity currentUser, String term, int offset, int limit) {
        return this.newsESSearchConnector.search(currentUser, term, offset, limit);
    }

    private Date getPublicationDate(Node node) throws RepositoryException {
        VersionNode versionNode = new VersionNode(node, node.getSession());
        List versions = versionNode.getChildren();
        if (!versions.isEmpty()) {
            versions.sort(Comparator.comparingInt(v -> Integer.parseInt(v.getName())));
            return ((VersionNode)versions.get(0)).getCreatedTime().getTime();
        }
        return null;
    }

    private Date getLastUpdatedDate(Node node) throws RepositoryException {
        VersionNode lastUpdatedVersion = this.getLastUpdatedVersion(node);
        if (lastUpdatedVersion != null) {
            return lastUpdatedVersion.getCreatedTime().getTime();
        }
        return this.getDateProperty(node, "exo:dateModified");
    }

    private String getLastUpdater(Node node) throws RepositoryException {
        VersionNode lastUpdatedVersion = this.getLastUpdatedVersion(node);
        if (lastUpdatedVersion != null) {
            return lastUpdatedVersion.getAuthor();
        }
        return this.getStringProperty(node, "exo:lastModifier");
    }

    private VersionNode getLastUpdatedVersion(Node node) throws RepositoryException {
        VersionNode versionNode = new VersionNode(node, node.getSession());
        List versions = versionNode.getChildren();
        if (!versions.isEmpty()) {
            versions.sort(Comparator.comparingInt(v -> Integer.parseInt(v.getName())));
            return (VersionNode)versions.get(versions.size() - 1);
        }
        return null;
    }

    private String getPath(Node node) throws Exception {
        String nodePath = null;
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        if (nodeLocation != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("/").append(nodeLocation.getRepository()).append("/").append(nodeLocation.getWorkspace()).append(node.getPath());
            nodePath = Text.escapeIllegalJcrChars((String)sb.toString());
        }
        return nodePath;
    }

    @Override
    public boolean canEditNews(String posterId, String spaceId) {
        Identity currentIdentity = this.getCurrentIdentity();
        if (currentIdentity == null) {
            return false;
        }
        String authenticatedUser = currentIdentity.getUserId();
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        return authenticatedUser.equals(posterId) || this.spaceService.isSuperManager(authenticatedUser) || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.isMemberOf(currentSpace.getGroupId(), MANAGER_MEMBERSHIP_NAME);
    }

    @Override
    public News getNewsById(String newsId, String authenticatedUser, boolean editMode) throws IllegalAccessException {
        News news = this.getNewsById(newsId, editMode);
        if (editMode ? !this.canEditNews(news, authenticatedUser) : !this.canViewNews(news, authenticatedUser)) {
            throw new IllegalAccessException("User " + authenticatedUser + " is not authorized to view News");
        }
        return news;
    }

    @Override
    public News getNewsByActivityId(String activityId, String authenticatedUser) throws IllegalAccessException, ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        Identity viewerIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        if (!this.activityManager.isActivityViewable(activity, viewerIdentity)) {
            throw new IllegalAccessException("User " + authenticatedUser + " isn't allowed to access activity with id " + activityId);
        }
        Map templateParams = activity.getTemplateParams();
        if (templateParams == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        String newsId = (String)templateParams.get("newsId");
        if (StringUtils.isBlank((CharSequence)newsId)) {
            String originalActivityId = (String)templateParams.get("originalActivityId");
            if (StringUtils.isNotBlank((CharSequence)originalActivityId)) {
                org.exoplatform.social.core.identity.model.Identity sharedActivityPosterIdentity = this.identityManager.getIdentity(activity.getPosterId());
                if (sharedActivityPosterIdentity == null) {
                    throw new IllegalAccessException("Shared Activity '" + activityId + "' Poster " + activity.getPosterId() + " isn't found");
                }
                return this.getNewsByActivityId(originalActivityId, sharedActivityPosterIdentity.getRemoteId());
            }
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        return this.getNewsById(newsId, authenticatedUser, false);
    }

    @Override
    public boolean canViewNews(News news, String username) {
        try {
            Space space;
            String spaceId = news.getSpaceId();
            Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                LOG.warn("Can't find space with id {} when checking access on news with id {}", new Object[]{spaceId, news.getId()});
                return false;
            }
            if (!news.isPinned() && StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"published") && !this.spaceService.isSuperManager(username) && !this.spaceService.isMember(space, username)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !StringUtils.equals((CharSequence)news.getAuthor(), (CharSequence)username) && !this.spaceService.isManager(space, username) && !this.spaceService.isRedactor(space, username)) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving access permission for user {} on news with id {}", new Object[]{username, news.getId()});
            return false;
        }
        return true;
    }

    @Override
    public boolean canEditNews(News news, String authenticatedUser) {
        Space space;
        String spaceId = news.getSpaceId();
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.identityManager.getOrCreateUserIdentity(authenticatedUser);
        if (authenticatedUserIdentity == null) {
            LOG.warn("Can't find user with id {} when checking access on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        String posterUsername = news.getAuthor();
        if (authenticatedUser.equals(posterUsername) || this.spaceService.isSuperManager(authenticatedUser)) {
            return true;
        }
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        if (this.spaceService.isManager(currentSpace, authenticatedUser)) {
            return true;
        }
        Identity authenticatedSecurityIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        return authenticatedSecurityIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    @Override
    public boolean canPinNews() {
        Identity currentIdentity = this.getCurrentIdentity();
        if (currentIdentity == null) {
            return false;
        }
        return currentIdentity.isMemberOf(PLATFORM_ADMINISTRATORS_GROUP, "*") || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News scheduleNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News scheduledNews = null;
        try {
            Node scheduledNewsNode = session.getNodeByUUID(news.getId());
            if (scheduledNewsNode == null) {
                throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + news.getId());
            }
            String schedulePostDate = news.getSchedulePostDate();
            if (schedulePostDate != null) {
                ZoneOffset userTimeZone = StringUtils.isBlank((CharSequence)news.getTimeZoneId()) ? ZoneOffset.UTC : ZoneId.of(news.getTimeZoneId());
                String offsetTimeZone = String.valueOf(OffsetTime.now(userTimeZone).getOffset()).replace(":", "");
                schedulePostDate = schedulePostDate.concat(" ").concat(offsetTimeZone);
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ssZ");
                Calendar startPublishedDate = Calendar.getInstance();
                startPublishedDate.setTime(format.parse(schedulePostDate));
                scheduledNewsNode.setProperty("publication:startPublishedDate", startPublishedDate);
                scheduledNewsNode.setProperty(LAST_PUBLISHER, this.getCurrentUserId());
                scheduledNewsNode.save();
                this.publicationService.changeState(scheduledNewsNode, "staged", new HashMap());
            }
            scheduledNews = this.convertNodeToNews(scheduledNewsNode, false);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return scheduledNews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News cancelScheduleNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News draftNews = null;
        try {
            Node unScheduledNewsNode = session.getNodeByUUID(news.getId());
            if (unScheduledNewsNode == null) {
                throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + news.getId());
            }
            String schedulePostDate = news.getSchedulePostDate();
            if (schedulePostDate != null) {
                unScheduledNewsNode.setProperty(LAST_PUBLISHER, this.getCurrentUserId());
                unScheduledNewsNode.save();
                this.publicationService.changeState(unScheduledNewsNode, "draft", new HashMap());
            }
            draftNews = this.convertNodeToNews(unScheduledNewsNode, false);
            draftNews.setSchedulePostDate(null);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return draftNews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNewsActivities(ExoSocialActivity activity, News news) throws Exception {
        if (activity.getId() != null) {
            SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            try {
                Node newsNode;
                if (!StringUtils.isEmpty((CharSequence)news.getId()) && (newsNode = session.getNodeByUUID(news.getId())).hasProperty("exo:activities")) {
                    String updatedNewsActivities = news.getSpaceId().concat(":").concat(activity.getId());
                    newsNode.setProperty("exo:activities", updatedNewsActivities);
                    newsNode.save();
                    news.setActivities(updatedNewsActivities);
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    protected void sendNotification(News news, NotificationConstants.NOTIFICATION_CONTEXT context) throws Exception {
        String newsId = news.getId();
        String contentAuthor = news.getAuthor();
        String currentUser = this.getCurrentUserId() != null ? this.getCurrentUserId() : contentAuthor;
        String activities = news.getActivities();
        String contentTitle = news.getTitle();
        String contentBody = news.getBody();
        String lastSpaceIdActivityId = activities.split(";")[activities.split(";").length - 1];
        String contentSpaceId = lastSpaceIdActivityId.split(":")[0];
        String contentActivityId = lastSpaceIdActivityId.split(":")[1];
        Space contentSpace = this.spaceService.getSpaceById(contentSpaceId);
        boolean isMember = this.spaceService.isMember(contentSpace, contentAuthor);
        if (contentSpace == null) {
            throw new NullPointerException("Cannot find a space with id " + contentSpaceId + ", it may not exist");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", contentAuthor);
        String authorAvatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
        String illustrationURL = NotificationUtils.getNewsIllustration(news);
        String activityLink = NotificationUtils.getNotificationActivityLink(contentSpace, contentActivityId, isMember);
        String contentSpaceName = contentSpace.getDisplayName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTEXT, (Object)context).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)illustrationURL).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostNewsNotificationPlugin"))).execute(ctx);
            Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(contentBody);
            if (matcher.find()) {
                this.sendMentionInNewsNotification(contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, illustrationURL, authorAvatarUrl, activityLink, contentSpaceName);
            }
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS)) {
            this.sendMentionInNewsNotification(contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, illustrationURL, authorAvatarUrl, activityLink, contentSpaceName);
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_IN_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PublishNewsNotificationPlugin"))).execute(ctx);
        }
    }

    private void sendMentionInNewsNotification(String contentAuthor, String currentUser, String contentTitle, String contentBody, String contentSpaceId, String illustrationURL, String authorAvatarUrl, String activityLink, String contentSpaceName) {
        Set<String> mentionedIds = NewsUtils.processMentions(contentBody);
        NotificationContext mentionNotificationCtx = NotificationContextImpl.cloneInstance().append(MentionInNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)illustrationURL).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(MentionInNewsNotificationPlugin.MENTIONED_IDS, mentionedIds);
        mentionNotificationCtx.getNotificationExecutor().with(mentionNotificationCtx.makeCommand(PluginKey.key((String)"MentionInNewsNotificationPlugin"))).execute(mentionNotificationCtx);
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState != null ? ConversationState.getCurrent().getIdentity() : null;
    }

    private String getCurrentUserId() {
        Identity currentIdentity = this.getCurrentIdentity();
        return currentIdentity != null ? currentIdentity.getUserId() : null;
    }

    @Override
    public List<News> searchNews(NewsFilter filter, String lang) throws Exception {
        SearchContext context = new SearchContext(null, null);
        context.lang(lang);
        ArrayList<News> newsList = new ArrayList<News>();
        List<SearchResult> searchResults = this.newsSearchConnector.search(filter, filter.getOffset(), filter.getLimit(), "relevancy", "desc");
        searchResults.forEach(res -> {
            try {
                Node newsNode = ((NewsSearchResult)((Object)res)).getNode();
                News news = this.convertNodeToNews(newsNode, false);
                newsList.add(news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing search result in News", (Throwable)e);
            }
        });
        return newsList;
    }

    @Override
    public void archiveNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + newsId);
        }
        boolean isPinned = newsNode.getProperty("exo:pinned").getBoolean();
        if (isPinned) {
            this.unpinNews(newsId);
        }
        newsNode.setProperty("exo:archived", true);
        newsNode.save();
    }

    @Override
    public void unarchiveNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:archived", false);
        newsNode.save();
    }

    @Override
    public boolean canDeleteNews(String posterId, String spaceId) {
        Identity currentIdentity = this.getCurrentIdentity();
        if (currentIdentity == null) {
            return false;
        }
        String authenticatedUser = currentIdentity.getUserId();
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        return authenticatedUser.equals(posterId) || this.userACL.isSuperUser() || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(currentSpace, authenticatedUser);
    }

    protected String substituteUsernames(String portalOwner, String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = MENTION_PATTERN.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            org.exoplatform.social.core.identity.model.Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = this.identityManager.getOrCreateIdentity("organization", username)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink((String)username, (String)portalOwner);
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving link for profile of user {}", new Object[]{username, e});
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }

    public Node getNewsNodeById(String newsId, SessionProvider sessionProvider) throws RepositoryException, ItemNotFoundException {
        Session session = this.getSession(sessionProvider);
        Node node = session.getNodeByUUID(newsId);
        return node;
    }

    public Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        return sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
    }
}

