/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.news.notification.plugin.MentionInNewsNotificationPlugin;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class NewsUtils {
    private static final Log LOG = ExoLogger.getLogger(NewsUtils.class);
    public static final String POST_NEWS = "exo.news.postArticle";
    public static final String PUBLISH_NEWS = "exo.news.PublishArticle";

    public static void broadcastEvent(String eventName, Object source, Object data) {
        try {
            ListenerService listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error broadcasting event '" + eventName + "' using source '" + source + "' and data " + data), (Throwable)e);
        }
    }

    public static Set<String> processMentions(String body) {
        HashSet<String> mentions = new HashSet<String>();
        mentions.addAll(NewsUtils.parseMention(body));
        return mentions;
    }

    private static Set<String> parseMention(String str) {
        if (str == null || str.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> mentions = new HashSet<String>();
        Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(str);
        while (matcher.find()) {
            String remoteId = matcher.group().substring(1);
            org.exoplatform.social.core.identity.model.Identity identity = NewsUtils.loadUser(remoteId);
            if (identity == null || mentions.contains(identity.getRemoteId())) continue;
            mentions.add(identity.getRemoteId());
        }
        return mentions;
    }

    private static org.exoplatform.social.core.identity.model.Identity loadUser(String username) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (username == null || username.isEmpty()) {
            return null;
        }
        return identityManager.getOrCreateIdentity("organization", username);
    }

    public static List<Space> getRedactorOrManagerSpaces(String userId) throws Exception {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess memberSpacesListAccess = spaceService.getMemberSpaces(userId);
        List<Space> spaces = Arrays.asList((Space[])memberSpacesListAccess.load(0, memberSpacesListAccess.getSize()));
        return spaces.stream().filter(space -> spaceService.isManager(space, userId) || spaceService.isRedactor(space, userId)).collect(Collectors.toList());
    }

    public static Identity getUserIdentity(String username) {
        IdentityRegistry identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(username);
        if (identity != null) {
            return identity;
        }
        Authenticator authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        try {
            identity = authenticator.createIdentity(username);
            if (identity != null) {
                identityRegistry.register(identity);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred while retrieving security identity of user " + username);
        }
        return identity;
    }
}

