/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsGamificationIntegrationListener
extends Listener<String, String> {
    private static final Log LOG = ExoLogger.getLogger(NewsGamificationIntegrationListener.class);
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String GAMIFICATION_POST_NEWS_ARTICLE_RULE_TITLE = "PostArticle";
    public static final String GAMIFICATION_PUBLISH_NEWS_ARTICLE_RULE_TITLE = "PublishArticle";
    private PortalContainer container;
    private ListenerService listenerService;
    private NewsService newsService;

    public NewsGamificationIntegrationListener(PortalContainer container, ListenerService listenerService, NewsService newsService) {
        this.container = container;
        this.listenerService = listenerService;
        this.newsService = newsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<String, String> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String eventName = event.getEventName();
            String newsId = (String)event.getSource();
            String earnerId = (String)event.getData();
            News news = this.newsService.getNewsById(newsId, false);
            String ruleTitle = "";
            if (StringUtils.equals((CharSequence)eventName, (CharSequence)"exo.news.postArticle")) {
                ruleTitle = GAMIFICATION_POST_NEWS_ARTICLE_RULE_TITLE;
            } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"exo.news.PublishArticle")) {
                ruleTitle = GAMIFICATION_PUBLISH_NEWS_ARTICLE_RULE_TITLE;
            }
            try {
                HashMap<String, String> gamificationMap = new HashMap<String, String>();
                gamificationMap.put("ruleTitle", ruleTitle);
                gamificationMap.put("object", news.getUrl());
                gamificationMap.put("senderId", earnerId);
                gamificationMap.put("receiverId", earnerId);
                this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gamificationMap, (Object)news.getId());
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast gamification event");
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

