/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage.jcr;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsAttachment;
import org.exoplatform.news.storage.NewsAttachmentsStorage;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class JcrNewsAttachmentsStorage
implements NewsAttachmentsStorage {
    private static final Log LOG = ExoLogger.getLogger(JcrNewsAttachmentsStorage.class);
    public static final String NEWS_ATTACHMENTS_NODES_FOLDER = "News Attachments";
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private DataDistributionType dataDistributionType;
    private SpaceService spaceService;
    private UploadService uploadService;
    private DocumentService documentService;

    public JcrNewsAttachmentsStorage(SessionProviderService sessionProviderService, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager dataDistributionManager, SpaceService spaceService, UploadService uploadService, DocumentService documentService) {
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.spaceService = spaceService;
        this.uploadService = uploadService;
        this.documentService = documentService;
    }

    @Override
    public List<NewsAttachment> getNewsAttachments(Node newsNode) throws Exception {
        ArrayList<NewsAttachment> attachments = new ArrayList<NewsAttachment>();
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                attachments.add(this.convertNodeToNewsAttachment(attachmentNode));
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error while fetching attachment of News " + newsNode.getUUID()), (Throwable)e);
            }
        }
        return attachments;
    }

    @Override
    public NewsAttachment getNewsAttachment(String attachmentId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node attachmentNode = session.getNodeByUUID(attachmentId);
        if (attachmentNode != null) {
            return this.convertNodeToNewsAttachment(attachmentNode);
        }
        return null;
    }

    @Override
    public InputStream getNewsAttachmentStream(String attachmentId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node attachmentNode = session.getNodeByUUID(attachmentId);
        if (attachmentNode != null) {
            Node resourceNode = attachmentNode.getNode("jcr:content");
            return resourceNode.getProperty("jcr:data").getStream();
        }
        return null;
    }

    @Override
    public String getNewsAttachmentOpenUrl(String attachmentId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node attachmentNode = session.getNodeByUUID(attachmentId);
        if (attachmentNode != null) {
            return this.documentService.getLinkInDocumentsApp(attachmentNode.getPath());
        }
        return null;
    }

    @Override
    public List<NewsAttachment> updateNewsAttachments(News updatedNews, Node newsNode) throws Exception {
        List updatedAttachments = Optional.ofNullable(updatedNews.getAttachments()).orElse(new ArrayList());
        List<Object> existingAttachmentsIds = new ArrayList();
        if (newsNode.hasProperty("exo:attachmentsIds")) {
            Value[] attachmentsIdsProperty = newsNode.getProperty("exo:attachmentsIds").getValues();
            existingAttachmentsIds = Arrays.stream(attachmentsIdsProperty).map(value -> {
                try {
                    return value.getString();
                }
                catch (RepositoryException e) {
                    return null;
                }
            }).collect(Collectors.toList());
        }
        List updatedAttachmentsIds = updatedAttachments.stream().map(NewsAttachment::getId).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        existingAttachmentsIds.stream().filter(attachmentId -> !updatedAttachmentsIds.contains(attachmentId)).forEach(attachmentId -> this.removeAttachment(newsNode, (String)attachmentId));
        ArrayList<NewsAttachment> updatedAttachmentsWithIds = new ArrayList<NewsAttachment>();
        for (NewsAttachment updatedAttachment : updatedAttachments) {
            if (StringUtils.isEmpty((CharSequence)updatedAttachment.getId()) && StringUtils.isNotEmpty((CharSequence)updatedAttachment.getUploadId())) {
                try {
                    String newAttachmentId = this.addAttachmentFromUploadedResource(newsNode, updatedAttachment.getUploadId());
                    updatedAttachment.setId(newAttachmentId);
                    updatedAttachment.setUploadId(null);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while adding attachment to news " + updatedNews.getId()), (Throwable)e);
                }
            } else if (StringUtils.isEmpty((CharSequence)updatedAttachment.getUploadId()) && !existingAttachmentsIds.contains(updatedAttachment.getId())) {
                try {
                    this.addAttachmentFromExistingResource(newsNode, updatedAttachment.getId());
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while adding attachment to news " + updatedAttachment.getId()), (Throwable)e);
                }
            }
            updatedAttachmentsWithIds.add(updatedAttachment);
        }
        return updatedAttachmentsWithIds;
    }

    @Override
    public String addAttachmentFromUploadedResource(Node newsNode, String uploadId) throws Exception {
        UploadResource uploadedResource = this.uploadService.getUploadResource(uploadId);
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + uploadId + ", it may not exist");
        }
        if (!newsNode.hasProperty("exo:spaceId")) {
            throw new Exception("Cannot get space id of news " + newsNode.getUUID());
        }
        Node spaceNewsAttachmentsRootNode = this.getSpaceNewsAttachmentsRootNode(newsNode.getProperty("exo:spaceId").getString(), newsNode.getSession());
        Node newsAttachmentsFolderNode = this.dataDistributionType.getOrCreateDataNode(spaceNewsAttachmentsRootNode, this.getNodeRelativePath(Calendar.getInstance()));
        Node attachmentNode = newsAttachmentsFolderNode.addNode(uploadedResource.getFileName(), "nt:file");
        attachmentNode.addMixin("mix:versionable");
        attachmentNode.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = attachmentNode.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        Calendar now = Calendar.getInstance();
        resourceNode.setProperty("jcr:lastModified", now);
        resourceNode.setProperty("exo:dateModified", now);
        String fileDiskLocation = uploadedResource.getStoreLocation();
        if (fileDiskLocation != null) {
            try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
                resourceNode.setProperty("jcr:data", (InputStream)inputStream);
                newsAttachmentsFolderNode.save();
            }
        } else {
            newsAttachmentsFolderNode.save();
        }
        Object[] attachmentsIdsProperty = newsNode.hasProperty("exo:attachmentsIds") ? newsNode.getProperty("exo:attachmentsIds").getValues() : new Value[]{};
        newsNode.setProperty("exo:attachmentsIds", (Value[])ArrayUtils.add((Object[])attachmentsIdsProperty, (Object)new StringValue(attachmentNode.getUUID())));
        newsNode.save();
        return attachmentNode.getUUID();
    }

    @Override
    public void addAttachmentFromExistingResource(Node newsNode, String resourceId) throws Exception {
        Object[] attachmentsIdsProperty = newsNode.hasProperty("exo:attachmentsIds") ? newsNode.getProperty("exo:attachmentsIds").getValues() : new Value[]{};
        newsNode.setProperty("exo:attachmentsIds", (Value[])ArrayUtils.add((Object[])attachmentsIdsProperty, (Object)new StringValue(resourceId)));
        newsNode.save();
    }

    @Override
    public void makeAttachmentsPublic(Node newsNode) throws Exception {
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                if (attachmentNode.canAddMixin("exo:privilegeable")) {
                    attachmentNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)attachmentNode).setPermission("*:/platform/users", new String[]{"read"});
                attachmentNode.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot make News attachment " + attachmentNode.getUUID() + " of News " + newsNode.getUUID() + " public"), (Throwable)e);
            }
        }
    }

    @Override
    public void unmakeAttachmentsPublic(Node newsNode) throws Exception {
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                if (!attachmentNode.isNodeType("exo:privilegeable")) continue;
                ((ExtendedNode)attachmentNode).removePermission("*:/platform/users");
                attachmentNode.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot remove public access of News attachment " + attachmentNode.getUUID() + " of News " + newsNode.getUUID()), (Throwable)e);
            }
        }
    }

    @Override
    public void removeAttachment(Node newsNode, String attachmentId) {
        try {
            Session session = newsNode.getSession();
            Node attachmentNode = session.getNodeByUUID(attachmentId);
            if (attachmentNode != null) {
                attachmentNode.remove();
            }
            if (newsNode.hasProperty("exo:attachmentsIds")) {
                Object[] attachmentsIdsProperty = newsNode.getProperty("exo:attachmentsIds").getValues();
                newsNode.setProperty("exo:attachmentsIds", (Value[])ArrayUtils.removeElement((Object[])attachmentsIdsProperty, (Object)new StringValue(attachmentId)));
                newsNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting attachment node " + attachmentId), (Throwable)e);
        }
    }

    @Override
    public void shareAttachments(Node newsNode, Space space) {
        try {
            for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
                if (attachmentNode.canAddMixin("exo:privilegeable")) {
                    attachmentNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)attachmentNode).setPermission("*:" + space.getGroupId(), new String[]{"read"});
                attachmentNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot share News attachment of News " + newsNode), (Throwable)e);
        }
    }

    protected NewsAttachment convertNodeToNewsAttachment(Node attachmentNode) throws Exception {
        String mimetype = "";
        int attachmentSize = 0;
        Node resourceNode = attachmentNode.getNode("jcr:content");
        if (resourceNode != null) {
            if (resourceNode.hasProperty("jcr:mimeType")) {
                mimetype = resourceNode.getProperty("jcr:mimeType").getString();
            }
            InputStream attachmentStream = resourceNode.getProperty("jcr:data").getStream();
            byte[] attachmentBytes = IOUtils.toByteArray((InputStream)attachmentStream);
            attachmentSize = attachmentBytes.length;
        }
        NewsAttachment attachment = new NewsAttachment(attachmentNode.getUUID(), null, attachmentNode.getName(), mimetype, attachmentSize);
        return attachment;
    }

    private Node getSpaceNewsAttachmentsRootNode(String spaceId, Session session) throws RepositoryException {
        Node spaceNewsRootNode;
        Space space = this.spaceService.getSpaceById(spaceId);
        String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
        String spaceDocumentsFolderPath = groupPath + space.getGroupId() + "/Documents";
        Node spaceDocumentsFolderNode = (Node)session.getItem(spaceDocumentsFolderPath);
        if (!spaceDocumentsFolderNode.hasNode(NEWS_ATTACHMENTS_NODES_FOLDER)) {
            spaceNewsRootNode = spaceDocumentsFolderNode.addNode(NEWS_ATTACHMENTS_NODES_FOLDER, "nt:unstructured");
            if (spaceNewsRootNode.canAddMixin("exo:privilegeable")) {
                spaceNewsRootNode.addMixin("exo:privilegeable");
            }
            HashMap<Object, String[]> permissions = new HashMap<Object, String[]>();
            permissions.put("*:/platform/administrators", PermissionType.ALL);
            permissions.put("*:" + space.getGroupId(), PermissionType.ALL);
            ((ExtendedNode)spaceNewsRootNode).setPermissions(permissions);
            spaceDocumentsFolderNode.save();
        } else {
            spaceNewsRootNode = spaceDocumentsFolderNode.getNode(NEWS_ATTACHMENTS_NODES_FOLDER);
        }
        return spaceNewsRootNode;
    }

    private List<Node> getAttachmentsNodesOfNews(Node newsNode) throws Exception {
        Property attachmentsIdsProperty;
        ArrayList<Node> attachmentsNode = new ArrayList<Node>();
        if (newsNode != null && newsNode.hasProperty("exo:attachmentsIds") && (attachmentsIdsProperty = newsNode.getProperty("exo:attachmentsIds")) != null) {
            for (Value value : attachmentsIdsProperty.getValues()) {
                String attachmentId = value.getString();
                try {
                    Node attachmentNode = newsNode.getSession().getNodeByUUID(attachmentId);
                    if (attachmentNode.getPath().startsWith("/Quarantine/")) continue;
                    attachmentsNode.add(attachmentNode);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot get News attachment " + attachmentId + " of News " + newsNode.getUUID()), (Throwable)e);
                }
            }
        }
        return attachmentsNode;
    }

    private String getNodeRelativePath(Calendar now) {
        return now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
    }
}

