/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.news.rest.NewsTargetingEntity;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.metadata.model.Metadata;
import org.picocontainer.Startable;

@Path(value="v1/news/targeting")
@Api(tags={"v1/news/targeting"}, value="v1/news/targeting")
public class NewsTargetingRestResourcesV1
implements ResourceContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NewsTargetingRestResourcesV1.class);
    private NewsTargetingService newsTargetingService;
    private ScheduledExecutorService scheduledExecutor;
    private PortalContainer container;
    private Map<String, String> newsTargetToDeleteQueue = new HashMap<String, String>();

    public NewsTargetingRestResourcesV1(NewsTargetingService newsTargetingService, PortalContainer container) {
        this.newsTargetingService = newsTargetingService;
        this.container = container;
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get all news targets by a giving type", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTargets(@Context HttpServletRequest request) {
        try {
            List<NewsTargetingEntity> targets = this.newsTargetingService.getTargets();
            return Response.ok(targets).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting the news targets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="referenced")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get all news targets by a giving property", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized operation")})
    public Response getReferencedTargets(@Context HttpServletRequest request) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            List<NewsTargetingEntity> referencedTargets = this.newsTargetingService.getReferencedTargets(currentIdentity);
            return Response.ok(referencedTargets).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' is not autorized to get referenced news targets", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting the news referenced targets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{targetName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete news target", httpMethod="DELETE", response=Response.class, notes="This deletes news target", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="News target deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the news target"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteTarget(@Context HttpServletRequest request, @ApiParam(value="Target name", required=true) @PathParam(value="targetName") String targetName, @ApiParam(value="Time to effectively delete news target", required=false) @QueryParam(value="delay") long delay) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)targetName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Target name ist mandatory").build();
            }
            if (delay > 0L) {
                this.newsTargetToDeleteQueue.put(targetName, currentIdentity.getUserId());
                this.scheduledExecutor.schedule(() -> {
                    if (this.newsTargetToDeleteQueue.containsKey(targetName)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.newsTargetToDeleteQueue.remove(targetName);
                            this.newsTargetingService.deleteTargetByName(targetName, currentIdentity);
                        }
                        catch (IllegalAccessException e) {
                            LOG.warn("User '{}' is not authorized to delete the news target with name " + targetName, new Object[]{currentIdentity.getUserId(), e});
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error when deleting the news target with name " + targetName), (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.newsTargetToDeleteQueue.remove(targetName);
                this.newsTargetingService.deleteTargetByName(targetName, currentIdentity);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news target with name " + targetName), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{targetName}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Undo deleting news target if not yet effectively deleted.", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation")})
    public Response undoDeleteTarget(@Context HttpServletRequest request, @ApiParam(value="News target name identifier", required=true) @PathParam(value="targetName") String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Target name ist mandatory").build();
        }
        if (this.newsTargetToDeleteQueue.containsKey(targetName)) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            String authenticatedUser = currentIdentity.getUserId();
            String originalModifierUser = this.newsTargetToDeleteQueue.get(targetName);
            if (!originalModifierUser.equals(authenticatedUser)) {
                LOG.warn("User {} attempts to cancel deletion of a news target deleted by user {}", new Object[]{authenticatedUser, originalModifierUser});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.newsTargetToDeleteQueue.remove(targetName);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("News target with name {} was already deleted or isn't planned to be deleted" + targetName)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create news target", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation"), @ApiResponse(code=401, message="User not authorized to create news target"), @ApiResponse(code=409, message="Conflict operation")})
    public Response createNewsTarget(@Context HttpServletRequest request, @ApiParam(value="News target to create", required=true) NewsTargetingEntity newsTargetingEntity) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Metadata addedNewsTarget = this.newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
            return Response.ok((Object)addedNewsTarget).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to create a news target with name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't create a news target with the same name " + newsTargetingEntity.getName(), new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating a news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{originalTargetName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update an existing news target", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=404, message="Object not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=409, message="Conflict operation")})
    public Response updateNewsTarget(@ApiParam(value="News target to create", required=true) NewsTargetingEntity newsTargetingEntity, @ApiParam(value="Original news target name", required=true) @PathParam(value="originalTargetName") String originalTargetName) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Metadata metadata = this.newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity);
            return Response.ok((Object)metadata).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("User '{}' can't update news target with name '{}'", new Object[]{currentIdentity.getUserId(), originalTargetName, e});
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        catch (IllegalStateException e) {
            LOG.warn("The news target '{}' can't be found", new Object[]{newsTargetingEntity.getName(), e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when updating the news target with name " + newsTargetingEntity.getName()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

