/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage.jcr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.exoplatform.news.model.NewsAttachment;
import org.exoplatform.news.storage.NewsAttachmentsStorage;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;

public class JcrNewsAttachmentsStorage
implements NewsAttachmentsStorage {
    private static final Log LOG = ExoLogger.getLogger(JcrNewsAttachmentsStorage.class);
    public static final String NEWS_ATTACHMENTS_NODES_FOLDER = "News Attachments";

    @Override
    public List<NewsAttachment> getNewsAttachments(Node newsNode) throws Exception {
        ArrayList<NewsAttachment> attachments = new ArrayList<NewsAttachment>();
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                attachments.add(this.convertNodeToNewsAttachment(attachmentNode));
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error while fetching attachment of News " + newsNode.getUUID()), (Throwable)e);
            }
        }
        return attachments;
    }

    @Override
    public void makeAttachmentsPublic(Node newsNode) throws Exception {
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                if (attachmentNode.canAddMixin("exo:privilegeable")) {
                    attachmentNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)attachmentNode).setPermission("any", new String[]{"read"});
                attachmentNode.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot make News attachment " + attachmentNode.getUUID() + " of News " + newsNode.getUUID() + " public"), (Throwable)e);
            }
        }
    }

    @Override
    public void unmakeAttachmentsPublic(Node newsNode) throws Exception {
        for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
            try {
                if (!attachmentNode.isNodeType("exo:privilegeable")) continue;
                ((ExtendedNode)attachmentNode).removePermission("any");
                attachmentNode.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot remove public access of News attachment " + attachmentNode.getUUID() + " of News " + newsNode.getUUID()), (Throwable)e);
            }
        }
    }

    @Override
    public void shareAttachments(Node newsNode, Space space) {
        try {
            for (Node attachmentNode : this.getAttachmentsNodesOfNews(newsNode)) {
                if (attachmentNode.canAddMixin("exo:privilegeable")) {
                    attachmentNode.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)attachmentNode).setPermission("*:" + space.getGroupId(), new String[]{"read"});
                attachmentNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot share News attachment of News " + newsNode), (Throwable)e);
        }
    }

    private NewsAttachment convertNodeToNewsAttachment(Node attachmentNode) throws Exception {
        String mimetype = "";
        int attachmentSize = 0;
        Node resourceNode = attachmentNode.getNode("jcr:content");
        if (resourceNode != null) {
            if (resourceNode.hasProperty("jcr:mimeType")) {
                mimetype = resourceNode.getProperty("jcr:mimeType").getString();
            }
            InputStream attachmentStream = resourceNode.getProperty("jcr:data").getStream();
            byte[] attachmentBytes = IOUtils.toByteArray((InputStream)attachmentStream);
            attachmentSize = attachmentBytes.length;
        }
        NewsAttachment attachment = new NewsAttachment(attachmentNode.getUUID(), null, attachmentNode.getName(), mimetype, attachmentSize);
        return attachment;
    }

    private List<Node> getAttachmentsNodesOfNews(Node newsNode) throws Exception {
        Property attachmentsIdsProperty;
        ArrayList<Node> attachmentsNode = new ArrayList<Node>();
        if (newsNode != null && newsNode.hasProperty("exo:attachmentsIds") && (attachmentsIdsProperty = newsNode.getProperty("exo:attachmentsIds")) != null) {
            for (Value value : attachmentsIdsProperty.getValues()) {
                String attachmentId = value.getString();
                try {
                    Node attachmentNode = newsNode.getSession().getNodeByUUID(attachmentId);
                    if (attachmentNode.getPath().startsWith("/Quarantine/")) continue;
                    attachmentsNode.add(attachmentNode);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot get News attachment " + attachmentId + " of News " + newsNode.getUUID()), (Throwable)e);
                }
            }
        }
        return attachmentsNode;
    }
}

