/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;

public class NewsSpaceWebNotificationPlugin
extends SpaceWebNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(NewsSpaceWebNotificationPlugin.class);
    public static final String ID = "NewsSpaceWebNotificationPlugin";
    private ActivityManager activityManager;
    private NewsService newsService;

    public NewsSpaceWebNotificationPlugin(ActivityManager activityManager, NewsService newsService, IdentityManager identityManager, InitParams params) {
        super(identityManager, params);
        this.activityManager = activityManager;
        this.newsService = newsService;
    }

    public SpaceWebNotificationItem getSpaceApplicationItem(NotificationInfo notification) {
        MetadataObject metadataObject;
        String newsId = notification.getValueOwnerParameter("NEWS_ID");
        News news = null;
        try {
            news = this.newsService.getNewsById(newsId, false);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving news by id {}", new Object[]{newsId, e});
            return null;
        }
        if (news == null) {
            LOG.debug("News by id {} wasn't found. The space web notification will not be sent.", new Object[]{newsId});
            return null;
        }
        String activityId = news.getActivityId();
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return null;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity.isHidden()) {
            return null;
        }
        if (activity.isComment()) {
            ExoSocialActivity parentActivity = this.activityManager.getActivity(activity.getParentId());
            metadataObject = parentActivity.getMetadataObject();
        } else {
            metadataObject = activity.getMetadataObject();
        }
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(metadataObject.getType(), metadataObject.getId(), 0L, metadataObject.getSpaceId());
        spaceWebNotificationItem.setActivityId(activityId);
        if (activity.isComment()) {
            spaceWebNotificationItem.addApplicationSubItem(activity.getId());
        }
        return spaceWebNotificationItem;
    }
}

