/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.ecms.legacy.search.data.SearchContext;
import org.exoplatform.news.connector.NewsSearchConnector;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsSearchConnectorTest {
    public static final String searchType = "searchType";
    public static final String displayName = "displayName";
    @Mock
    RepositoryService repositoryService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;

    private void setCurrentUser(String name) {
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(name)));
    }

    @Test
    public void shouldGetEmptyListWhenNoNewsExists() throws Exception {
        this.setCurrentUser("root");
        InitParams initParams = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        Property searchTypeParam = new Property();
        searchTypeParam.setName(searchType);
        searchTypeParam.setValue("News");
        Property displayNameParam = new Property();
        displayNameParam.setName(displayName);
        displayNameParam.setValue("News");
        propertiesParam.setName("constructor.params");
        propertiesParam.addProperty((Object)searchTypeParam);
        propertiesParam.addProperty((Object)displayNameParam);
        initParams.addParameter((Parameter)propertiesParam);
        String searchText = "Test";
        String sort = "relevancy";
        String order = "desc";
        int offset = 0;
        int limit = 0;
        NewsSearchConnector newsSearchConnector = new NewsSearchConnector(initParams, this.sessionProviderService, this.repositoryService);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        NewsFilter filter = new NewsFilter();
        filter.setSearchText(searchText);
        QueryManager qm = (QueryManager)Mockito.mock(QueryManager.class);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)workSpace.getQueryManager()).thenReturn((Object)qm);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)qm.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        Mockito.lenient().when((Object)rowIterator.hasNext()).thenReturn((Object)false);
        List listResult = newsSearchConnector.search(filter, offset, limit, sort, order);
        Assert.assertNotNull((Object)listResult);
        Assert.assertEquals((long)0L, (long)listResult.size());
    }

    @Test
    public void shouldGetResultWhenNewsExists() throws Exception {
        this.setCurrentUser("root");
        InitParams initParams = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        Property searchTypeParam = new Property();
        searchTypeParam.setName(searchType);
        searchTypeParam.setValue("News");
        Property displayNameParam = new Property();
        displayNameParam.setName(displayName);
        displayNameParam.setValue("News");
        propertiesParam.setName("constructor.params");
        propertiesParam.addProperty((Object)searchTypeParam);
        propertiesParam.addProperty((Object)displayNameParam);
        initParams.addParameter((Parameter)propertiesParam);
        String searchText = "Test";
        String sort = "relevancy";
        String order = "desc";
        int offset = 0;
        int limit = 10;
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        NewsFilter filter = new NewsFilter();
        filter.setSearchText(searchText);
        QueryManager qm = (QueryManager)Mockito.mock(QueryManager.class);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)workSpace.getQueryManager()).thenReturn((Object)qm);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        Mockito.when((Object)qm.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Node node = (Node)Mockito.mock(Node.class);
        Row row = (Row)Mockito.mock(Row.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.lenient().when((Object)rowIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)rowIterator.nextRow()).thenReturn((Object)row);
        NewsSearchConnector newsSearchConnector = new NewsSearchConnector(initParams, this.sessionProviderService, this.repositoryService);
        List listResult = newsSearchConnector.search(filter, offset, limit, sort, order);
        Assert.assertNotNull((Object)listResult);
        Assert.assertEquals((long)1L, (long)listResult.size());
        ((NodeIterator)Mockito.verify((Object)nodeIterator, (VerificationMode)Mockito.times((int)2))).hasNext();
        ((NodeIterator)Mockito.verify((Object)nodeIterator, (VerificationMode)Mockito.times((int)1))).nextNode();
        ((RowIterator)Mockito.verify((Object)rowIterator, (VerificationMode)Mockito.times((int)1))).nextRow();
    }

    @Test
    public void shouldGetResultWhenSearchingWithQuery() throws Exception {
        this.setCurrentUser("root");
        InitParams initParams = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        Property searchTypeParam = new Property();
        searchTypeParam.setName(searchType);
        searchTypeParam.setValue("News");
        Property displayNameParam = new Property();
        displayNameParam.setName(displayName);
        displayNameParam.setValue("News");
        propertiesParam.setName("constructor.params");
        propertiesParam.addProperty((Object)searchTypeParam);
        propertiesParam.addProperty((Object)displayNameParam);
        initParams.addParameter((Parameter)propertiesParam);
        SearchContext context = (SearchContext)Mockito.mock(SearchContext.class);
        String searchText = "Test";
        String sort = "relevancy";
        String order = "desc";
        int offset = 0;
        int limit = 10;
        ArrayList<String> sites = new ArrayList<String>();
        sites.add("news");
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        Query query = (Query)Mockito.mock(QueryImpl.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        NewsSearchConnector newsSearchConnector = new NewsSearchConnector(initParams, this.sessionProviderService, this.repositoryService);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Node node = (Node)Mockito.mock(Node.class);
        Row row = (Row)Mockito.mock(Row.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node);
        Mockito.when((Object)node.hasNode(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.when((Object)rowIterator.nextRow()).thenReturn((Object)row);
        Collection ret = newsSearchConnector.search(context, searchText, sites, offset, limit, sort, order);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((long)1L, (long)ret.size());
    }
}

