/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import java.util.Arrays;
import java.util.HashSet;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.listener.NewsMetadataListener;
import org.exoplatform.news.model.News;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsMetadataListenerTest {
    private static final String USERNAME = "testuser";
    @Mock
    private IndexingService indexingService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private TagService tagService;

    @Test
    public void testCreateNewsTagsWhenNewsSaved() throws Exception {
        NewsMetadataListener newsMetadataListener = new NewsMetadataListener(this.indexingService, this.spaceService, this.identityManager, this.tagService);
        String newsId = "newsId";
        String spaceId = "spaceId";
        String content = "Test #tag1 Test #tag2.";
        News news = (News)Mockito.mock(News.class);
        Mockito.when((Object)news.getId()).thenReturn((Object)newsId);
        Mockito.when((Object)news.getSpaceId()).thenReturn((Object)spaceId);
        Mockito.when((Object)news.getBody()).thenReturn((Object)content);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((News)event.getData())).thenReturn((Object)news);
        Mockito.when((Object)((String)event.getSource())).thenReturn((Object)USERNAME);
        HashSet<TagName> contentTags = new HashSet<TagName>(Arrays.asList(new TagName("tag1"), new TagName("tag2")));
        String spacePrettyName = "spacePrettyName";
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getPrettyName()).thenReturn((Object)spacePrettyName);
        Mockito.when((Object)this.spaceService.getSpaceById(spaceId)).thenReturn((Object)space);
        String spaceIdentityId = "200";
        Identity spaceIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)spaceIdentity.getId()).thenReturn((Object)spaceIdentityId);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(spacePrettyName)).thenReturn((Object)spaceIdentity);
        String userIdentityId = "300";
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)userIdentityId);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.tagService.detectTagNames(content)).thenReturn(contentTags);
        newsMetadataListener.onEvent(event);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("news", newsId);
        ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)1))).saveTags(new TagObject("news", news.getId(), null), contentTags, Long.parseLong(spaceIdentityId), Long.parseLong(userIdentityId));
    }
}

