/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.io.Serializable;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.plugin.PublishNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PublishNewsNotificationPluginTest {
    private static MockedStatic<CommonsUtils> COMMONS_UTILS;
    private static MockedStatic<WCMCoreUtils> WCM_CORE_UTILS;
    private static MockedStatic<IdGenerator> ID_GENERATOR;
    private static MockedStatic<PluginKey> PLUGIN_KEY;
    private static MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT;
    @Mock
    private InitParams initParams;
    @Mock
    SpaceService spaceService;

    @BeforeClass
    public static void beforeRunBare() throws Exception {
        COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
        WCM_CORE_UTILS = Mockito.mockStatic(WCMCoreUtils.class);
        ID_GENERATOR = Mockito.mockStatic(IdGenerator.class);
        PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
        EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        WCM_CORE_UTILS.close();
        ID_GENERATOR.close();
        PLUGIN_KEY.close();
        EXO_CONTAINER_CONTEXT.close();
    }

    @Test
    public void shouldMakeNotificationForPublishNewsContext() throws Exception {
        PublishNewsNotificationPlugin newsPlugin = new PublishNewsNotificationPlugin(this.initParams, this.spaceService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)"title").append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)"root").append(PostNewsNotificationPlugin.CURRENT_USER, (Object)"root").append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)"1").append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)"space1").append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)"http://localhost:8080/rest/v1/news/id123/illustration").append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/intranet/activity?id=38").append(PostNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_NEWS).append(PostNewsNotificationPlugin.AUDIENCE, (Object)"all");
        ID_GENERATOR.when(() -> IdGenerator.generate()).thenReturn((Object)"123456");
        PublishNewsNotificationPluginTest.mockIdGeneratorService();
        NotificationInfo notificationInfo = newsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("CONTENT_TITLE"));
        Assert.assertEquals((Object)"http://localhost:8080/rest/v1/news/id123/illustration", (Object)notificationInfo.getValueOwnerParameter("ILLUSTRATION_URL"));
        Assert.assertEquals((Object)"space1", (Object)notificationInfo.getValueOwnerParameter("CONTENT_SPACE"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/intranet/activity?id=38", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }

    public static void mockIdGeneratorService() {
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn((Object)new IDGeneratorService(){

            public String generateStringID(Object o) {
                return "123456";
            }

            public long generateLongID(Object o) {
                return 123456L;
            }

            public Serializable generateID(Object o) {
                return Integer.valueOf(123456);
            }

            public int generatIntegerID(Object o) {
                return 123456;
            }
        });
    }
}

