/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.util.Arrays;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.news.model.News;
import org.exoplatform.news.notification.plugin.NewsSpaceWebNotificationPlugin;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsSpaceWebNotificationPluginTest {
    private static final String ACTIVITY_NOTIFICATION_PLUGIN_ID = "ACTIVITY_NOTIFICATION";
    private static final String USERNAME = "username";
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private InitParams initParams;
    @Mock
    private NewsService newsService;
    private static NewsSpaceWebNotificationPlugin newsSpaceWebNotificationPlugin;

    @Before
    public void setUp() throws Exception {
        ValuesParam pluginIdsValues = new ValuesParam();
        pluginIdsValues.setValues(Arrays.asList(ACTIVITY_NOTIFICATION_PLUGIN_ID));
        Mockito.when((Object)this.initParams.getValuesParam("notification.plugin.ids")).thenReturn((Object)pluginIdsValues);
        newsSpaceWebNotificationPlugin = new NewsSpaceWebNotificationPlugin(this.activityManager, this.newsService, this.identityManager, this.initParams);
    }

    @Test
    public void testGetSpaceApplicationItem() throws Exception {
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        String activityId = "activityId";
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        MetadataObject metadataObject = (MetadataObject)Mockito.mock(MetadataObject.class);
        News news = (News)Mockito.mock(News.class);
        long spaceId = 12L;
        long userIdentityId = 15L;
        String newsId = "newsId";
        String metadataObjectType = "activity";
        String metadataObjectId = activityId;
        Mockito.when((Object)notificationInfo.getValueOwnerParameter("NEWS_ID")).thenReturn((Object)newsId);
        Mockito.when((Object)this.newsService.getNewsById(newsId, false)).thenReturn((Object)news);
        Mockito.when((Object)news.getActivityId()).thenReturn((Object)activityId);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)String.valueOf(userIdentityId));
        Mockito.when((Object)this.activityManager.getActivity(activityId)).thenReturn((Object)activity);
        Mockito.when((Object)activity.getMetadataObject()).thenReturn((Object)metadataObject);
        Mockito.when((Object)metadataObject.getType()).thenReturn((Object)metadataObjectType);
        Mockito.when((Object)metadataObject.getId()).thenReturn((Object)metadataObjectId);
        Mockito.when((Object)metadataObject.getSpaceId()).thenReturn((Object)spaceId);
        SpaceWebNotificationItem spaceApplicationItem = newsSpaceWebNotificationPlugin.getSpaceApplicationItem(notificationInfo, USERNAME);
        Assert.assertNotNull((Object)spaceApplicationItem);
        Assert.assertEquals((Object)activityId, (Object)spaceApplicationItem.getApplicationItemId());
        Assert.assertEquals((Object)metadataObjectType, (Object)spaceApplicationItem.getApplicationName());
        Assert.assertEquals((long)spaceId, (long)spaceApplicationItem.getSpaceId());
        Assert.assertEquals((long)userIdentityId, (long)spaceApplicationItem.getUserId());
    }
}

