/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.search;

import java.util.Date;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.news.model.News;
import org.exoplatform.news.search.NewsIndexingServiceConnector;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsIndexingServiceConnectorTest {
    NewsIndexingServiceConnector newsIndexingServiceConnector = null;
    @Mock
    NewsService newsService;
    @Mock
    IdentityManager identityManager;
    @Mock
    ActivityManager activityManager;
    @Mock
    MetadataService metadataService;

    @Test
    public void testGetAllIds() {
        this.newsIndexingServiceConnector = new NewsIndexingServiceConnector(this.identityManager, this.getParams(), this.newsService, this.activityManager, this.metadataService);
        try {
            this.newsIndexingServiceConnector.getAllIds(0, 10);
            Assert.fail((String)"getAllIds shouldn't be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testCreate() {
        this.newsIndexingServiceConnector = new NewsIndexingServiceConnector(this.identityManager, this.getParams(), this.newsService, this.activityManager, this.metadataService);
        try {
            this.newsIndexingServiceConnector.create(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.newsIndexingServiceConnector.create("1");
            Assert.fail((String)"IllegalStateException should be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        News news = new News();
        news.setId("1");
        news.setTitle("news1");
        news.setAuthor("root");
        news.setCreationDate(new Date());
        news.setUpdateDate(new Date());
        news.setActivities("1:1;1:2;1:3");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("1");
        activity.setParentId("2");
        activity.setParentCommentId("3");
        activity.setType("type");
        activity.setPosterId("posterId");
        activity.setPostedTime(Long.valueOf(1234L));
        activity.setUpdated(Long.valueOf(4321L));
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activity.setActivityStream((ActivityStream)activityStream);
        activityStream.setId("id");
        activityStream.setPrettyId("prettyId");
        activityStream.setType(ActivityStream.Type.SPACE);
        Identity posterIdentity = new Identity("posterId");
        Profile posterProfile = new Profile(posterIdentity);
        posterProfile.setProperty("fullName", (Object)"Root Root");
        posterIdentity.setProfile(posterProfile);
        try {
            Mockito.when((Object)this.newsService.getNewsById("1", false)).thenReturn((Object)news);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)posterIdentity);
        Mockito.when((Object)this.activityManager.getActivity("1")).thenReturn((Object)activity);
        Identity streamOwner = new Identity("streamOwner");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity(ActivityStream.Type.SPACE.getProviderId(), "prettyId")).thenReturn((Object)streamOwner);
        Document document = this.newsIndexingServiceConnector.create("1");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"1", (Object)document.getId());
        Assert.assertEquals((Object)"root", document.getFields().get("posterId"));
        Assert.assertEquals((Object)"Root Root", document.getFields().get("posterName"));
        Assert.assertNotNull((Object)document.getLastUpdatedDate());
        Assert.assertNotNull((Object)document.getPermissions());
        Assert.assertEquals((long)1L, (long)document.getPermissions().size());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        params.addParameter((Parameter)propertiesParam);
        propertiesParam.setProperty("index_current", "index_name");
        return params;
    }
}

