/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.listener.MetadataItemModified;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataItemModifiedTest {
    @Mock
    private IndexingService indexingService;
    @Mock
    private NewsService newsService;
    @Mock
    private CachedActivityStorage activityStorage;

    @Test
    public void testNoInteractionWhenMetadataNotForNews() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.newsService, this.indexingService, (ActivityStorage)this.activityStorage);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        Mockito.when((Object)((MetadataItem)event.getData()).getObjectType()).thenReturn((Object)"activity");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)"1");
        metadataItemModified.onEvent(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testReindexNewsWhenNewsSetAsFavorite() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.newsService, this.indexingService, (ActivityStorage)this.activityStorage);
        String newsId = "100";
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getObjectType()).thenReturn((Object)"news");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)newsId);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        News news = new News();
        news.setId(newsId);
        Mockito.when((Object)this.newsService.getNewsById((String)ArgumentMatchers.eq((Object)newsId), ArgumentMatchers.anyBoolean())).thenReturn((Object)news);
        metadataItemModified.onEvent(event);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).getNewsById(newsId, false);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("news", newsId);
    }

    @Test
    public void testCleanNewsActivityCacheWhenMarkAsFavorite() throws Exception {
        MetadataItemModified metadataItemModified = new MetadataItemModified(this.newsService, this.indexingService, (ActivityStorage)this.activityStorage);
        String newsId = "200";
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getObjectType()).thenReturn((Object)"news");
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)newsId);
        Event event = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)((MetadataItem)event.getData())).thenReturn((Object)metadataItem);
        String activityId = "activityId";
        News news = new News();
        news.setId(newsId);
        news.setActivityId(activityId);
        Mockito.when((Object)this.newsService.getNewsById((String)ArgumentMatchers.eq((Object)newsId), ArgumentMatchers.anyBoolean())).thenReturn((Object)news);
        metadataItemModified.onEvent(event);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).getNewsById(newsId, false);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).reindex("news", newsId);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCached(activityId);
    }
}

