/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.provider;

import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.notification.provider.MailTemplateProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MailTemplateProviderTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<PluginKey> PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
    private static final MockedStatic<NotificationPluginUtils> NOTIFICATION_PLUGIN_UTILS = Mockito.mockStatic(NotificationPluginUtils.class);
    private static final MockedStatic<TemplateContext> TEMPLATE_CONTEXT = Mockito.mockStatic(TemplateContext.class);
    private static final MockedStatic<PropertyManager> PROPERTY_MANAGER = Mockito.mockStatic(PropertyManager.class);
    private static final MockedStatic<HTMLEntityEncoder> HTML_ENTITY_ENCODER = Mockito.mockStatic(HTMLEntityEncoder.class);
    private static final MockedStatic<NotificationMessageUtils> NOTIFICATION_MESSAGE_UTILS = Mockito.mockStatic(NotificationMessageUtils.class);
    private static final MockedStatic<TimeConvertUtils> TIME_CONVERT_UTILS = Mockito.mockStatic(TimeConvertUtils.class);
    private static final MockedStatic<TemplateUtils> TEMPLATE_UTILS = Mockito.mockStatic(TemplateUtils.class);
    private static final MockedStatic<NotificationContextImpl> NOTIFICATION_CONTEXT_IMPL = Mockito.mockStatic(NotificationContextImpl.class);
    private static final MockedStatic<LinkProviderUtils> LINK_PROVIDER_UTILS = Mockito.mockStatic(LinkProviderUtils.class);
    @Mock
    private InitParams initParams;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        PLUGIN_KEY.close();
        NOTIFICATION_PLUGIN_UTILS.close();
        TEMPLATE_CONTEXT.close();
        PROPERTY_MANAGER.close();
        HTML_ENTITY_ENCODER.close();
        NOTIFICATION_MESSAGE_UTILS.close();
        TIME_CONVERT_UTILS.close();
        TEMPLATE_UTILS.close();
        LINK_PROVIDER_UTILS.close();
        NOTIFICATION_CONTEXT_IMPL.close();
    }

    @Test
    public void shouldInstantiateMailTemplate() {
        COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)ArgumentMatchers.any()))).thenReturn(null);
        PluginKey plugin = (PluginKey)Mockito.mock(PluginKey.class);
        PLUGIN_KEY.when(() -> PluginKey.key((String)"PostNewsNotificationPlugin")).thenReturn((Object)plugin);
        ValueParam channelParam = new ValueParam();
        channelParam.setName("channel-id");
        channelParam.setValue("MAIL_CHANNEL");
        Mockito.when((Object)this.initParams.getValueParam("channel-id")).thenReturn((Object)channelParam);
        MailTemplateProvider mailTemplate = new MailTemplateProvider(this.initParams, this.identityManager, this.spaceService);
        MailTemplateProvider.TemplateBuilder templateBuilder = (MailTemplateProvider.TemplateBuilder)mailTemplate.getTemplateBuilder().get(plugin);
        NotificationContext ctx = (NotificationContext)Mockito.mock(NotificationContext.class);
        NOTIFICATION_CONTEXT_IMPL.when(() -> NotificationContextImpl.cloneInstance()).thenReturn((Object)ctx);
        NotificationInfo notification = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        Mockito.when((Object)ctx.getNotificationInfo()).thenReturn((Object)notification);
        Mockito.when((Object)notification.getKey()).thenReturn((Object)plugin);
        Mockito.when((Object)plugin.getId()).thenReturn((Object)"PostNewsNotificationPlugin");
        NOTIFICATION_PLUGIN_UTILS.when(() -> NotificationPluginUtils.getLanguage((String)ArgumentMatchers.anyString())).thenReturn((Object)"en");
        TemplateContext templateContext = (TemplateContext)Mockito.mock(TemplateContext.class);
        TEMPLATE_CONTEXT.when(() -> TemplateContext.newChannelInstance((ChannelKey)((ChannelKey)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.eq((Object)"PostNewsNotificationPlugin")), (String)((String)ArgumentMatchers.eq((Object)"en")))).thenReturn((Object)templateContext);
        Mockito.when((Object)notification.getValueOwnerParameter("CONTENT_AUTHOR")).thenReturn((Object)"jean");
        Mockito.when((Object)notification.getValueOwnerParameter("CURRENT_USER")).thenReturn((Object)"root");
        Mockito.when((Object)notification.getValueOwnerParameter("CONTENT_TITLE")).thenReturn((Object)"title");
        Mockito.when((Object)notification.getValueOwnerParameter("CONTENT_SPACE")).thenReturn((Object)"space1");
        PROPERTY_MANAGER.when(() -> PropertyManager.getProperty((String)"gatein.email.domain.url")).thenReturn((Object)"http://localhost:8080");
        Mockito.when((Object)notification.getValueOwnerParameter("CONTENT_SPACE")).thenReturn((Object)"space1");
        Mockito.when((Object)notification.getValueOwnerParameter("CONTEXT")).thenReturn((Object)"COMMENT MY NEWS");
        Mockito.when((Object)notification.getValueOwnerParameter("ACTIVITY_LINK")).thenReturn((Object)"http://localhost:8080/portal/intranet/activity?id=39");
        HTMLEntityEncoder encoder = (HTMLEntityEncoder)Mockito.mock(HTMLEntityEncoder.class);
        HTML_ENTITY_ENCODER.when(() -> HTMLEntityEncoder.getInstance()).thenReturn((Object)encoder);
        Mockito.when((Object)encoder.encode("title")).thenReturn((Object)"title");
        Mockito.when((Object)encoder.encode("space1")).thenReturn((Object)"space1");
        Mockito.when((Object)encoder.encode("jean")).thenReturn((Object)"jean");
        Mockito.when((Object)encoder.encode("http://localhost:8080/news/images/newsImageDefault.png")).thenReturn((Object)"http://localhost:8080/news/images/newsImageDefault.png");
        Mockito.when((Object)encoder.encode("COMMENT MY NEWS")).thenReturn((Object)"COMMENT MY NEWS");
        Mockito.when((Object)encoder.encode("http://localhost:8080/portal/intranet/activity?id=39")).thenReturn((Object)"http://localhost:8080/portal/intranet/activity?id=39");
        Mockito.when((Object)notification.getValueOwnerParameter("read")).thenReturn((Object)"true");
        Mockito.when((Object)notification.getId()).thenReturn((Object)"NotifId123");
        Date date = new Date();
        Long time = date.getTime();
        Mockito.when((Object)notification.getLastModifiedDate()).thenReturn((Object)time);
        TIME_CONVERT_UTILS.when(() -> TimeConvertUtils.convertXTimeAgoByTimeServer((Date)date, (String)"EE, dd yyyy", (Locale)new Locale("en"), (int)TimeConvertUtils.YEAR)).thenReturn((Object)"9-11-2019");
        Mockito.when((Object)notification.getTo()).thenReturn((Object)"jean");
        Identity receiverIdentity = new Identity("organization", "jean");
        receiverIdentity.setRemoteId("jean");
        Profile profile = new Profile(receiverIdentity);
        receiverIdentity.setProfile(profile);
        profile.setProperty("firstName", (Object)"jean");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "jean")).thenReturn((Object)receiverIdentity);
        Mockito.when((Object)encoder.encode("jean")).thenReturn((Object)"jean");
        LINK_PROVIDER_UTILS.when(() -> LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)"jean")).thenReturn((Object)"http://localhost:8080//portal/intranet/allNotifications");
        TEMPLATE_UTILS.when(() -> TemplateUtils.processSubject((TemplateContext)templateContext)).thenReturn((Object)"Root Root has posted an article on space1 space");
        TEMPLATE_UTILS.when(() -> TemplateUtils.processGroovy((TemplateContext)templateContext)).thenReturn((Object)"Root Root has posted an article \"title\" in the space1 space");
        Mockito.when((Object)templateContext.getException()).thenReturn(null);
        MessageInfo messageInfo = templateBuilder.makeMessage(ctx);
        Assert.assertNotNull((Object)messageInfo);
        Assert.assertEquals((Object)"Root Root has posted an article \"title\" in the space1 space", (Object)messageInfo.getBody());
        Assert.assertEquals((Object)"Root Root has posted an article on space1 space", (Object)messageInfo.getSubject());
    }
}

