/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.utils;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.model.News;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.social.core.space.model.Space;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NotificationUtilsTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    private static final MockedStatic<PropertyManager> PROPERTY_MANAGER = Mockito.mockStatic(PropertyManager.class);

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        PORTAL_CONTAINER.close();
        PROPERTY_MANAGER.close();
    }

    @Test
    public void shouldGetTheSpaceUrlWhenTheUserIsNotMember() {
        Space space1 = new Space();
        space1.setId("3");
        space1.setDisplayName("space1");
        space1.setPrettyName("space1");
        space1.setGroupId("space1");
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        PROPERTY_MANAGER.when(() -> PropertyManager.getProperty((String)"gatein.email.domain.url")).thenReturn((Object)"http://localhost:8080");
        String activityUrl = NotificationUtils.getNotificationActivityLink((Space)space1, (String)"13", (boolean)false);
        Assert.assertEquals((Object)"http://localhost:8080/portal/g/:spaces:space1/space1", (Object)activityUrl);
    }

    @Test
    public void shouldGetTheSpaceUrlWhenTheUserIsNotMemberAndAfterUpdatingSpaceName() {
        Space space = new Space();
        space.setId("4");
        space.setDisplayName("Space1");
        space.setPrettyName(space.getDisplayName());
        space.setGroupId("space1");
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        PROPERTY_MANAGER.when(() -> PropertyManager.getProperty((String)"gatein.email.domain.url")).thenReturn((Object)"http://localhost:8080");
        String activityUrl = NotificationUtils.getNotificationActivityLink((Space)space, (String)"13", (boolean)false);
        Assert.assertEquals((Object)"http://localhost:8080/portal/g/:spaces:space1/space1", (Object)activityUrl);
        Space updatedSpace = space;
        updatedSpace.setDisplayName("Space One");
        updatedSpace.setPrettyName(updatedSpace.getDisplayName());
        activityUrl = NotificationUtils.getNotificationActivityLink((Space)updatedSpace, (String)"13", (boolean)false);
        Assert.assertEquals((Object)"http://localhost:8080/portal/g/:spaces:space1/space_one", (Object)activityUrl);
    }

    @Test
    public void shouldGetTheDefaultIllustrationWhenTheNodeHasNotIllustration() throws Exception {
        SessionProviderService sessionProviderService = (SessionProviderService)Mockito.mock(SessionProviderService.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(SessionProviderService.class)).thenReturn((Object)sessionProviderService);
        RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(RepositoryService.class)).thenReturn((Object)repositoryService);
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getNodeByUUID("id123")).thenReturn((Object)node);
        Mockito.when((Object)node.hasNode("illustration")).thenReturn((Object)false);
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentDomain()).thenReturn((Object)"http://localhost:8080");
        News news = new News();
        news.setId("id123");
        String illustrationUrl = NotificationUtils.getNewsIllustration((News)news, (Session)session);
        Assert.assertEquals((Object)"http://localhost:8080/news/images/news.png", (Object)illustrationUrl);
    }
}

