/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.model.News;
import org.exoplatform.news.search.NewsESSearchConnector;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.service.impl.NewsServiceImpl;
import org.exoplatform.news.storage.NewsStorage;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.upload.UploadService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NewsServiceImplTest {
    private static final MockedStatic<NewsUtils> NEWS_UTILS = Mockito.mockStatic(NewsUtils.class);
    private static final MockedStatic<Utils> SOCIAL_UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    private NewsStorage newsStorage;
    @Mock
    private SpaceService spaceService;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NewsESSearchConnector newsESSearchConnector;
    @Mock
    private IndexingService indexingService;
    @Mock
    private UserACL userACL;
    @Mock
    private NewsTargetingService newsTargetingService;
    @Mock
    private UploadService uploadService;
    @Mock
    private MetadataService metadataService;
    private NewsService newsService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        NEWS_UTILS.close();
        SOCIAL_UTILS.close();
    }

    @Before
    public void setUp() {
        this.newsService = new NewsServiceImpl(this.spaceService, this.activityManager, this.identityManager, this.uploadService, this.newsESSearchConnector, this.indexingService, this.newsStorage, this.userACL, this.newsTargetingService, this.metadataService);
    }

    @Test
    public void markAsRead() throws Exception {
        News news = new News();
        news.setId("1");
        news.setViewsCount(Long.valueOf(2L));
        Mockito.when((Object)this.newsStorage.isCurrentUserInNewsViewers(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true, (Object[])new Boolean[]{false});
        ((NewsStorage)Mockito.doNothing().when((Object)this.newsStorage)).markAsRead((News)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        this.newsService.markAsRead(news, "user");
        NEWS_UTILS.verify(() -> NewsUtils.broadcastEvent((String)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.any(), (Object)ArgumentMatchers.any()), Mockito.atLeastOnce());
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)0))).markAsRead(news, "user");
        this.newsService.markAsRead(news, "user");
        NEWS_UTILS.verify(() -> NewsUtils.broadcastEvent((String)ArgumentMatchers.anyString(), (Object)ArgumentMatchers.any(), (Object)ArgumentMatchers.any()), Mockito.atLeastOnce());
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)1))).markAsRead(news, "user");
    }

    @Test
    public void testUpdateNews() throws Exception {
        LinkedList<String> oldTargets = new LinkedList<String>();
        oldTargets.add("sliderNews");
        LinkedList<String> newTargets = new LinkedList<String>();
        newTargets.add("newsTarget");
        News originalNews = new News();
        originalNews.setTitle("title");
        originalNews.setAuthor("root");
        originalNews.setId("id123");
        originalNews.setSpaceId("3");
        originalNews.setActivities("3:39;");
        originalNews.setActivityId("10");
        originalNews.setPublished(false);
        originalNews.setPublicationState("archived");
        News news = new News();
        news.setTitle("title");
        news.setAuthor("root");
        news.setId("id123");
        news.setSpaceId("3");
        news.setActivities("3:39;");
        news.setActivityId("10");
        news.setPublished(false);
        news.setPublicationState("draft");
        news.setCanPublish(false);
        news.setTargets(newTargets);
        Identity identity = new Identity("1");
        org.exoplatform.social.core.identity.model.Identity rootIdentity = new org.exoplatform.social.core.identity.model.Identity("1");
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)"root");
        rootIdentity.setProfile(currentProfile);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)rootIdentity);
        Space space = new Space();
        space.setId(news.getSpaceId());
        space.setGroupId("/spaces/test_space");
        space.setPrettyName("space_test");
        ((NewsTargetingService)Mockito.doNothing().when((Object)this.newsTargetingService)).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.doNothing().when((Object)this.newsTargetingService)).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(news.getId())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.newsStorage.getNewsById(news.getId(), false)).thenReturn((Object)originalNews);
        Mockito.when((Object)this.newsStorage.updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString())).thenReturn((Object)originalNews);
        ((NewsTargetingService)Mockito.doNothing().when((Object)this.newsTargetingService)).deleteNewsTargets(news.getId());
        ((NewsTargetingService)Mockito.doNothing().when((Object)this.newsTargetingService)).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        NEWS_UTILS.when(() -> NewsUtils.processMentions((String)ArgumentMatchers.anyString(), (Space)((Space)ArgumentMatchers.any()))).thenReturn(new HashSet());
        NEWS_UTILS.when(() -> NewsUtils.getUserIdentity((String)ArgumentMatchers.anyString())).thenReturn((Object)identity);
        NEWS_UTILS.when(() -> NewsUtils.canPublishNews((String)ArgumentMatchers.anyString(), (Identity)((Identity)ArgumentMatchers.any(Identity.class)))).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.getSpaceById(news.getSpaceId())).thenReturn(null);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.newsService.updateNews(news, "root", Boolean.valueOf(false), false));
        Mockito.when((Object)this.spaceService.getSpaceById(news.getSpaceId())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.canRedactOnSpace((Space)ArgumentMatchers.any(Space.class), (Identity)ArgumentMatchers.any(Identity.class))).thenReturn((Object)true);
        this.newsService.updateNews(news, "root", Boolean.valueOf(false), false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)1))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.newsStorage.getNewsById(news.getId(), false)).thenReturn((Object)originalNews);
        news.setTitle("title updated");
        this.newsService.updateNews(news, "root", null, false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)2))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        news.setSummary("summary updated");
        this.newsService.updateNews(news, "root", null, false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)3))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        news.setBody("body updated");
        this.newsService.updateNews(news, "root", null, false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)4))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)0))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        news.setPublished(false);
        news.setPublicationState("archived");
        news.setCanPublish(true);
        this.newsService.updateNews(news, "root", null, true);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)5))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)2))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)2))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(news.getId())).thenReturn(oldTargets);
        originalNews.setPublished(true);
        originalNews.setTargets(oldTargets);
        Mockito.when((Object)this.newsStorage.getNewsById(news.getId(), false)).thenReturn((Object)originalNews);
        this.newsService.updateNews(news, "root", null, false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)6))).updateNews((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)3))).deleteNewsTargets((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyString());
        ((NewsTargetingService)Mockito.verify((Object)this.newsTargetingService, (VerificationMode)Mockito.times((int)2))).saveNewsTarget((News)ArgumentMatchers.any(News.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyList(), ArgumentMatchers.anyString());
    }

    @Test
    public void testDeleteNews() throws Exception {
        News news = new News();
        news.setId("id123");
        news.setSpaceId("1");
        Identity identity = new Identity("1");
        org.exoplatform.social.core.identity.model.Identity rootIdentity = new org.exoplatform.social.core.identity.model.Identity("1");
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)"root");
        rootIdentity.setProfile(currentProfile);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)rootIdentity);
        NEWS_UTILS.when(() -> NewsUtils.getUserIdentity((String)ArgumentMatchers.anyString())).thenReturn((Object)identity);
        Space space = new Space();
        space.setId(news.getSpaceId());
        space.setGroupId("/spaces/test_space");
        space.setPrettyName("space_test");
        Mockito.when((Object)this.spaceService.getSpaceById(news.getSpaceId())).thenReturn((Object)space);
        Mockito.when((Object)this.newsStorage.getNewsById(news.getId(), false)).thenReturn((Object)news);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.newsService.deleteNews(news.getId(), identity, false));
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)1))).getNewsById(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)0))).deleteMetadataItemsByObject((MetadataObject)ArgumentMatchers.any(MetadataObject.class));
        news.setAuthor(identity.getUserId());
        Mockito.when((Object)this.newsStorage.getNewsById(news.getId(), false)).thenReturn((Object)news);
        this.newsService.deleteNews(news.getId(), identity, false);
        ((NewsStorage)Mockito.verify((Object)this.newsStorage, (VerificationMode)Mockito.times((int)2))).getNewsById(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteMetadataItemsByObject((MetadataObject)ArgumentMatchers.any(MetadataObject.class));
    }
}

