/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsTargetObject;
import org.exoplatform.news.rest.NewsTargetingEntity;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.service.impl.NewsTargetingServiceImpl;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.rest.api.RestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsTargetingImplTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<RestUtils> REST_UTILS = Mockito.mockStatic(RestUtils.class);
    @Mock
    MetadataService metadataService;
    @Mock
    IdentityManager identityManager;
    @Mock
    IdentityRegistry identityRegistry;
    @Mock
    SpaceService spaceService;
    @Mock
    Space space;
    @Mock
    ExoContainer container;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private GroupHandler groupHandler;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
        REST_UTILS.close();
    }

    @Test
    public void testGetAllTargets() throws Exception {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        IdentityRegistry identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)identityRegistry);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"root");
        Mockito.when((Object)identityRegistry.getIdentity("root")).thenReturn((Object)identity);
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        newsTargets.add(sliderNews);
        Metadata latestNews = new Metadata();
        latestNews.setName("latestNews");
        latestNews.setCreatedDate(200L);
        HashMap<String, String> latestNewsProperties = new HashMap<String, String>();
        latestNewsProperties.put("label", "latest news");
        latestNews.setProperties(latestNewsProperties);
        latestNews.setId(2L);
        newsTargets.add(latestNews);
        Metadata testNews = new Metadata();
        testNews.setName("testNews");
        testNews.setCreatedDate(300L);
        HashMap<String, String> testNewsProperties = new HashMap<String, String>();
        testNewsProperties.put("label", "test news");
        testNewsProperties.put("permissions", "space:1");
        testNews.setProperties(testNewsProperties);
        testNews.setId(3L);
        newsTargets.add(testNews);
        Space space = new Space();
        space.setId("1");
        space.setDisplayName("Space1");
        space.setPrettyName("space1");
        space.setAvatarUrl("");
        Mockito.when((Object)this.metadataService.getMetadatas(metadataType.getName(), 0L)).thenReturn(newsTargets);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        List allTargets = newsTargetingService.getAllTargets();
        Assert.assertNotNull((Object)allTargets);
        Assert.assertEquals((long)3L, (long)allTargets.size());
        Assert.assertEquals((Object)"sliderNews", (Object)((NewsTargetingEntity)allTargets.get(0)).getName());
        Assert.assertEquals((Object)"latestNews", (Object)((NewsTargetingEntity)allTargets.get(1)).getName());
        Assert.assertEquals((Object)"testNews", (Object)((NewsTargetingEntity)allTargets.get(2)).getName());
    }

    @Test
    public void testGetAllowedTargets() throws Exception {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        IdentityRegistry identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)identityRegistry);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        Mockito.when((Object)identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        newsTargets.add(sliderNews);
        Mockito.when((Object)this.metadataService.getMetadatas(metadataType.getName(), 0L)).thenReturn(newsTargets);
        List allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)0L, (long)allowedTargets.size());
        Metadata latestNews = new Metadata();
        latestNews.setName("latestNews");
        latestNews.setCreatedDate(200L);
        HashMap<String, String> latestNewsProperties = new HashMap<String, String>();
        latestNewsProperties.put("label", "latest news");
        latestNewsProperties.put("permissions", "space:1");
        latestNews.setProperties(latestNewsProperties);
        latestNews.setId(2L);
        newsTargets.add(latestNews);
        Space space = new Space();
        space.setId("1");
        space.setDisplayName("Space1");
        space.setPrettyName("space1");
        space.setAvatarUrl("");
        Mockito.when((Object)this.metadataService.getMetadatas(metadataType.getName(), 0L)).thenReturn(newsTargets);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isPublisher(space, identity.getUserId())).thenReturn((Object)false);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)0L, (long)allowedTargets.size());
        Mockito.when((Object)this.spaceService.isPublisher(space, identity.getUserId())).thenReturn((Object)true);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)1L, (long)allowedTargets.size());
        Assert.assertEquals((Object)"latestNews", (Object)((NewsTargetingEntity)allowedTargets.get(0)).getName());
        Assert.assertTrue((boolean)((NewsTargetingEntity)allowedTargets.get(0)).isRestrictedAudience());
        Metadata testNews = new Metadata();
        testNews.setName("testNews");
        testNews.setCreatedDate(200L);
        HashMap<String, String> testNewsProperties = new HashMap<String, String>();
        testNewsProperties.put("label", "test news");
        testNewsProperties.put("permissions", "/platform/administrators");
        testNews.setProperties(testNewsProperties);
        testNews.setId(3L);
        newsTargets.add(testNews);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)this.groupHandler);
        GroupImpl group = new GroupImpl();
        group.setId("/platform/administrators");
        group.setGroupName("Administrators");
        Mockito.when((Object)this.groupHandler.findGroupById("/platform/administrators")).thenReturn((Object)group);
        Mockito.when((Object)identity.isMemberOf("/platform/administrators", "publisher")).thenReturn((Object)false);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)1L, (long)allowedTargets.size());
        Assert.assertEquals((Object)"latestNews", (Object)((NewsTargetingEntity)allowedTargets.get(0)).getName());
        Mockito.when((Object)identity.isMemberOf("/platform/administrators", "publisher")).thenReturn((Object)true);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)2L, (long)allowedTargets.size());
        Assert.assertEquals((Object)"latestNews", (Object)((NewsTargetingEntity)allowedTargets.get(0)).getName());
        Assert.assertEquals((Object)"testNews", (Object)((NewsTargetingEntity)allowedTargets.get(1)).getName());
        Assert.assertTrue((boolean)((NewsTargetingEntity)allowedTargets.get(0)).isRestrictedAudience());
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn(null);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)1L, (long)allowedTargets.size());
        Assert.assertEquals((Object)"testNews", (Object)((NewsTargetingEntity)allowedTargets.get(0)).getName());
        Mockito.when((Object)this.groupHandler.findGroupById("/platform/administrators")).thenReturn(null);
        allowedTargets = newsTargetingService.getAllowedTargets(identity);
        Assert.assertNotNull((Object)allowedTargets);
        Assert.assertEquals((long)0L, (long)allowedTargets.size());
    }

    @Test
    public void testGetTargetsByNewsId() throws Exception {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        sliderNews.setId(1L);
        LinkedList<MetadataItem> metadataItems = new LinkedList<MetadataItem>();
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setCreatedDate(100L);
        metadataItem.setCreatorId(1L);
        metadataItem.setId(1L);
        metadataItem.setObjectId("123456");
        metadataItem.setMetadata(sliderNews);
        metadataItems.add(metadataItem);
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", "123456", null);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataTypeAndObject(NewsTargetingService.METADATA_TYPE.getName(), (MetadataObject)newsTargetObject)).thenReturn(metadataItems);
        List newsTargets = newsTargetingService.getTargetsByNewsId("123456");
        Assert.assertNotNull((Object)newsTargets);
        Assert.assertEquals((long)1L, (long)newsTargets.size());
        Assert.assertEquals((Object)"sliderNews", newsTargets.get(0));
    }

    @Test
    public void testSaveNewsTargets() throws Exception {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        Identity identity = new Identity("root");
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        sliderNews.setId(1L);
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setCreatedDate(100L);
        metadataItem.setCreatorId(1L);
        metadataItem.setId(1L);
        metadataItem.setObjectId("123456");
        metadataItem.setMetadata(sliderNews);
        LinkedList<String> targets = new LinkedList<String>();
        targets.add("sliderNews");
        News news = new News();
        news.setSpaceId("spaceId");
        news.setTitle("Test news");
        news.setAuthor("user1");
        news.setTargets(targets);
        news.setId("123456");
        NewsTargetObject newsTargetObject = new NewsTargetObject("news", "123456", null);
        MetadataKey metadataKey = new MetadataKey(NewsTargetingService.METADATA_TYPE.getName(), "sliderNews", 0L);
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("1");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root")).thenReturn((Object)userIdentity);
        IdentityRegistry identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)identityRegistry);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getCurrentContainer()).thenReturn((Object)this.container);
        Mockito.when((Object)this.spaceService.getSpaceById("spaceId")).thenReturn((Object)this.space);
        Mockito.when((Object)this.spaceService.isMember(this.space, identity.getUserId())).thenReturn((Object)true);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(Authenticator.class)).thenReturn((Object)authenticator);
        Mockito.when((Object)authenticator.createIdentity("root")).thenReturn((Object)identity);
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        MembershipEntry membershipEntry = new MembershipEntry("/platform/web-contributors", "publisher");
        memberships.add(membershipEntry);
        identity.setMemberships(memberships);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("displayed", String.valueOf(true));
        COMMONS_UTILS.when(() -> CommonsUtils.getService(SpaceService.class)).thenReturn((Object)this.spaceService);
        newsTargetingService.saveNewsTarget(news, true, news.getTargets(), "root");
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.times((int)1))).getOrCreateIdentity("organization", "root");
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)newsTargetObject, metadataKey, properties, 1L);
    }

    @Test
    public void testGetNewsTargetItemsByTargetName() throws Exception {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        Metadata sliderNews = new Metadata();
        sliderNews.setName("newsTargets");
        sliderNews.setCreatedDate(100L);
        sliderNews.setId(1L);
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setCreatedDate(100L);
        metadataItem.setCreatorId(1L);
        metadataItem.setId(1L);
        metadataItem.setObjectId("123456");
        metadataItem.setMetadata(sliderNews);
        LinkedList<MetadataItem> metadataItems = new LinkedList<MetadataItem>();
        metadataItems.add(metadataItem);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty("newsTargets", NewsTargetingService.METADATA_TYPE.getName(), "news", "displayed", String.valueOf(true), 0L, 10L)).thenReturn(metadataItems);
        List newsTargetsItems = newsTargetingService.getNewsTargetItemsByTargetName("newsTargets", 0L, 10L);
        Assert.assertNotNull((Object)newsTargetsItems);
        Assert.assertEquals((long)1L, (long)newsTargetsItems.size());
    }

    @Test
    public void testDeleteTargetByName() throws IllegalAccessException {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        String username = "user";
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity();
        userIdentity.setRemoteId(username);
        IdentityRegistry identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)identityRegistry);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isMemberOf("/platform/web-contributors", "manager")).thenReturn((Object)true);
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        newsTargets.add(sliderNews);
        LinkedList<NewsTargetingEntity> targets = new LinkedList<NewsTargetingEntity>();
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName("test1");
        targets.add(newsTargetingEntity);
        Mockito.when((Object)this.metadataService.getMetadataByKey((MetadataKey)ArgumentMatchers.any())).thenReturn((Object)sliderNews);
        newsTargetingService.deleteTargetByName(((NewsTargetingEntity)targets.get(0)).getName(), identity);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.atLeastOnce())).deleteMetadataById(((Metadata)newsTargets.get(0)).getId());
    }

    @Test
    public void testCreateTarget() throws IllegalAccessException {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        Identity currentIdentity = new Identity("root");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "manager");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", "root");
        userIdentity.setId("1");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)userIdentity);
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        sliderNews.setType(metadataType);
        sliderNews.setName("sliderNews");
        sliderNews.setCreatorId(1L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(0L);
        newsTargets.add(sliderNews);
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(sliderNews.getName());
        newsTargetingEntity.setProperties(sliderNews.getProperties());
        Mockito.when((Object)this.metadataService.createMetadata(sliderNews, 1L)).thenReturn((Object)sliderNews);
        Metadata createdMetadata = newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
        Assert.assertNotNull((Object)createdMetadata);
        Assert.assertEquals((long)sliderNews.getId(), (long)createdMetadata.getId());
        Assert.assertEquals((Object)sliderNews.getName(), (Object)createdMetadata.getName());
        Mockito.when((Object)this.metadataService.getMetadataByKey((MetadataKey)ArgumentMatchers.any())).thenReturn((Object)sliderNews);
        try {
            newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String username1 = "John";
        String id1 = "2";
        org.exoplatform.social.core.identity.model.Identity userIdentity1 = new org.exoplatform.social.core.identity.model.Identity();
        userIdentity1.setId(id1);
        userIdentity1.setRemoteId(username1);
        IdentityRegistry identityRegistry1 = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)identityRegistry1);
        Identity identity1 = (Identity)Mockito.mock(Identity.class);
        try {
            newsTargetingService.createNewsTarget(newsTargetingEntity, identity1);
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateTarget() throws IllegalAccessException {
        NewsTargetingServiceImpl newsTargetingService = new NewsTargetingServiceImpl(this.metadataService, this.identityManager, this.spaceService, this.organizationService);
        Identity currentIdentity = new Identity("root");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "manager");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", "root");
        userIdentity.setId("1");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)userIdentity);
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        sliderNews.setType(metadataType);
        sliderNews.setName("sliderNews");
        sliderNews.setCreatorId(1L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNewsProperties.put("description", "description slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(0L);
        newsTargets.add(sliderNews);
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(sliderNews.getName());
        newsTargetingEntity.setProperties(sliderNews.getProperties());
        Mockito.when((Object)this.metadataService.createMetadata(sliderNews, 1L)).thenReturn((Object)sliderNews);
        Metadata createdMetadata = newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity);
        String originalTargetName = "sliderNews";
        NewsTargetingEntity newsTargetingEntityUpdated = new NewsTargetingEntity();
        newsTargetingEntityUpdated.setName("sliderNews update");
        newsTargetingEntityUpdated.setProperties(sliderNews.getProperties());
        MetadataKey targetMetadataKey = new MetadataKey(NewsTargetingService.METADATA_TYPE.getName(), originalTargetName, 0L);
        Mockito.when((Object)this.metadataService.updateMetadata(createdMetadata, 1L)).thenReturn((Object)sliderNews);
        Mockito.when((Object)this.metadataService.getMetadataByKey(targetMetadataKey)).thenReturn((Object)createdMetadata);
        Metadata updatedMetadata = newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntityUpdated, currentIdentity);
        Assert.assertNotNull((Object)updatedMetadata);
        Assert.assertEquals((long)sliderNews.getId(), (long)updatedMetadata.getId());
        Assert.assertEquals((Object)sliderNews.getName(), (Object)updatedMetadata.getName());
        Mockito.when((Object)this.metadataService.getMetadataByKey((MetadataKey)ArgumentMatchers.any())).thenReturn((Object)sliderNews);
        try {
            newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Mockito.when((Object)this.metadataService.getMetadataByKey((MetadataKey)ArgumentMatchers.any())).thenReturn(null);
        try {
            newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

