/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage.jcr;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.connector.NewsSearchConnector;
import org.exoplatform.news.model.News;
import org.exoplatform.news.search.NewsESSearchConnector;
import org.exoplatform.news.storage.NewsAttachmentsStorage;
import org.exoplatform.news.storage.jcr.JcrNewsStorage;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.impl.PublicationServiceImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.WCMPublicationServiceImpl;
import org.exoplatform.services.wcm.extensions.publication.impl.PublicationManagerImpl;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class JcrNewsStorageTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    @Mock
    RepositoryService repositoryService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;
    @Mock
    NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    DataDistributionManager dataDistributionManager;
    @Mock
    SpaceService spaceService;
    @Mock
    ActivityManager activityManager;
    @Mock
    IdentityManager identityManager;
    @Mock
    UploadService uploadService;
    @Mock
    WCMPublicationServiceImpl wcmPublicationServiceImpl;
    @Mock
    PublicationManagerImpl publicationManagerImpl;
    @Mock
    PublicationServiceImpl publicationServiceImpl;
    @Mock
    HTMLUploadImageProcessor imageProcessor;
    @Mock
    NewsSearchConnector newsSearchConnector;
    @Mock
    NewsAttachmentsStorage newsAttachmentsStorage;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        PORTAL_CONTAINER.close();
    }

    @Test
    public void shouldGetNodeWhenNewsExists() throws Exception {
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        Node node = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getString()).thenReturn((Object)"");
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)node);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)node.getProperty((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)property);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)property.getLong()).thenReturn((Object)10L);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)space);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/spaces/space1");
        Identity currentIdentity = new Identity("test");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "publisher");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        Mockito.when((Object)this.spaceService.isSuperManager("user")).thenReturn((Object)false);
        Mockito.when((Object)space.getVisibility()).thenReturn((Object)"private");
        Mockito.when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)false);
        News news = jcrNewsStorage.getNewsById("1", false);
        Assert.assertNotNull((Object)news);
    }

    @Test
    public void shouldGetNullWhenNewsDoesNotExist() throws Exception {
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        News news = jcrNewsStorage.getNewsById("1", false);
        Assert.assertNull((Object)news);
    }

    @Test
    public void shouldGetLastNewsVersionWhenNewsExistsAndHasVersions() throws Exception {
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        Node node = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getString()).thenReturn((Object)"");
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)node);
        Workspace workSpace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workSpace);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)node.hasProperty((String)AdditionalMatchers.not((Object)((String)ArgumentMatchers.eq((Object)"exo:dateModified"))))).thenReturn((Object)true);
        Mockito.when((Object)node.getProperty((String)AdditionalMatchers.not((Object)((String)ArgumentMatchers.eq((Object)"exo:dateModified"))))).thenReturn((Object)property);
        Calendar calendarUpdated = Calendar.getInstance();
        calendarUpdated.set(2019, 11, 20, 12, 0);
        Property updatedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)updatedProperty.getDate()).thenReturn((Object)calendarUpdated);
        Mockito.when((Object)node.hasProperty((String)ArgumentMatchers.eq((Object)"exo:dateModified"))).thenReturn((Object)true);
        Mockito.when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:dateModified"))).thenReturn((Object)updatedProperty);
        Mockito.when((Object)node.isNodeType((String)ArgumentMatchers.eq((Object)"mix:versionable"))).thenReturn((Object)true);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)node.getVersionHistory()).thenReturn((Object)versionHistory);
        Version version1 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)version1.getUUID()).thenReturn((Object)"1");
        Mockito.when((Object)version1.getName()).thenReturn((Object)"1");
        Mockito.when((Object)version1.getSession()).thenReturn((Object)this.session);
        Property version1AuthorProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)version1AuthorProperty.getString()).thenReturn((Object)"john");
        Mockito.when((Object)version1.hasProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifier"))).thenReturn((Object)true);
        Mockito.when((Object)version1.getProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifier"))).thenReturn((Object)version1AuthorProperty);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(2019, 11, 20, 10, 0);
        Property version1CreatedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)version1CreatedProperty.getDate()).thenReturn((Object)calendar1);
        Mockito.when((Object)version1.hasProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifiedDate"))).thenReturn((Object)true);
        Mockito.when((Object)version1.getProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifiedDate"))).thenReturn((Object)version1CreatedProperty);
        Mockito.when((Object)version1.getContainingHistory()).thenReturn((Object)((VersionHistory)Mockito.mock(VersionHistory.class)));
        Version version2 = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)version2.getUUID()).thenReturn((Object)"2");
        Mockito.when((Object)version2.getName()).thenReturn((Object)"2");
        Mockito.when((Object)version2.getSession()).thenReturn((Object)this.session);
        Property version2AuthorProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)version2AuthorProperty.getString()).thenReturn((Object)"mary");
        Mockito.when((Object)version2.hasProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifier"))).thenReturn((Object)true);
        Mockito.when((Object)version2.getProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifier"))).thenReturn((Object)version2AuthorProperty);
        Calendar calendar2 = Calendar.getInstance();
        Property version2CreatedProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)version2CreatedProperty.getDate()).thenReturn((Object)calendar2);
        Mockito.when((Object)version2.hasProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifiedDate"))).thenReturn((Object)true);
        Mockito.when((Object)version2.getProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifiedDate"))).thenReturn((Object)version2CreatedProperty);
        calendar2.set(2019, 11, 20, 11, 0);
        Mockito.when((Object)version2.getCreated()).thenReturn((Object)calendar2);
        Mockito.when((Object)version2.getContainingHistory()).thenReturn((Object)((VersionHistory)Mockito.mock(VersionHistory.class)));
        VersionIterator versionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)versionIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)versionIterator.nextVersion()).thenReturn((Object)version1).thenReturn((Object)version2).thenReturn((Object)version1).thenReturn((Object)version2).thenReturn((Object)version1).thenReturn((Object)version2);
        Mockito.when((Object)versionHistory.getAllVersions()).thenReturn((Object)versionIterator);
        Mockito.when((Object)versionHistory.getRootVersion()).thenReturn((Object)((Version)Mockito.mock(Version.class)));
        Mockito.when((Object)property.getDate()).thenReturn((Object)calendar1);
        Mockito.when((Object)property.getLong()).thenReturn((Object)10L);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)space);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/spaces/space1");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"intranet");
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        Identity currentIdentity = new Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "publisher");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("2");
        activity.isHidden(false);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        Property actProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)actProperty.getString()).thenReturn((Object)"1:2;1:3");
        Mockito.when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:activities"))).thenReturn((Object)actProperty);
        Mockito.when((Object)space.getVisibility()).thenReturn((Object)"private");
        Mockito.when((Object)this.spaceService.isMember((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)false);
        Mockito.when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity("2")).thenReturn((Object)activity);
        News news = jcrNewsStorage.getNewsById("1", false);
        Assert.assertNotNull((Object)news);
        Assert.assertEquals((Object)calendar1.getTime(), (Object)news.getPublicationDate());
        Assert.assertEquals((Object)calendar2.getTime(), (Object)news.getUpdateDate());
        Assert.assertEquals((Object)"mary", (Object)news.getUpdater());
    }

    @Test
    public void shouldSetPermissionForSharedSpaceWhenFound() throws Exception {
        JcrNewsStorage jcrNewsStorage = (JcrNewsStorage)Mockito.mock(JcrNewsStorage.class);
        ((JcrNewsStorage)Mockito.doCallRealMethod().when((Object)jcrNewsStorage)).shareNews((News)ArgumentMatchers.nullable(News.class), (Space)ArgumentMatchers.nullable(Space.class), (org.exoplatform.social.core.identity.model.Identity)ArgumentMatchers.nullable(org.exoplatform.social.core.identity.model.Identity.class), (String)ArgumentMatchers.nullable(String.class));
        ExtendedNode newsNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        ExtendedNode newsImageNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)newsNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        String newsId = "newsId";
        Mockito.when((Object)jcrNewsStorage.getNodeById((String)ArgumentMatchers.eq((Object)newsId), (SessionProvider)ArgumentMatchers.nullable(SessionProvider.class))).thenReturn((Object)newsNode);
        String spaceGroup = "spaceGroup";
        News news = (News)Mockito.mock(News.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)spaceGroup);
        Mockito.when((Object)news.getId()).thenReturn((Object)newsId);
        String newsImageId = "newsImageId";
        Mockito.when((Object)jcrNewsStorage.getNodeById((String)ArgumentMatchers.eq((Object)newsImageId), (SessionProvider)ArgumentMatchers.nullable(SessionProvider.class))).thenReturn((Object)newsImageNode);
        String newsBody = "news body <img src=\"/portal/rest/images/session/" + newsImageId + "\" />";
        Mockito.when((Object)news.getBody()).thenReturn((Object)newsBody);
        jcrNewsStorage.shareNews(news, space, identity, "activityId");
        ((ExtendedNode)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.atLeastOnce())).setPermission("*:" + spaceGroup, JcrNewsStorage.SHARE_NEWS_PERMISSIONS);
        ((ExtendedNode)Mockito.verify((Object)newsImageNode, (VerificationMode)Mockito.atLeastOnce())).setPermission("*:" + spaceGroup, JcrNewsStorage.SHARE_NEWS_PERMISSIONS);
    }

    @Test
    public void shouldUpdateNodeAndKeepIllustrationWhenUpdatingNewsWithNullUploadId() throws Exception {
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", "user");
        userIdentity.setId("user");
        userIdentity.setRemoteId("user");
        Node newsNode = (Node)Mockito.mock(Node.class);
        Node illustrationNode = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NewsESSearchConnector.class)).thenReturn(null);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)newsNode);
        Mockito.when((Object)newsNode.getProperty((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)property);
        Mockito.when((Object)newsNode.getNode((String)ArgumentMatchers.eq((Object)"illustration"))).thenReturn((Object)illustrationNode);
        Mockito.when((Object)newsNode.hasNode((String)ArgumentMatchers.eq((Object)"illustration"))).thenReturn((Object)true);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.imageProcessor.processImages((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.nullable(String.class))).thenAnswer(i -> i.getArguments()[0]);
        Mockito.when((Object)newsNode.getName()).thenReturn((Object)"Updated title");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity(ArgumentMatchers.anyString(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)userIdentity);
        News news = new News();
        news.setTitle("Updated title");
        news.setSummary("Updated summary");
        news.setBody("Updated body");
        news.setUploadId(null);
        news.setViewsCount(Long.valueOf(10L));
        news.setPublicationState("draft");
        jcrNewsStorage.updateNews(news, "user");
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:title"), (String)ArgumentMatchers.eq((Object)"Updated title"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:summary"), (String)ArgumentMatchers.eq((Object)"Updated summary"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:body"), (String)ArgumentMatchers.eq((Object)"Updated body"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:lastModifiedDate"), (Calendar)ArgumentMatchers.any(Calendar.class));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty("exo:newsLastModifier", "user");
        ((Node)Mockito.verify((Object)illustrationNode, (VerificationMode)Mockito.times((int)0))).remove();
    }

    @Test
    public void shouldUpdateNodeAndRemoveIllustrationWhenUpdatingNewsWithEmptyUploadId() throws Exception {
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        Node newsNode = (Node)Mockito.mock(Node.class);
        Node illustrationNode = (Node)Mockito.mock(Node.class);
        Property property = (Property)Mockito.mock(Property.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NewsESSearchConnector.class)).thenReturn(null);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)newsNode);
        Mockito.when((Object)newsNode.getProperty((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)property);
        Mockito.when((Object)newsNode.getNode((String)ArgumentMatchers.eq((Object)"illustration"))).thenReturn((Object)illustrationNode);
        Mockito.when((Object)newsNode.hasNode((String)ArgumentMatchers.eq((Object)"illustration"))).thenReturn((Object)true);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.imageProcessor.processImages((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.nullable(String.class))).thenAnswer(i -> i.getArguments()[0]);
        Mockito.when((Object)newsNode.getName()).thenReturn((Object)"Updated title");
        News news = new News();
        news.setTitle("Updated title");
        news.setSummary("Updated summary");
        news.setBody("Updated body");
        news.setUploadId("");
        news.setViewsCount(Long.valueOf(10L));
        jcrNewsStorage.updateNews(news, "user");
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:title"), (String)ArgumentMatchers.eq((Object)"Updated title"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:summary"), (String)ArgumentMatchers.eq((Object)"Updated summary"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:body"), (String)ArgumentMatchers.eq((Object)"Updated body"));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:dateModified"), (Calendar)ArgumentMatchers.any(Calendar.class));
        ((Node)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty("exo:newsLastModifier", "user");
        ((Node)Mockito.verify((Object)illustrationNode, (VerificationMode)Mockito.times((int)1))).remove();
    }

    @Test
    public void shouldPublishNews() throws Exception {
        DataDistributionType dataDistributionType = (DataDistributionType)Mockito.mock(DataDistributionType.class);
        Mockito.when((Object)this.dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE)).thenReturn((Object)dataDistributionType);
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        JcrNewsStorage jcrNewsStorageSpy = (JcrNewsStorage)Mockito.spy((Object)jcrNewsStorage);
        ExtendedNode newsNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Node publishedRootNode = (Node)Mockito.mock(Node.class);
        Node newsFolderNode = (Node)Mockito.mock(Node.class);
        Node applicationDataNode = (Node)Mockito.mock(Node.class);
        Node newsRootNode = (Node)Mockito.mock(Node.class);
        News news = new News();
        news.setTitle("published title");
        news.setAudience("all");
        news.setSummary("published summary");
        news.setBody("published body");
        news.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        news.setCreationDate(date1);
        news.setPublished(true);
        news.setId("id123");
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)newsNode);
        Mockito.when((Object)newsNode.canAddMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)true);
        ((JcrNewsStorage)Mockito.doReturn((Object)news).when((Object)jcrNewsStorageSpy)).getNewsById("id123", false);
        Mockito.when((Object)this.session.getItem((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)applicationDataNode);
        Mockito.when((Object)applicationDataNode.hasNode((String)ArgumentMatchers.eq((Object)"News"))).thenReturn((Object)true);
        Mockito.when((Object)applicationDataNode.getNode((String)ArgumentMatchers.eq((Object)"News"))).thenReturn((Object)newsRootNode);
        Mockito.when((Object)newsRootNode.hasNode((String)ArgumentMatchers.eq((Object)"Pinned"))).thenReturn((Object)true);
        Mockito.when((Object)newsRootNode.getNode((String)ArgumentMatchers.eq((Object)"Pinned"))).thenReturn((Object)publishedRootNode);
        jcrNewsStorageSpy.publishNews(news);
        ((ExtendedNode)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).save();
        ((ExtendedNode)Mockito.verify((Object)newsNode, (VerificationMode)Mockito.times((int)1))).setProperty((String)ArgumentMatchers.eq((Object)"exo:pinned"), ArgumentMatchers.eq((boolean)true));
        ExtendedNode newsImageNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        news.setBody("news body with image src=\"/portal/rest/images/repository/collaboration/123\"");
        Mockito.when((Object)jcrNewsStorageSpy.getNodeById("123", this.sessionProvider)).thenReturn((Object)newsImageNode);
        Mockito.when((Object)newsImageNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        jcrNewsStorageSpy.publishNews(news);
        ((ExtendedNode)Mockito.verify((Object)newsImageNode, (VerificationMode)Mockito.times((int)1))).setPermission("any", JcrNewsStorage.SHARE_NEWS_PERMISSIONS);
        ((ExtendedNode)Mockito.verify((Object)newsImageNode, (VerificationMode)Mockito.times((int)1))).save();
        ExtendedNode existingUploadedNewsImageNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        String nodePath = "Groups/spaces/test/testimage";
        String currentDomainName = "https://exoplatform.com";
        String currentPortalContainerName = "portal";
        String restContextName = "rest";
        COMMONS_UTILS.when(() -> CommonsUtils.getRestContextName()).thenReturn((Object)restContextName);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)currentPortalContainerName);
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentDomain()).thenReturn((Object)currentDomainName);
        news.setBody("news body with image src=\"https://exoplatform.com/portal/rest/jcr/repository/collaboration/Groups/spaces/test/testimage\"");
        Mockito.when((Object)this.session.getItem((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)existingUploadedNewsImageNode);
        Mockito.when((Object)jcrNewsStorageSpy.getNodeByPath(nodePath, this.sessionProvider)).thenReturn((Object)existingUploadedNewsImageNode);
        Mockito.when((Object)existingUploadedNewsImageNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        jcrNewsStorageSpy.publishNews(news);
        ((ExtendedNode)Mockito.verify((Object)existingUploadedNewsImageNode, (VerificationMode)Mockito.times((int)1))).setPermission("any", JcrNewsStorage.SHARE_NEWS_PERMISSIONS);
        ((ExtendedNode)Mockito.verify((Object)existingUploadedNewsImageNode, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void shouldCreateNewsDraftAndPublishIt() throws Exception {
        DataDistributionType dataDistributionType = (DataDistributionType)Mockito.mock(DataDistributionType.class);
        Mockito.when((Object)this.dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE)).thenReturn((Object)dataDistributionType);
        JcrNewsStorage jcrNewsStorage = this.buildJcrNewsStorage();
        News news = new News();
        news.setTitle("new published news title");
        news.setSummary("new published news summary");
        news.setBody("new published news body");
        news.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        news.setCreationDate(date1);
        news.setPublished(true);
        news.setSpaceId("spaceTest");
        news.setAuthor("root");
        News createdNewsDraft = new News();
        createdNewsDraft.setId("id123");
        createdNewsDraft.setPublished(true);
        Node node = (Node)Mockito.mock(Node.class);
        Node spaceRootNode = (Node)Mockito.mock(Node.class);
        Node spaceNewsRootNode = (Node)Mockito.mock(Node.class);
        Node newsFolderNode = (Node)Mockito.mock(Node.class);
        Node newsNode = (Node)Mockito.mock(Node.class);
        Space space = (Space)Mockito.mock(Space.class);
        org.exoplatform.social.core.identity.model.Identity poster = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)node);
        Mockito.when((Object)this.spaceService.getSpaceById("spaceTest")).thenReturn((Object)space);
        Mockito.when((Object)this.nodeHierarchyCreator.getJcrPath("groupsPath")).thenReturn((Object)"spaces");
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"spaceTest");
        Mockito.when((Object)this.session.getItem("spacesspaceTest")).thenReturn((Object)spaceRootNode);
        Mockito.when((Object)spaceRootNode.hasNode("News")).thenReturn((Object)true);
        Mockito.when((Object)spaceRootNode.getNode("News")).thenReturn((Object)spaceNewsRootNode);
        Mockito.when((Object)dataDistributionType.getOrCreateDataNode(spaceNewsRootNode, "2019/8/22")).thenReturn((Object)newsFolderNode);
        Mockito.when((Object)newsFolderNode.addNode((String)ArgumentMatchers.nullable(String.class), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)newsNode);
        Mockito.when((Object)newsNode.getUUID()).thenReturn((Object)"id123");
        Mockito.when((Object)node.getProperty((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)property);
        Mockito.when((Object)property.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "root", false)).thenReturn((Object)poster);
        Mockito.when((Object)space.getPrettyName()).thenReturn((Object)"spaceTest");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("space", "spaceTest", false)).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)poster.getId()).thenReturn((Object)"root");
        JcrNewsStorage jcrNewsStorageSpy = (JcrNewsStorage)Mockito.spy((Object)jcrNewsStorage);
        ((JcrNewsStorage)Mockito.doNothing().when((Object)jcrNewsStorageSpy)).publishNews(createdNewsDraft);
        ((JcrNewsStorage)Mockito.doReturn((Object)createdNewsDraft).when((Object)jcrNewsStorageSpy)).createNews(news);
        ((PublicationServiceImpl)Mockito.doNothing().when((Object)this.publicationServiceImpl)).changeState(newsNode, "published", new HashMap());
        News createdNews = jcrNewsStorageSpy.createNews(news);
        this.setRootAsCurrentIdentity();
        Assert.assertNotNull((Object)createdNews);
    }

    private void setRootAsCurrentIdentity() {
        Identity currentIdentity = new Identity("root");
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
    }

    private JcrNewsStorage buildJcrNewsStorage() {
        JcrNewsStorage jcrNewsStorage = new JcrNewsStorage(this.repositoryService, this.sessionProviderService, this.nodeHierarchyCreator, this.dataDistributionManager, this.activityManager, this.spaceService, this.uploadService, (PublicationService)this.publicationServiceImpl, (PublicationManager)this.publicationManagerImpl, this.newsAttachmentsStorage, this.identityManager, this.newsSearchConnector, (WCMPublicationService)this.wcmPublicationServiceImpl);
        return jcrNewsStorage;
    }
}

