/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.io.Serializable;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.model.News;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PostNewsNotificationPluginTest {
    private static MockedStatic<CommonsUtils> COMMONS_UTILS;
    private static MockedStatic<WCMCoreUtils> WCM_CORE_UTILS;
    private static MockedStatic<IdGenerator> ID_GENERATOR;
    private static MockedStatic<PluginKey> PLUGIN_KEY;
    private static MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT;
    @Mock
    private UserHandler userhandler;
    @Mock
    private SpaceService spaceService;
    @Mock
    private NewsService newsService;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private InitParams initParams;
    @Mock
    private OrganizationService orgService;

    @BeforeClass
    public static void beforeRunBare() throws Exception {
        COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
        WCM_CORE_UTILS = Mockito.mockStatic(WCMCoreUtils.class);
        ID_GENERATOR = Mockito.mockStatic(IdGenerator.class);
        PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
        EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        WCM_CORE_UTILS.close();
        ID_GENERATOR.close();
        PLUGIN_KEY.close();
        EXO_CONTAINER_CONTEXT.close();
    }

    @Test
    public void shouldMakeNotificationForPostNewsContext() throws Exception {
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)this.userhandler);
        PostNewsNotificationPlugin newsPlugin = new PostNewsNotificationPlugin(this.initParams, this.spaceService, this.orgService, this.newsService, this.activityManager);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)"title").append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)"root").append(PostNewsNotificationPlugin.CURRENT_USER, (Object)"root").append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)"1").append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)"space1").append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)"http://localhost:8080//rest/v1/news/id123/illustration").append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/intranet/activity?id=38").append(PostNewsNotificationPlugin.NEWS_ID, (Object)"456789").append(PostNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        User contentAuthorUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)contentAuthorUser);
        User currentUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)currentUser);
        Mockito.when((Object)currentUser.getFullName()).thenReturn((Object)"root root");
        User user1 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user1.getUserName()).thenReturn((Object)"test");
        User user2 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user2.getUserName()).thenReturn((Object)"john");
        User[] receivers = new User[]{user1, user2};
        ID_GENERATOR.when(() -> IdGenerator.generate()).thenReturn((Object)"123456");
        PostNewsNotificationPluginTest.mockIdGeneratorService();
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.orgService);
        Space space = new Space();
        space.setId("1");
        space.setGroupId("space1");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        ListAccess members = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)this.userhandler.findUsersByGroupId("space1")).thenReturn((Object)members);
        Mockito.when((Object)members.getSize()).thenReturn((Object)2);
        Mockito.when((Object)((User[])members.load(0, 2))).thenReturn((Object)receivers);
        News news = (News)Mockito.mock(News.class);
        Mockito.when((Object)news.getActivityId()).thenReturn((Object)"12345");
        Mockito.when((Object)this.newsService.getNewsById(Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)news);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity("12345")).thenReturn((Object)activity);
        NotificationInfo notificationInfo = newsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("CONTENT_TITLE"));
        Assert.assertEquals((Object)"root root", (Object)notificationInfo.getValueOwnerParameter("CONTENT_AUTHOR"));
        Assert.assertEquals((Object)"http://localhost:8080//rest/v1/news/id123/illustration", (Object)notificationInfo.getValueOwnerParameter("ILLUSTRATION_URL"));
        Assert.assertEquals((Object)"space1", (Object)notificationInfo.getValueOwnerParameter("CONTENT_SPACE"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/intranet/activity?id=38", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }

    @Test
    public void shouldMakeNotificationForPostNewsContextAndDoNotSendNotificationToCreator() throws Exception {
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)this.userhandler);
        PostNewsNotificationPlugin newsPlugin = new PostNewsNotificationPlugin(this.initParams, this.spaceService, this.orgService, this.newsService, this.activityManager);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)"title").append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)"root").append(PostNewsNotificationPlugin.CURRENT_USER, (Object)"root").append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)"1").append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)"space1").append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)"http://localhost:8080//rest/v1/news/id123/illustration").append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/intranet/activity?id=38").append(PostNewsNotificationPlugin.NEWS_ID, (Object)"456789").append(PostNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        User contentAuthorUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)contentAuthorUser);
        Mockito.when((Object)contentAuthorUser.getFullName()).thenReturn((Object)"root root");
        User user1 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user1.getUserName()).thenReturn((Object)"root");
        User user2 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user2.getUserName()).thenReturn((Object)"john");
        User[] receivers = new User[]{user1, user2};
        ID_GENERATOR.when(() -> IdGenerator.generate()).thenReturn((Object)"123456");
        PostNewsNotificationPluginTest.mockIdGeneratorService();
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.orgService);
        Space space = new Space();
        space.setId("1");
        space.setGroupId("space1");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        ListAccess members = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)this.userhandler.findUsersByGroupId("space1")).thenReturn((Object)members);
        Mockito.when((Object)members.getSize()).thenReturn((Object)2);
        Mockito.when((Object)((User[])members.load(0, 2))).thenReturn((Object)receivers);
        News news = (News)Mockito.mock(News.class);
        Mockito.when((Object)news.getActivityId()).thenReturn((Object)"12345");
        Mockito.when((Object)this.newsService.getNewsById(Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)news);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity("12345")).thenReturn((Object)activity);
        NotificationInfo notificationInfo = newsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((long)1L, (long)notificationInfo.getSendToUserIds().size());
        Assert.assertEquals((Object)"john", notificationInfo.getSendToUserIds().get(0));
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("CONTENT_TITLE"));
        Assert.assertEquals((Object)"root root", (Object)notificationInfo.getValueOwnerParameter("CONTENT_AUTHOR"));
        Assert.assertEquals((Object)"http://localhost:8080//rest/v1/news/id123/illustration", (Object)notificationInfo.getValueOwnerParameter("ILLUSTRATION_URL"));
        Assert.assertEquals((Object)"space1", (Object)notificationInfo.getValueOwnerParameter("CONTENT_SPACE"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/intranet/activity?id=38", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }

    @Test
    public void shouldMakeNotificationForPostNewsContextAndAuthorUserIsNull() throws Exception {
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)this.userhandler);
        PostNewsNotificationPlugin newsPlugin = new PostNewsNotificationPlugin(this.initParams, this.spaceService, this.orgService, this.newsService, this.activityManager);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)"title").append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)"jean").append(PostNewsNotificationPlugin.CURRENT_USER, (Object)"jean").append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)"1").append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)"space1").append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)"http://localhost:8080//rest/v1/news/id123/illustration").append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/intranet/activity?id=38").append(PostNewsNotificationPlugin.NEWS_ID, (Object)"456789").append(PostNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        Mockito.when((Object)this.userhandler.findUserByName("jean")).thenReturn(null);
        User user1 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user1.getUserName()).thenReturn((Object)"test");
        User user2 = (User)Mockito.mock(User.class);
        Mockito.when((Object)user2.getUserName()).thenReturn((Object)"john");
        User[] receivers = new User[]{user1, user2};
        ID_GENERATOR.when(() -> IdGenerator.generate()).thenReturn((Object)"123456");
        PostNewsNotificationPluginTest.mockIdGeneratorService();
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.orgService);
        Space space = new Space();
        space.setId("1");
        space.setGroupId("space1");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        ListAccess members = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)this.userhandler.findUsersByGroupId("space1")).thenReturn((Object)members);
        Mockito.when((Object)members.getSize()).thenReturn((Object)2);
        Mockito.when((Object)((User[])members.load(0, 2))).thenReturn((Object)receivers);
        News news = (News)Mockito.mock(News.class);
        Mockito.when((Object)news.getActivityId()).thenReturn((Object)"12345");
        Mockito.when((Object)this.newsService.getNewsById(Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)news);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity("12345")).thenReturn((Object)activity);
        NotificationInfo notificationInfo = newsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"jean", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("CONTENT_TITLE"));
        Assert.assertEquals((Object)"jean", (Object)notificationInfo.getValueOwnerParameter("CONTENT_AUTHOR"));
        Assert.assertEquals((Object)"http://localhost:8080//rest/v1/news/id123/illustration", (Object)notificationInfo.getValueOwnerParameter("ILLUSTRATION_URL"));
        Assert.assertEquals((Object)"space1", (Object)notificationInfo.getValueOwnerParameter("CONTENT_SPACE"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/intranet/activity?id=38", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }

    public static void mockIdGeneratorService() {
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn((Object)new IDGeneratorService(){

            public String generateStringID(Object o) {
                return "123456";
            }

            public long generateLongID(Object o) {
                return 123456L;
            }

            public Serializable generateID(Object o) {
                return Integer.valueOf(123456);
            }

            public int generatIntegerID(Object o) {
                return 123456;
            }
        });
    }
}

