/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.search;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.search.NewsESSearchConnector;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsESSearchConnectorTest {
    private static final String ES_INDEX = "news_alias";
    public static final String FAKE_ES_QUERY = "{offset: @offset@, limit: @limit@, term1: @term@, term2: @term@, permissions: @permissions@}";
    @Mock
    IdentityManager identityManager;
    @Mock
    ActivityStorage activityStorage;
    @Mock
    ConfigurationManager configurationManager;
    @Mock
    ElasticSearchingClient client;
    String searchResult = null;
    boolean developingValue = false;

    @Before
    public void setUp() throws Exception {
        this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("news-search-result.json"));
        try {
            Mockito.reset((Object[])new ConfigurationManager[]{this.configurationManager});
            Mockito.lenient().when((Object)this.configurationManager.getInputStream("FILE_PATH")).thenReturn((Object)new ByteArrayInputStream(FAKE_ES_QUERY.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving ES Query content", e);
        }
        this.developingValue = PropertyManager.isDevelopping();
        PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
        PropertyManager.refresh();
    }

    @After
    public void tearDown() {
        PropertyManager.setProperty((String)"exo.product.developing", (String)String.valueOf(this.developingValue));
        PropertyManager.refresh();
    }

    @Test
    public void testSearchArguments() {
        NewsESSearchConnector newsESSearchConnector = new NewsESSearchConnector(this.configurationManager, this.identityManager, this.activityStorage, this.client, this.getParams());
        NewsFilter filter = new NewsFilter();
        filter.setSearchText("term");
        filter.setLimit(0);
        filter.setOffset(10);
        try {
            newsESSearchConnector.search(null, filter);
            Assert.fail((String)"Should throw IllegalArgumentException: viewer identity is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        try {
            NewsFilter filter2 = new NewsFilter();
            filter.setSearchText("term");
            filter.setLimit(-1);
            filter.setOffset(10);
            newsESSearchConnector.search(identity, filter2);
            Assert.fail((String)"Should throw IllegalArgumentException: limit should be positive");
        }
        catch (IllegalArgumentException filter2) {
            // empty catch block
        }
        try {
            NewsFilter filter3 = new NewsFilter();
            filter.setSearchText("term");
            filter.setLimit(0);
            filter.setOffset(-1);
            newsESSearchConnector.search(identity, filter3);
            Assert.fail((String)"Should throw IllegalArgumentException: offset should be positive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSearchNoResult() {
        NewsESSearchConnector newsESSearchConnector = new NewsESSearchConnector(this.configurationManager, this.identityManager, this.activityStorage, this.client, this.getParams());
        NewsFilter filter = new NewsFilter();
        filter.setSearchText("term");
        filter.setLimit(10);
        filter.setOffset(0);
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.activityStorage.getStreamFeedOwnerIds((Identity)Mockito.eq((Object)identity))).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getSearchText()).replace("@term_query@", filter.getSearchText())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.lenient().when((Object)this.client.sendRequest((String)Mockito.eq((Object)expectedESQuery), (String)Mockito.eq((Object)ES_INDEX))).thenReturn((Object)"{}");
        List result = newsESSearchConnector.search(identity, filter);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testSearchWithResult() {
        NewsESSearchConnector newsESSearchConnector = new NewsESSearchConnector(this.configurationManager, this.identityManager, this.activityStorage, this.client, this.getParams());
        NewsFilter filter = new NewsFilter();
        filter.setSearchText("term");
        filter.setLimit(10);
        filter.setOffset(0);
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.activityStorage.getStreamFeedOwnerIds((Identity)Mockito.eq((Object)identity))).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getSearchText()).replace("@term_query@", filter.getSearchText())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.lenient().when((Object)this.client.sendRequest((String)Mockito.eq((Object)expectedESQuery), (String)Mockito.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        Identity rootIdentity = new Identity("organization", "root");
        Mockito.lenient().when((Object)this.identityManager.getOrCreateIdentity("organization", "posterId")).thenReturn((Object)rootIdentity);
        List result = newsESSearchConnector.search(identity, filter);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        NewsESSearchResult newsESSearchResult = (NewsESSearchResult)result.iterator().next();
        Assert.assertEquals((Object)"6", (Object)newsESSearchResult.getId());
        Assert.assertEquals((long)1592227545758L, (long)newsESSearchResult.getPostedTime());
        Assert.assertEquals((long)1592227545758L, (long)newsESSearchResult.getLastUpdatedTime());
        Assert.assertNotNull((Object)newsESSearchResult.getExcerpts());
    }

    @Test
    public void testSearchWithIdentityResult() throws IOException {
        NewsESSearchConnector newsESSearchConnector = new NewsESSearchConnector(this.configurationManager, this.identityManager, this.activityStorage, this.client, this.getParams());
        NewsFilter filter = new NewsFilter();
        filter.setSearchText("john");
        filter.setLimit(10);
        filter.setOffset(0);
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(10L, 20L, 30L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.activityStorage.getStreamFeedOwnerIds((Identity)Mockito.eq((Object)identity))).thenReturn(permissions);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term_query@", "\"must\":{  \"query_string\":{    \"fields\": [\"body\", \"posterName\"],    \"default_operator\": \"AND\",    \"query\": \"@term@~\",    \"fuzziness\": 1,    \"phrase_slop\": 1  }},".replace("@term@", filter.getSearchText()).replace("@term_query@", filter.getSearchText())).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("news-search-result-by-identity.json"));
        Mockito.lenient().when((Object)this.client.sendRequest((String)Mockito.eq((Object)expectedESQuery), (String)Mockito.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        Identity poster = new Identity("organization", "posterId");
        Mockito.lenient().when((Object)this.identityManager.getOrCreateIdentity("organization", "posterId")).thenReturn((Object)poster);
        List result = newsESSearchConnector.search(identity, filter);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        NewsESSearchResult newsESSearchResult = (NewsESSearchResult)result.iterator().next();
        Assert.assertEquals((Object)"6", (Object)newsESSearchResult.getId());
        Assert.assertEquals((long)1592227545758L, (long)newsESSearchResult.getPostedTime());
        Assert.assertEquals((long)1592227545758L, (long)newsESSearchResult.getLastUpdatedTime());
        Assert.assertNotNull((Object)newsESSearchResult.getExcerpts());
        Assert.assertEquals((long)0L, (long)newsESSearchResult.getExcerpts().size());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("index", ES_INDEX);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("query.file.path");
        valueParam.setValue("FILE_PATH");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)valueParam);
        return params;
    }
}

