/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsDraftObject;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.service.impl.NewsServiceImplV2;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NewsServiceImplV2Test {
    @Mock
    private SpaceService spaceService;
    @Mock
    private NoteService noteService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private FileService fileService;
    @Mock
    private UploadService uploadService;
    @Mock
    private IndexingService indexingService;
    @Mock
    NewsTargetingService newsTargetingService;
    @Mock
    IdentityManager identityManager;
    @Mock
    ActivityManager activityManager;
    @Mock
    WikiService wikiService;
    private NewsService newsService;
    private UserACL userACL;
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    private static final MockedStatic<NewsUtils> NEWS_UTILS = Mockito.mockStatic(NewsUtils.class);

    @Before
    public void setUp() {
        this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        this.newsService = new NewsServiceImplV2(this.spaceService, this.noteService, this.metadataService, this.fileService, this.newsTargetingService, this.indexingService, this.identityManager, this.userACL, this.activityManager, this.wikiService, this.uploadService);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        PORTAL_CONTAINER.close();
        NEWS_UTILS.close();
    }

    @Test
    public void testCreateDraftArticle() throws Exception {
        News draftArticle = new News();
        draftArticle.setAuthor("john");
        draftArticle.setTitle("draft article for new page");
        draftArticle.setSummary("draft article summary for new page");
        draftArticle.setBody("draft body");
        draftArticle.setPublicationState("draft");
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById(draftArticle.getSpaceId())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/space/groupId");
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        DraftPage draftPage = new DraftPage();
        draftPage.setContent(draftArticle.getBody());
        draftPage.setTitle(draftArticle.getTitle());
        draftPage.setId("1");
        draftPage.setAuthor("john");
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.any())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isSuperManager(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Wiki wiki = (Wiki)Mockito.mock(Wiki.class);
        Mockito.when((Object)this.wikiService.getWikiByTypeAndOwner(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)wiki);
        Page rootPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)rootPage.getName()).thenReturn((Object)"Articles");
        News savedDraftArticle = this.newsService.createNews(draftArticle, identity);
        Assert.assertNull((Object)savedDraftArticle);
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName("group", space.getGroupId(), "Articles")).thenReturn((Object)rootPage);
        Mockito.when((Object)this.noteService.createDraftForNewPage((DraftPage)ArgumentMatchers.any(DraftPage.class), ArgumentMatchers.anyLong())).thenReturn((Object)draftPage);
        Mockito.when((Object)rootPage.getId()).thenReturn((Object)"1");
        org.exoplatform.social.core.identity.model.Identity identity1 = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)identity1);
        Mockito.when((Object)identity1.getId()).thenReturn((Object)"1");
        NEWS_UTILS.when(() -> NewsUtils.canPublishNews((String)ArgumentMatchers.anyString(), (Identity)((Identity)ArgumentMatchers.any(Identity.class)))).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.canRedactOnSpace((Space)ArgumentMatchers.any(Space.class), (Identity)ArgumentMatchers.any(Identity.class))).thenReturn((Object)true);
        savedDraftArticle = this.newsService.createNews(draftArticle, identity);
        Assert.assertNotNull((Object)savedDraftArticle);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.any(NewsDraftObject.class), (MetadataKey)ArgumentMatchers.any(MetadataKey.class), (Map)ArgumentMatchers.any(Map.class), ArgumentMatchers.anyLong());
        Assert.assertNotNull((Object)savedDraftArticle.getId());
        Assert.assertEquals((Object)draftPage.getId(), (Object)savedDraftArticle.getId());
        Assert.assertEquals((Object)draftPage.getTitle(), (Object)savedDraftArticle.getTitle());
        Assert.assertEquals((Object)draftPage.getContent(), (Object)savedDraftArticle.getBody());
        Assert.assertEquals((Object)draftPage.getAuthor(), (Object)savedDraftArticle.getAuthor());
    }

    @Test
    public void testGetDraftArticleById() throws Exception {
        DraftPage draftPage = new DraftPage();
        draftPage.setContent("draft body");
        draftPage.setTitle("draft article for new page");
        draftPage.setId("1");
        draftPage.setAuthor("john");
        draftPage.setWikiOwner("/space/groupId");
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/space/groupId");
        Mockito.when((Object)space.getAvatarUrl()).thenReturn((Object)"space/avatar/url");
        Mockito.when((Object)space.getDisplayName()).thenReturn((Object)"spaceDisplayName");
        Mockito.when((Object)space.getVisibility()).thenReturn((Object)"public");
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isSuperManager(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        ArrayList<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
        metadataItems.add(metadataItem);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(MetadataKey.class), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(metadataItems);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("summary", draftPage.getContent());
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(properties);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)this.activityManager.getActivity((String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(ArgumentMatchers.anyString())).thenReturn(null);
        News news = this.newsService.getNewsById("1", identity, false, NewsUtils.NewsObjectType.DRAFT.name().toLowerCase());
        Assert.assertNotNull((Object)news);
        Assert.assertEquals((Object)draftPage.getId(), (Object)news.getId());
        Assert.assertEquals((Object)draftPage.getAuthor(), (Object)news.getAuthor());
        Assert.assertEquals((Object)draftPage.getContent(), (Object)news.getBody());
        Assert.assertEquals((Object)"draft", (Object)news.getPublicationState());
        Assert.assertEquals((Object)space.getDisplayName(), (Object)news.getSpaceDisplayName());
        Assert.assertEquals((Object)space.getAvatarUrl(), (Object)news.getSpaceAvatarUrl());
        Assert.assertEquals((Object)"/portal/dw/news/detail?newsId=1&type=draft", (Object)news.getUrl());
    }

    @Test
    public void testUpdateDraftArticle() throws Exception {
        DraftPage draftPage = new DraftPage();
        draftPage.setContent("draft body");
        draftPage.setTitle("draft article for new page");
        draftPage.setId("1");
        draftPage.setAuthor("john");
        draftPage.setWikiOwner("/space/groupId");
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/space/groupId");
        Mockito.when((Object)space.getAvatarUrl()).thenReturn((Object)"space/avatar/url");
        Mockito.when((Object)space.getDisplayName()).thenReturn((Object)"spaceDisplayName");
        Mockito.when((Object)space.getVisibility()).thenReturn((Object)"public");
        Mockito.when((Object)this.spaceService.isSuperManager(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.any())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        ArrayList<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
        metadataItems.add(metadataItem);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(MetadataKey.class), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(metadataItems);
        HashMap properties = new HashMap();
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(properties);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)this.activityManager.getActivity((String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(ArgumentMatchers.anyString())).thenReturn(null);
        Page rootPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)rootPage.getName()).thenReturn((Object)"Articles");
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        NEWS_UTILS.when(() -> NewsUtils.getUserIdentity((String)ArgumentMatchers.anyString())).thenReturn((Object)identity);
        News news = new News();
        news.setAuthor("john");
        news.setTitle("new draft title");
        news.setBody("draft body");
        news.setId("1");
        news.setPublicationState("draft");
        news.setSpaceId(space.getId());
        news.setSummary("news summary");
        DraftPage expecteddraftPage = new DraftPage();
        expecteddraftPage.setTitle(news.getTitle());
        expecteddraftPage.setAuthor(news.getAuthor());
        expecteddraftPage.setContent(news.getBody());
        expecteddraftPage.setId(news.getId());
        expecteddraftPage.setWikiOwner("/space/groupId");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.newsService.updateNews(news, "john", Boolean.valueOf(false), false, "draft"));
        Mockito.when((Object)this.spaceService.canRedactOnSpace(space, identity)).thenReturn((Object)true);
        org.exoplatform.social.core.identity.model.Identity identity1 = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)identity1);
        Mockito.when((Object)identity1.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.noteService.updateDraftForNewPage((DraftPage)ArgumentMatchers.any(DraftPage.class), ArgumentMatchers.anyLong())).thenReturn((Object)expecteddraftPage);
        this.newsService.updateNews(news, "john", Boolean.valueOf(false), false, "draft");
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)1))).updateDraftForNewPage((DraftPage)ArgumentMatchers.eq((Object)expecteddraftPage), ArgumentMatchers.anyLong());
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).updateMetadataItem((MetadataItem)ArgumentMatchers.any(MetadataItem.class), ArgumentMatchers.anyLong());
    }

    @Test
    public void testDeleteDraftArticle() throws Exception {
        DraftPage draftPage = new DraftPage();
        draftPage.setContent("draft body");
        draftPage.setTitle("draft article for new page");
        draftPage.setId("1");
        draftPage.setAuthor("john");
        draftPage.setWikiOwner("/space/groupId");
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/space/groupId");
        Mockito.when((Object)space.getAvatarUrl()).thenReturn((Object)"space/avatar/url");
        Mockito.when((Object)space.getDisplayName()).thenReturn((Object)"spaceDisplayName");
        Mockito.when((Object)space.getVisibility()).thenReturn((Object)"public");
        Mockito.when((Object)this.spaceService.isSuperManager(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.any())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        ArrayList<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
        metadataItems.add(metadataItem);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(MetadataKey.class), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(metadataItems);
        HashMap properties = new HashMap();
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(properties);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)this.activityManager.getActivity((String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(ArgumentMatchers.anyString())).thenReturn(null);
        Page rootPage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)rootPage.getName()).thenReturn((Object)"Articles");
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        NEWS_UTILS.when(() -> NewsUtils.getUserIdentity((String)ArgumentMatchers.anyString())).thenReturn((Object)identity);
        Mockito.when((Object)this.spaceService.canRedactOnSpace(space, identity)).thenReturn((Object)true);
        this.newsService.deleteNews(draftPage.getId(), identity, true);
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)1))).removeDraftById(draftPage.getId());
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteMetadataItem(((Long)ArgumentMatchers.any(Long.class)).longValue(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testGetDraftArticles() throws Exception {
        DraftPage draftPage = new DraftPage();
        draftPage.setContent("draft body");
        draftPage.setTitle("draft article for new page");
        draftPage.setId("1");
        draftPage.setAuthor("john");
        draftPage.setWikiOwner("/space/groupId");
        Space space1 = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space1.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.when((Object)space1.getGroupId()).thenReturn((Object)"/space/groupId");
        Mockito.when((Object)space1.getAvatarUrl()).thenReturn((Object)"space/avatar/url");
        Mockito.when((Object)space1.getDisplayName()).thenReturn((Object)"spaceDisplayName");
        Mockito.when((Object)space1.getVisibility()).thenReturn((Object)"public");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        Mockito.when((Object)this.spaceService.isSuperManager(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("summary", draftPage.getContent());
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        List<MetadataItem> metadataItems = Arrays.asList(metadataItem);
        Mockito.when((Object)metadataItem.getObjectId()).thenReturn((Object)"1");
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(properties);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(MetadataKey.class), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(metadataItems);
        PORTAL_CONTAINER.when(() -> PortalContainer.getCurrentPortalContainerName()).thenReturn((Object)"portal");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"john");
        List<Space> allowedDraftNewsSpaces = Arrays.asList(space1);
        NEWS_UTILS.when(() -> NewsUtils.getAllowedDraftNewsSpaces((Identity)identity)).thenReturn(allowedDraftNewsSpaces);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(metadataItems);
        Mockito.when((Object)this.activityManager.getActivity((String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.when((Object)this.newsTargetingService.getTargetsByNewsId(ArgumentMatchers.anyString())).thenReturn(null);
        NewsFilter newsFilter = new NewsFilter();
        newsFilter.setDraftNews(true);
        newsFilter.setOffset(0);
        newsFilter.setLimit(10);
        List newsList = this.newsService.getNews(newsFilter, identity);
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)newsList.size(), (long)1L);
    }
}

