/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage.jcr;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.news.storage.jcr.JcrNewsAttachmentsStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class JcrNewsAttachmentsStorageTest {
    @Mock
    RepositoryService repositoryService;
    @Mock
    SessionProviderService sessionProviderService;
    @Mock
    ManageableRepository repository;
    @Mock
    RepositoryEntry repositoryEntry;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;

    @Test
    public void shouldGetAttachmentsOfANewsWhenThereAre() throws Exception {
        JcrNewsAttachmentsStorage newsAttachmentsService = new JcrNewsAttachmentsStorage();
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)this.session);
        Property attachmentIdsProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)attachmentIdsProperty.getValues()).thenReturn((Object)new Value[]{new StringValue("idAttach1"), new StringValue("idAttach2"), new StringValue("idAttach3")});
        Mockito.lenient().when((Object)node.hasProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)attachmentIdsProperty);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Node attachmentNode = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)attachmentNode.getPath()).thenReturn((Object)"/folder/subFolder/attachNode");
        Node attachmentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)attachmentNode1.getPath()).thenReturn((Object)"/folder/subFolder/attachNode1");
        Node attachmentNode2 = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)attachmentNode2.getPath()).thenReturn((Object)"/Quarantine/attachNode2");
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach1"))).thenReturn((Object)attachmentNode);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach2"))).thenReturn((Object)attachmentNode1);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach3"))).thenReturn((Object)attachmentNode2);
        List newsAttachments = newsAttachmentsService.getNewsAttachments(node);
        Assert.assertNotNull((Object)newsAttachments);
        Assert.assertEquals((long)2L, (long)newsAttachments.size());
    }

    @Test
    public void shouldGetNoAttachmentsOfANewsWhenThereAreNot() throws Exception {
        JcrNewsAttachmentsStorage newsAttachmentsService = new JcrNewsAttachmentsStorage();
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)this.session);
        Property attachmentIdsProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)attachmentIdsProperty.getValues()).thenReturn((Object)new Value[0]);
        Mockito.lenient().when((Object)node.hasProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)attachmentIdsProperty);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        List newsAttachments = newsAttachmentsService.getNewsAttachments(node);
        Assert.assertNotNull((Object)newsAttachments);
        Assert.assertEquals((long)0L, (long)newsAttachments.size());
    }

    @Test
    public void shouldMakeAttachmentsPublic() throws Exception {
        JcrNewsAttachmentsStorage newsAttachmentsService = new JcrNewsAttachmentsStorage();
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Property attachmentIdsProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)attachmentIdsProperty.getValues()).thenReturn((Object)new Value[]{new StringValue("idAttach1"), new StringValue("idAttach2"), new StringValue("idAttach3")});
        Mockito.lenient().when((Object)node.hasProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)attachmentIdsProperty);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        ExtendedNode attachmentNode1 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode1.canAddMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)attachmentNode1.getPath()).thenReturn((Object)"/folder/subFolder/attachNode1");
        ExtendedNode attachmentNode2 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode2.canAddMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)false);
        Mockito.lenient().when((Object)attachmentNode2.getPath()).thenReturn((Object)"/folder/subFolder/attachNode2");
        ExtendedNode attachmentNode3 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode3.canAddMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)attachmentNode3.getPath()).thenReturn((Object)"/folder/subFolder/attachNode3");
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach1"))).thenReturn((Object)attachmentNode1);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach2"))).thenReturn((Object)attachmentNode2);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach3"))).thenReturn((Object)attachmentNode3);
        newsAttachmentsService.makeAttachmentsPublic(node);
        ((ExtendedNode)Mockito.verify((Object)attachmentNode1, (VerificationMode)Mockito.times((int)1))).setPermission((String)ArgumentMatchers.eq((Object)"any"), (String[])AdditionalMatchers.aryEq((Object[])new String[]{"read"}));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode1, (VerificationMode)Mockito.times((int)1))).addMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode2, (VerificationMode)Mockito.times((int)1))).setPermission((String)ArgumentMatchers.eq((Object)"any"), (String[])AdditionalMatchers.aryEq((Object[])new String[]{"read"}));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode2, (VerificationMode)Mockito.times((int)0))).addMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode3, (VerificationMode)Mockito.times((int)1))).setPermission((String)ArgumentMatchers.eq((Object)"any"), (String[])AdditionalMatchers.aryEq((Object[])new String[]{"read"}));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode3, (VerificationMode)Mockito.times((int)1))).addMixin((String)ArgumentMatchers.eq((Object)"exo:privilegeable"));
    }

    @Test
    public void shouldUnmakeAttachmentsPublic() throws Exception {
        JcrNewsAttachmentsStorage newsAttachmentsService = new JcrNewsAttachmentsStorage();
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Property attachmentIdsProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)attachmentIdsProperty.getValues()).thenReturn((Object)new Value[]{new StringValue("idAttach1"), new StringValue("idAttach2"), new StringValue("idAttach3")});
        Mockito.lenient().when((Object)node.hasProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getProperty((String)ArgumentMatchers.eq((Object)"exo:attachmentsIds"))).thenReturn((Object)attachmentIdsProperty);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        ExtendedNode attachmentNode1 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode1.isNodeType((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)attachmentNode1.getPath()).thenReturn((Object)"/folder/subFolder/attachNode1");
        ExtendedNode attachmentNode2 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode2.isNodeType((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)false);
        Mockito.lenient().when((Object)attachmentNode2.getPath()).thenReturn((Object)"/folder/subFolder/attachNode2");
        ExtendedNode attachmentNode3 = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.lenient().when((Object)attachmentNode3.isNodeType((String)ArgumentMatchers.eq((Object)"exo:privilegeable"))).thenReturn((Object)true);
        Mockito.lenient().when((Object)attachmentNode3.getPath()).thenReturn((Object)"/folder/subFolder/attachNode3");
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach1"))).thenReturn((Object)attachmentNode1);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach2"))).thenReturn((Object)attachmentNode2);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"idAttach3"))).thenReturn((Object)attachmentNode3);
        newsAttachmentsService.unmakeAttachmentsPublic(node);
        ((ExtendedNode)Mockito.verify((Object)attachmentNode1, (VerificationMode)Mockito.times((int)1))).removePermission((String)ArgumentMatchers.eq((Object)"any"));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode2, (VerificationMode)Mockito.times((int)0))).removePermission((String)ArgumentMatchers.eq((Object)"any"));
        ((ExtendedNode)Mockito.verify((Object)attachmentNode3, (VerificationMode)Mockito.times((int)1))).removePermission((String)ArgumentMatchers.eq((Object)"any"));
    }
}

