/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsGamificationIntegrationListenerTest {
    @Mock
    ListenerService listenerService;
    @Mock
    NewsService newsService;

    @Test
    public void testAddGamificationPointsAfterCreatingAnArticle() throws Exception {
        News news = new News();
        news.setTitle("title");
        news.setAuthor("jean");
        news.setId("id123");
        news.setSpaceId("3");
        news.setActivities("3:39;1:11");
        news.setActivityId("10");
        final AtomicBoolean executeListener = new AtomicBoolean(true);
        this.listenerService.addListener("exo.news.postArticle", (Listener)new Listener<Long, Long>(this){

            public void onEvent(Event<Long, Long> event) throws Exception {
                executeListener.set(true);
            }
        });
        this.newsService.postNews(news, "root");
        Assert.assertTrue((boolean)executeListener.get());
    }
}

