/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.portlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class NewsListViewPortlet
extends GenericDispatchedViewPortlet {
    private NewsService newsService;

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletPreferences preferences;
        ConversationState conversationState = ConversationState.getCurrent();
        Identity currentIdentity = null;
        if (conversationState != null) {
            currentIdentity = ConversationState.getCurrent().getIdentity();
        }
        if (NewsUtils.canPublishNews(currentIdentity)) {
            preferences = request.getPreferences();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                if (StringUtils.equals((CharSequence)name, (CharSequence)"action") || StringUtils.contains((CharSequence)name, (CharSequence)"portal:")) continue;
                String value = request.getParameter(name);
                preferences.setValue(name, value);
            }
        } else {
            throw new PortletException("Illegal Access to attempt to store News List Portlet preferences for user " + request.getRemoteUser());
        }
        preferences.store();
    }

    public NewsService getNewsService() {
        if (this.newsService == null) {
            this.newsService = (NewsService)ExoContainerContext.getService(NewsService.class);
        }
        return this.newsService;
    }
}

