/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.diff.DiffService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.migration.PageContentMigrationService;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiPreferences;
import org.exoplatform.wiki.mow.api.WikiPreferencesSyntax;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.plugin.WikiEmotionIconsPlugin;
import org.exoplatform.wiki.plugin.WikiTemplatePagePlugin;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.listener.AttachmentWikiListener;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;
import org.picocontainer.Startable;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;

public class WikiServiceImpl
implements WikiService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(WikiServiceImpl.class);
    public static final String WIKI_TYPE_DRAFT = "draft";
    private static final String UNTITLED_PREFIX = "Untitled_";
    private static final String PREFERENCES = "preferences";
    private static final String DEFAULT_SYNTAX = "defaultSyntax";
    private static final String DEFAULT_WIKI_NAME = "wiki";
    private static final int CIRCULAR_RENAME_FLAG = 1000;
    private static final long DEFAULT_SAVE_DRAFT_SEQUENCE_TIME = 30000L;
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageAttachmentCache";
    public static String UPLOAD_LIMIT_PARAMETER_NAME = "attachment.upload.limit";
    private ConfigurationManager configManager;
    private OrganizationService orgService;
    private UserACL userACL;
    private DataStorage dataStorage;
    private List<ValuesParam> syntaxHelpParams;
    private PropertiesParam preferencesParams;
    private List<ComponentPlugin> plugins_ = new ArrayList<ComponentPlugin>();
    private List<WikiTemplatePagePlugin> templatePagePlugins_ = new ArrayList<WikiTemplatePagePlugin>();
    private List<WikiEmotionIconsPlugin> emotionIconsPlugins = new ArrayList<WikiEmotionIconsPlugin>();
    private static final Log log = ExoLogger.getLogger(WikiServiceImpl.class);
    private long autoSaveInterval;
    private long editPageLivingTime_;
    private String wikiWebappUri;
    private ExoCache<Integer, MarkupData> renderingCache;
    private ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();
    private int uploadLimit = 200;

    public WikiServiceImpl(ConfigurationManager configManager, UserACL userACL, DataStorage dataStorage, CacheService cacheService, OrganizationService orgService, InitParams initParams) {
        String autoSaveIntervalProperty = System.getProperty("wiki.autosave.interval");
        this.autoSaveInterval = autoSaveIntervalProperty == null || autoSaveIntervalProperty.isEmpty() ? 30000L : Long.parseLong(autoSaveIntervalProperty);
        this.configManager = configManager;
        this.userACL = userACL;
        this.dataStorage = dataStorage;
        this.orgService = orgService;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        if (initParams != null) {
            String uploadLimitParamValue;
            Iterator helps = initParams.getValuesParamIterator();
            this.syntaxHelpParams = helps != null ? IteratorUtils.toList((Iterator)initParams.getValuesParamIterator()) : new ArrayList<ValuesParam>();
            this.preferencesParams = initParams.getPropertiesParam(PREFERENCES);
            if (initParams.containsKey((Object)UPLOAD_LIMIT_PARAMETER_NAME) && StringUtils.isNotBlank((String)(uploadLimitParamValue = initParams.getValueParam(UPLOAD_LIMIT_PARAMETER_NAME).getValue()))) {
                this.uploadLimit = Integer.parseInt(uploadLimitParamValue);
            }
        }
        this.wikiWebappUri = System.getProperty("wiki.permalink.appuri");
        if (StringUtils.isEmpty((String)this.wikiWebappUri)) {
            this.wikiWebappUri = DEFAULT_WIKI_NAME;
        }
        this.editPageLivingTime_ = Long.parseLong(initParams.getValueParam("wiki.editPage.livingTime").getValue());
    }

    public void start() {
        this.initEmotionIcons();
    }

    public void stop() {
    }

    public ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public void addComponentPlugin(ComponentPlugin plugin) {
        if (plugin != null) {
            this.plugins_.add(plugin);
        }
    }

    @Override
    public void addWikiTemplatePagePlugin(WikiTemplatePagePlugin plugin) {
        if (plugin != null) {
            this.templatePagePlugins_.add(plugin);
        }
    }

    @Override
    public void addEmotionIconsPlugin(WikiEmotionIconsPlugin plugin) {
        if (plugin != null) {
            this.emotionIconsPlugins.add(plugin);
        }
    }

    @Override
    public List<PageWikiListener> getPageListeners() {
        ArrayList<PageWikiListener> pageListeners = new ArrayList<PageWikiListener>();
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof PageWikiListener)) continue;
            pageListeners.add((PageWikiListener)c);
        }
        return pageListeners;
    }

    @Override
    public List<AttachmentWikiListener> getAttachmentListeners() {
        ArrayList<AttachmentWikiListener> attachmentListeners = new ArrayList<AttachmentWikiListener>();
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof AttachmentWikiListener)) continue;
            attachmentListeners.add((AttachmentWikiListener)c);
        }
        return attachmentListeners;
    }

    @Override
    public String getWikiWebappUri() {
        return this.wikiWebappUri;
    }

    @Override
    public String getDefaultWikiSyntaxId() {
        if (this.preferencesParams != null) {
            return this.preferencesParams.getProperty(DEFAULT_SYNTAX);
        }
        return "xhtml/1.0";
    }

    @Override
    public long getSaveDraftSequenceTime() {
        return this.autoSaveInterval;
    }

    @Override
    public long getEditPageLivingTime() {
        return this.editPageLivingTime_;
    }

    @Override
    public Wiki getWikiByTypeAndOwner(String wikiType, String owner) throws WikiException {
        return this.dataStorage.getWikiByTypeAndOwner(wikiType, owner);
    }

    @Override
    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        return this.dataStorage.getWikisByType(wikiType);
    }

    @Override
    public Wiki getOrCreateUserWiki(String username) throws WikiException {
        return this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, username);
    }

    @Override
    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws WikiException {
        return this.dataStorage.getWikiPermission(wikiType, wikiOwner);
    }

    @Override
    public void updateWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws WikiException {
        this.dataStorage.updateWikiPermission(wikiType, wikiOwner, permissionEntries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PermissionEntry> getWikiDefaultPermissions(String wikiType, String wikiOwner) throws WikiException {
        Permission[] allPermissions = new Permission[]{new Permission(PermissionType.ADMINPAGE, true), new Permission(PermissionType.ADMINSPACE, true)};
        ArrayList<PermissionEntry> permissions = new ArrayList<PermissionEntry>();
        if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
            for (Map.Entry<String, IDType> entry : Utils.getACLForAdmins().entrySet()) {
                PermissionEntry permissionEntry = new PermissionEntry(entry.getKey(), "", entry.getValue(), allPermissions);
                permissions.add(permissionEntry);
            }
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
            try {
                UserPortalConfig userPortalConfig;
                if (userPortalConfigService == null || (userPortalConfig = userPortalConfigService.getUserPortalConfig(wikiOwner, null)) == null) return permissions;
                PortalConfig portalConfig = userPortalConfig.getPortalConfig();
                PermissionEntry portalPermissionEntry = new PermissionEntry(portalConfig.getEditPermission(), "", IDType.MEMBERSHIP, allPermissions);
                permissions.add(portalPermissionEntry);
                return permissions;
            }
            catch (Exception e) {
                throw new WikiException("Cannot get user portal config for wiki " + wikiType + ":" + wikiOwner + " - Cause : " + e.getMessage(), e);
            }
        } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            PermissionEntry groupPermissionEntry = new PermissionEntry(this.userACL.getMakableMT() + ":" + wikiOwner, "", IDType.MEMBERSHIP, allPermissions);
            permissions.add(groupPermissionEntry);
            return permissions;
        } else {
            if (!PortalConfig.USER_TYPE.equals(wikiType)) return permissions;
            PermissionEntry ownerPermissionEntry = new PermissionEntry(wikiOwner, "", IDType.USER, allPermissions);
            permissions.add(ownerPermissionEntry);
        }
        return permissions;
    }

    @Override
    public Wiki getWikiById(String wikiId) throws WikiException {
        Wiki wiki;
        if (wikiId.startsWith("/spaces/")) {
            wiki = this.getWikiByTypeAndOwner(PortalConfig.GROUP_TYPE, wikiId);
        } else if (wikiId.startsWith("/user/")) {
            wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            wiki = this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, wikiId);
        } else {
            if (wikiId.startsWith("/")) {
                wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            }
            wiki = this.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, wikiId);
        }
        return wiki;
    }

    @Override
    public String getWikiNameById(String wikiId) throws WikiException {
        Wiki wiki = this.getWikiById(wikiId);
        if (WikiType.PORTAL.equals(wiki.getType())) {
            String displayName = wiki.getId();
            int slashIndex = displayName.lastIndexOf(47);
            if (slashIndex > -1) {
                displayName = displayName.substring(slashIndex + 1);
            }
            return displayName;
        }
        if (WikiType.USER.equals(wiki.getType())) {
            String currentUser = Utils.getCurrentUser();
            if (wiki.getOwner().equals(currentUser)) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                return res.getString("UISpaceSwitcher.title.my-space");
            }
            return wiki.getOwner();
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        return wikiService.getSpaceNameByGroupId(wiki.getOwner());
    }

    @Override
    public Wiki createWiki(String wikiType, String owner) throws WikiException {
        Wiki wiki = this.getWikiByTypeAndOwner(wikiType, owner);
        if (wiki != null) {
            throw new WikiException("Wiki with type '" + wikiType + "' and owner = '" + owner + "' already exists");
        }
        wiki = new Wiki(wikiType, owner);
        wiki.setPermissions(this.getWikiDefaultPermissions(wikiType, owner));
        WikiPreferences wikiPreferences = new WikiPreferences();
        WikiPreferencesSyntax wikiPreferencesSyntax = new WikiPreferencesSyntax();
        wikiPreferencesSyntax.setDefaultSyntax(this.getDefaultWikiSyntaxId());
        wikiPreferences.setWikiPreferencesSyntax(wikiPreferencesSyntax);
        wiki.setPreferences(wikiPreferences);
        Wiki createdWiki = this.dataStorage.createWiki(wiki);
        StringBuilder sb = new StringBuilder("<h1> Welcome to ");
        String wikiLabel = owner;
        if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
            sb.append("Space ");
            wikiLabel = this.getSpaceNameByGroupId(owner);
        } else if (wikiType.equals(PortalConfig.USER_TYPE)) {
            wikiLabel = this.getUserDisplayName(wiki.getOwner());
        }
        sb.append(wikiLabel).append(" Notes Home </h1>");
        createdWiki.getWikiHome().setContent(sb.toString());
        this.updatePage(createdWiki.getWikiHome(), null);
        for (WikiTemplatePagePlugin templatePlugin : this.templatePagePlugins_) {
            if (templatePlugin == null || templatePlugin.getTemplates() == null) continue;
            for (Template template : templatePlugin.getTemplates()) {
                try {
                    InputStream templateInputStream = this.configManager.getInputStream(template.getSourceFilePath());
                    template.setContent(IOUtils.toString((InputStream)templateInputStream));
                    this.dataStorage.createTemplatePage(createdWiki, template);
                }
                catch (Exception e) {
                    log.error((Object)("Cannot init template " + template.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return createdWiki;
    }

    private String getUserDisplayName(String username) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username, UserStatus.ANY);
            StringBuilder nameBuilder = new StringBuilder(user.getFirstName());
            nameBuilder.append(" ").append(user.getLastName());
            return nameBuilder.toString();
        }
        catch (Exception e) {
            return username;
        }
    }

    @Override
    public Page createPage(Wiki wiki, String parentPageName, Page page) throws WikiException {
        String pageName = TitleResolver.getId(page.getTitle(), false);
        page.setName(pageName);
        if (this.isExisting(wiki.getType(), wiki.getOwner(), pageName)) {
            throw new WikiException("Page " + wiki.getType() + ":" + wiki.getOwner() + ":" + pageName + " already exists, cannot create it.");
        }
        Page parentPage = this.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), parentPageName);
        List<PermissionEntry> permissions = page.getPermissions();
        if (permissions == null) {
            if (parentPage.getPermissions() != null) {
                permissions = parentPage.getPermissions();
            } else {
                Page wikiHomePage = wiki.getWikiHome();
                permissions = wikiHomePage.getPermissions();
            }
            page.setPermissions(permissions);
        }
        Page createdPage = this.dataStorage.createPage(wiki, parentPage, page);
        this.invalidateCache(parentPage);
        this.invalidateCache(page);
        this.postAddPage(wiki.getType(), wiki.getOwner(), page.getName(), createdPage);
        return createdPage;
    }

    @Override
    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        Identity user;
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (page != null && !this.hasPermissionOnPage(page, PermissionType.VIEWPAGE, user = ConversationState.getCurrent().getIdentity())) {
            page = null;
        }
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public Page getPageById(String id) throws WikiException {
        if (id == null) {
            return null;
        }
        return this.dataStorage.getPageById(id);
    }

    @Override
    public DraftPage getDraftPageById(String id) throws WikiException {
        if (id == null) {
            return null;
        }
        return this.dataStorage.getDraftPageById(id);
    }

    @Override
    public Page getPageByRootPermission(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.dataStorage.getPageOfWikiByName(wikiType, wikiOwner, pageId);
    }

    @Override
    public Page getParentPageOf(Page page) throws WikiException {
        return this.dataStorage.getParentPageOf(page);
    }

    @Override
    public List<Page> getChildrenPageOf(Page page) throws WikiException {
        return this.dataStorage.getChildrenPageOf(page);
    }

    @Override
    public boolean deletePage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        block7: {
            if ("Home".equals(pageName) || pageName == null) {
                return false;
            }
            try {
                Page page = this.getPageOfWikiByName(wikiType, wikiOwner, pageName);
                if (page != null) {
                    this.invalidateCachesOfPageTree(page);
                    this.invalidateAttachmentCache(page);
                    ArrayList<Page> allChrildrenPages = new ArrayList<Page>();
                    LinkedList<Page> queue = new LinkedList<Page>();
                    queue.add(page);
                    while (!queue.isEmpty()) {
                        Page tempPage = (Page)queue.poll();
                        List<Page> childrenPages = this.getChildrenPageOf(tempPage);
                        for (Page childPage : childrenPages) {
                            queue.add(childPage);
                            allChrildrenPages.add(childPage);
                        }
                    }
                    this.dataStorage.deletePage(wikiType, wikiOwner, pageName);
                    this.postDeletePage(wikiType, wikiOwner, pageName, page);
                    for (Page childPage : allChrildrenPages) {
                        this.postDeletePage(childPage.getWikiType(), childPage.getWikiOwner(), childPage.getName(), childPage);
                    }
                    break block7;
                }
                log.error((Object)("Can't delete page '" + pageName + "'. This page does not exist."));
                return false;
            }
            catch (WikiException e) {
                log.error((Object)("Can't delete page '" + pageName + "' "), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws WikiException {
        if ("Home".equals(pageName) || pageName == null) {
            return false;
        }
        if (!pageName.equals(newName) && this.isExisting(wikiType, wikiOwner, newName)) {
            throw new WikiException("Page " + wikiType + ":" + wikiOwner + ":" + newName + " already exists, cannot rename it.");
        }
        this.dataStorage.renamePage(wikiType, wikiOwner, pageName, newName, newTitle);
        Page page = new Page(pageName);
        page.setWikiType(wikiType);
        page.setWikiOwner(wikiOwner);
        this.invalidateCache(page);
        return true;
    }

    @Override
    public boolean movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        try {
            Page movePage = this.getPageOfWikiByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            this.dataStorage.movePage(currentLocationParams, newLocationParams);
            Page page = new Page(currentLocationParams.getPageName());
            page.setWikiType(currentLocationParams.getType());
            page.setWikiOwner(currentLocationParams.getOwner());
            this.invalidateCache(page);
            this.invalidateAttachmentCache(page);
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), movePage.getName(), movePage, PageUpdateType.MOVE_PAGE);
        }
        catch (WikiException e) {
            log.error((Object)("Can't move page '" + currentLocationParams.getPageName() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public String getPageRenderedContent(Page page) {
        String renderedContent = "";
        try {
            MarkupKey key = new MarkupKey(new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName()), false);
            MarkupData cachedData = (MarkupData)this.renderingCache.get((Serializable)new Integer(key.hashCode()));
            if (cachedData != null) {
                return cachedData.build();
            }
            PageContentMigrationService pageContentMigrationService = (PageContentMigrationService)ExoContainerContext.getService(PageContentMigrationService.class);
            if (pageContentMigrationService != null) {
                pageContentMigrationService.migratePage(page);
            }
            renderedContent = page.getContent();
            this.renderingCache.put((Serializable)new Integer(key.hashCode()), (Object)new MarkupData(renderedContent));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get rendered content of page [%s:%s:%s]", page.getWikiType(), page.getWikiOwner(), page.getName()), (Throwable)e);
        }
        return renderedContent;
    }

    @Override
    public void addPageLink(WikiPageParams param, WikiPageParams entity) {
        List<WikiPageParams> linkParams = this.pageLinksMap.get(entity);
        if (linkParams == null) {
            linkParams = new ArrayList<WikiPageParams>();
            this.pageLinksMap.put(entity, linkParams);
        }
        linkParams.add(param);
    }

    protected void invalidateCache(Page page) {
        WikiPageParams params = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(params);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(params);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName()));
            }
        }
    }

    protected void invalidateAttachmentCache(Page page) {
        WikiPageParams wikiPageParams = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(wikiPageParams);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(wikiPageParams);
        for (WikiPageParams linkedWikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", linkedWikiPageParams.getType(), linkedWikiPageParams.getOwner(), linkedWikiPageParams.getPageName()));
            }
        }
    }

    protected void invalidateCachesOfPageTree(Page page) throws WikiException {
        LinkedList<Page> queue = new LinkedList<Page>();
        queue.add(page);
        while (!queue.isEmpty()) {
            Page currentPage = (Page)queue.poll();
            this.invalidateCache(currentPage);
            List<Page> childrenPages = this.getChildrenPageOf(currentPage);
            for (Page child : childrenPages) {
                queue.add(child);
            }
        }
    }

    @Override
    public Page getRelatedPage(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.dataStorage.getRelatedPage(wikiType, wikiOwner, pageId);
    }

    @Override
    public boolean isExisting(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.getPageByRootPermission(wikiType, wikiOwner, pageId) != null;
    }

    @Override
    public PageList<SearchResult> search(WikiSearchData data) throws WikiException {
        try {
            ObjectPageList result = this.dataStorage.search(data);
            if (data.getTitle() != null && data.getWikiType() != null && data.getWikiOwner() != null && result.getPageSize() > 0) {
                Page homePage = this.getWikiByTypeAndOwner(data.getWikiType(), data.getWikiOwner()).getWikiHome();
                if (data.getTitle().equals("") || homePage != null && homePage.getTitle().contains(data.getTitle())) {
                    Calendar wikiHomeCreateDate = Calendar.getInstance();
                    wikiHomeCreateDate.setTime(homePage.getCreatedDate());
                    Calendar wikiHomeUpdateDate = Calendar.getInstance();
                    wikiHomeUpdateDate.setTime(homePage.getUpdatedDate());
                    SearchResult wikiHomeResult = new SearchResult(data.getWikiType(), data.getWikiOwner(), homePage.getName(), null, null, homePage.getTitle(), SearchResultType.PAGE, wikiHomeUpdateDate, wikiHomeCreateDate);
                    List tempSearchResult = result.getAll();
                    tempSearchResult.add(wikiHomeResult);
                    result = new ObjectPageList(tempSearchResult, result.getPageSize());
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Cannot search on wiki " + data.getWikiType() + ":" + data.getWikiOwner() + " - Cause : " + e.getMessage()), (Throwable)e);
            return new ObjectPageList(new ArrayList(), 0);
        }
    }

    @Override
    public Page getHelpSyntaxPage(String syntaxId, boolean fullContent) throws WikiException {
        return null;
    }

    @Override
    public List<EmotionIcon> getEmotionIcons() throws WikiException {
        return this.dataStorage.getEmotionIcons();
    }

    @Override
    public EmotionIcon getEmotionIconByName(String name) throws WikiException {
        return this.dataStorage.getEmotionIconByName(name);
    }

    @Override
    public List<Page> getDuplicatePages(Page parentPage, Wiki targetWiki, List<Page> resultList) throws WikiException {
        if (resultList == null) {
            resultList = new ArrayList<Page>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetWiki.getType(), targetWiki.getOwner(), parentPage.getName())) {
            resultList.add(parentPage);
        }
        List<Page> childrenPages = this.getChildrenPageOf(parentPage);
        for (Page page : childrenPages) {
            this.getDuplicatePages(page, targetWiki, resultList);
        }
        return resultList;
    }

    @Override
    public boolean hasPermissionOnWiki(Wiki wiki, PermissionType permissionType, Identity user) throws WikiException {
        return this.dataStorage.hasPermissionOnWiki(wiki, permissionType, user);
    }

    @Override
    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, Identity user) throws WikiException {
        return this.dataStorage.hasPermissionOnPage(page, permissionType, user);
    }

    @Override
    public boolean canModifyPagePermission(Page currentPage, String currentUser) throws WikiException {
        Wiki wiki;
        boolean canModifyPage = false;
        String owner = currentPage.getOwner();
        boolean isPageOwner = owner != null && owner.equals(currentUser);
        boolean hasEditPagePermissionOnPage = false;
        if (currentPage.getPermissions() != null) {
            for (PermissionEntry permissionEntry : currentPage.getPermissions()) {
                if (permissionEntry.getId().equals(currentUser)) {
                    for (Permission permission : permissionEntry.getPermissions()) {
                        if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE) || !permission.isAllowed()) continue;
                        hasEditPagePermissionOnPage = true;
                        break;
                    }
                }
                if (!hasEditPagePermissionOnPage) continue;
                break;
            }
        }
        canModifyPage = isPageOwner && hasEditPagePermissionOnPage ? true : this.hasAdminSpacePermission((wiki = this.getWikiByTypeAndOwner(currentPage.getWikiType(), currentPage.getWikiOwner())).getType(), wiki.getOwner()) || this.hasAdminPagePermission(wiki.getType(), wiki.getOwner());
        return canModifyPage;
    }

    @Override
    public boolean canPublicAndRetrictPage(Page currentPage, String currentUser) throws WikiException {
        Wiki wiki;
        if (currentPage.getPermissions() != null) {
            for (PermissionEntry permissionEntry : currentPage.getPermissions()) {
                if (!permissionEntry.getId().equals(currentUser)) continue;
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE) || !permission.isAllowed()) continue;
                    return true;
                }
            }
        }
        return this.hasAdminPagePermission((wiki = this.getWikiByTypeAndOwner(currentPage.getWikiType(), currentPage.getWikiOwner())).getType(), wiki.getOwner()) || this.hasAdminSpacePermission(wiki.getType(), wiki.getOwner());
    }

    @Override
    public List<PageVersion> getVersionsOfPage(Page page) throws WikiException {
        List<PageVersion> versions = this.dataStorage.getVersionsOfPage(page);
        if (versions == null || versions.isEmpty()) {
            this.dataStorage.addPageVersion(page);
            versions = this.dataStorage.getVersionsOfPage(page);
        }
        return versions;
    }

    @Override
    public PageVersion getVersionOfPageByName(String versionName, Page page) throws WikiException {
        List<PageVersion> versions = this.getVersionsOfPage(page);
        PageVersion pageVersion = null;
        if (versions != null) {
            for (PageVersion version : versions) {
                if (!version.getName().equals(versionName)) continue;
                pageVersion = version;
                break;
            }
        }
        return pageVersion;
    }

    @Override
    public void createVersionOfPage(Page page) throws WikiException {
        this.dataStorage.addPageVersion(page);
    }

    @Override
    public void restoreVersionOfPage(String versionName, Page page) throws WikiException {
        this.dataStorage.restoreVersionOfPage(versionName, page);
        this.createVersionOfPage(page);
        this.invalidateCache(page);
    }

    @Override
    public void updatePage(Page page, PageUpdateType updateType) throws WikiException {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        ListenerService listenerService = (ListenerService)PortalContainer.getComponent(ListenerService.class);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)updateType) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)updateType)) {
            page.setUpdatedDate(Calendar.getInstance().getTime());
        }
        this.dataStorage.updatePage(page);
        this.invalidateCache(page);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)updateType) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)updateType)) {
            try {
                listenerService.broadcast("exo.wiki.edit", (Object)wikiService, (Object)page);
            }
            catch (Exception e) {
                log.error((Object)"Error while broadcasting wiki edition event", (Throwable)e);
            }
        }
        this.postUpdatePage(page.getWikiType(), page.getWikiOwner(), page.getName(), page, updateType);
    }

    @Override
    public List<String> getPreviousNamesOfPage(Page page) throws WikiException {
        return this.dataStorage.getPreviousNamesOfPage(page);
    }

    @Override
    public void createTemplatePage(Wiki wiki, Template template) throws WikiException {
        this.dataStorage.createTemplatePage(wiki, template);
    }

    @Override
    public Template getTemplatePage(WikiPageParams params, String templateId) throws WikiException {
        return this.dataStorage.getTemplatePage(params, templateId);
    }

    @Override
    public Map<String, Template> getTemplates(WikiPageParams params) throws WikiException {
        return this.dataStorage.getTemplates(params);
    }

    @Override
    public List<TemplateSearchResult> searchTemplate(TemplateSearchData data) throws WikiException {
        return this.dataStorage.searchTemplate(data);
    }

    @Override
    public void updateTemplate(Template template) throws WikiException {
        this.dataStorage.updateTemplatePage(template);
    }

    @Override
    public void deleteTemplatePage(String wikiType, String wikiOwner, String templateName) throws WikiException {
        this.dataStorage.deleteTemplatePage(wikiType, wikiOwner, templateName);
    }

    @Override
    public void addRelatedPage(WikiPageParams orginaryPageParams, WikiPageParams relatedPageParams) throws WikiException {
        if (relatedPageParams == null) {
            throw new IllegalArgumentException("relatedPageParams shouldn't be null");
        }
        Page orginary = this.getPageOfWikiByName(orginaryPageParams.getType(), orginaryPageParams.getOwner(), orginaryPageParams.getPageName());
        Page related = this.getPageOfWikiByName(relatedPageParams.getType(), relatedPageParams.getOwner(), relatedPageParams.getPageName());
        if (related == null) {
            throw new IllegalStateException("Cannot find related page with parameters type = " + relatedPageParams.getType() + " owner = " + relatedPageParams.getOwner() + " pageName = " + relatedPageParams.getPageName());
        }
        this.dataStorage.addRelatedPage(orginary, related);
    }

    @Override
    public List<Page> getRelatedPagesOfPage(Page page) throws WikiException {
        return this.dataStorage.getRelatedPagesOfPage(page);
    }

    @Override
    public void removeRelatedPage(WikiPageParams orginaryPageParams, WikiPageParams relatedPageParams) throws WikiException {
        Page originary = this.getPageOfWikiByName(orginaryPageParams.getType(), orginaryPageParams.getOwner(), orginaryPageParams.getPageName());
        Page related = this.getPageOfWikiByName(relatedPageParams.getType(), relatedPageParams.getOwner(), relatedPageParams.getPageName());
        this.dataStorage.removeRelatedPage(originary, related);
    }

    @Override
    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageId) throws WikiException {
        Identity user = ConversationState.getCurrent().getIdentity();
        Page existedPage = this.getPageByRootPermission(wikiType, wikiOwner, pageId);
        if (existedPage != null && (user == null || this.hasPermissionOnPage(existedPage, PermissionType.VIEWPAGE, user) || this.hasPermissionOnPage(existedPage, PermissionType.VIEW_ATTACHMENT, user))) {
            return existedPage;
        }
        return this.dataStorage.getExsitedOrNewDraftPageById(wikiType, wikiOwner, pageId, user.getUserId());
    }

    @Override
    public DraftPage createDraftForNewPage(DraftPage draftPage, Page parentPage, long clientTime) throws WikiException {
        String draftSuffix = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(parentPage.getId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        Wiki wiki = this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, Utils.getCurrentUser());
        if (wiki == null) {
            this.createWiki(PortalConfig.USER_TYPE, Utils.getCurrentUser());
        }
        this.dataStorage.createDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForExistPage(DraftPage draftPage, Page targetPage, String revision, long clientTime) throws WikiException {
        String draftSuffix = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(targetPage.getId());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((String)revision)) {
            List<PageVersion> versions = this.getVersionsOfPage(targetPage);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(versions.get(0).getName());
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        Wiki wiki = this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, Utils.getCurrentUser());
        if (wiki == null) {
            this.createWiki(PortalConfig.USER_TYPE, Utils.getCurrentUser());
        }
        this.dataStorage.createDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage getDraftOfPage(Page page) throws WikiException {
        List<DraftPage> draftPages = this.getDraftsOfUser(Utils.getCurrentUser());
        for (DraftPage draftPage : draftPages) {
            if (draftPage.getTargetPageId() == null || !draftPage.getTargetPageId().equals(page.getId())) continue;
            return draftPage;
        }
        return null;
    }

    @Override
    public DraftPage getLastestDraft() throws WikiException {
        String currentUser = Utils.getCurrentUser();
        if (IdentityConstants.ANONIM.equals(currentUser)) {
            return null;
        }
        return this.dataStorage.getLastestDraft(currentUser);
    }

    @Override
    public DraftPage getDraft(String draftName) throws WikiException {
        if (draftName == null) {
            return null;
        }
        String currentUser = Utils.getCurrentUser();
        if (currentUser == null || IdentityConstants.ANONIM.equals(currentUser)) {
            return null;
        }
        return this.dataStorage.getDraft(draftName, currentUser);
    }

    @Override
    public void removeDraftOfPage(WikiPageParams param) throws WikiException {
        Page page = this.getPageOfWikiByName(param.getType(), param.getOwner(), param.getPageName());
        this.dataStorage.deleteDraftOfPage(page, Utils.getCurrentUser());
    }

    @Override
    public void removeDraft(String draftName) throws WikiException {
        this.dataStorage.deleteDraftByName(draftName, Utils.getCurrentUser());
    }

    @Override
    public List<DraftPage> getDraftsOfUser(String username) throws WikiException {
        List<DraftPage> draftPages = new ArrayList<DraftPage>();
        if (!IdentityConstants.ANONIM.equals(username)) {
            draftPages = this.dataStorage.getDraftPagesOfUser(username);
        }
        return draftPages;
    }

    @Override
    public boolean isDraftOutDated(DraftPage draftPage) throws WikiException {
        Page targetPage;
        String targetRevision = draftPage.getTargetPageRevision();
        if (targetRevision == null) {
            return false;
        }
        if (targetRevision.equals("rootVersion")) {
            targetRevision = "1";
        }
        if ((targetPage = this.getPageById(draftPage.getTargetPageId())) == null) {
            return true;
        }
        String lastestRevision = null;
        List<PageVersion> versions = this.getVersionsOfPage(targetPage);
        if (versions != null && !versions.isEmpty()) {
            lastestRevision = versions.get(0).getName();
        }
        if (lastestRevision == null) {
            return true;
        }
        if (lastestRevision.equals("rootVersion")) {
            lastestRevision = "1";
        }
        return lastestRevision.compareTo(targetRevision) > 0;
    }

    @Override
    public DiffResult getDraftChanges(DraftPage draftPage) throws WikiException {
        DiffResult diffResult;
        String targetContent = "";
        if (!draftPage.isNewPage()) {
            List<PageVersion> versions;
            Wiki wiki = this.getWikiByTypeAndOwner(draftPage.getWikiType(), draftPage.getWikiOwner());
            Page targetPage = this.getPageById(draftPage.getTargetPageId());
            if (targetPage != null && (versions = this.getVersionsOfPage(targetPage)) != null && !versions.isEmpty()) {
                PageVersion lastestRevision = versions.get(0);
                targetContent = lastestRevision.getContent();
            }
        }
        DiffService diffService = (DiffService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(DiffService.class);
        try {
            diffResult = diffService.getDifferencesAsHTML(targetContent, draftPage.getContent(), true);
        }
        catch (DifferentiationFailedException e) {
            throw new WikiException("Cannot get changes of draft " + draftPage.getWikiType() + ":" + draftPage.getWikiOwner() + ":" + draftPage.getName() + " - Cause : " + e.getMessage(), e);
        }
        return diffResult;
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page) throws WikiException {
        return this.dataStorage.getAttachmentsOfPage(page);
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.dataStorage.getAttachmentsOfPage(page, loadContent);
    }

    @Override
    public int getNbOfAttachmentsOfPage(Page page) throws WikiException {
        int nbOfAttachments = 0;
        WikiPageParams wikiPageParams = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        MarkupKey key = new MarkupKey(wikiPageParams, false);
        Integer cacheKey = new Integer(key.hashCode());
        AttachmentCountData cachedNbOfAttachments = (AttachmentCountData)this.attachmentCountCache.get((Serializable)cacheKey);
        if (cachedNbOfAttachments != null) {
            nbOfAttachments = cachedNbOfAttachments.build();
        } else {
            try {
                List<Attachment> attachments = this.dataStorage.getAttachmentsOfPage(page, false);
                nbOfAttachments = attachments == null ? 0 : attachments.size();
                this.attachmentCountCache.put((Serializable)cacheKey, (Object)new AttachmentCountData(nbOfAttachments));
            }
            catch (WikiException e) {
                log.error((Object)("Cannot get number of attachments of " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            }
        }
        return nbOfAttachments;
    }

    @Override
    public Attachment getAttachmentOfPageByName(String attachmentName, Page page) throws WikiException {
        return this.getAttachmentOfPageByName(attachmentName, page, false);
    }

    @Override
    public Attachment getAttachmentOfPageByName(String attachmentName, Page page, boolean loadContent) throws WikiException {
        Attachment attachment = null;
        List<Attachment> attachments = this.dataStorage.getAttachmentsOfPage(page, loadContent);
        for (Attachment att : attachments) {
            if (!att.getName().equals(attachmentName)) continue;
            attachment = att;
            break;
        }
        return attachment;
    }

    @Override
    public void addAttachmentToPage(Attachment attachment, Page page) throws WikiException {
        this.dataStorage.addAttachmentToPage(attachment, page);
        this.invalidateAttachmentCache(page);
        this.addAttachment(attachment, page);
    }

    @Override
    public void deleteAttachmentOfPage(String attachmentId, Page page) throws WikiException {
        this.deleteAttachment(attachmentId, page);
        this.dataStorage.deleteAttachmentOfPage(attachmentId, page);
        this.invalidateAttachmentCache(page);
    }

    @Override
    public List<String> getWatchersOfPage(Page page) throws WikiException {
        return this.dataStorage.getWatchersOfPage(page);
    }

    @Override
    public void addWatcherToPage(String username, Page page) throws WikiException {
        this.dataStorage.addWatcherToPage(username, page);
    }

    @Override
    public void deleteWatcherOfPage(String username, Page page) throws WikiException {
        this.dataStorage.deleteWatcherOfPage(username, page);
    }

    @Override
    public List<SpaceBean> searchSpaces(String keyword) throws WikiException {
        ArrayList<SpaceBean> spaceBeans = new ArrayList<SpaceBean>();
        String currentUser = Utils.getCurrentUser();
        try {
            if (StringUtils.isEmpty((String)keyword)) {
                keyword = "*";
            }
            keyword = keyword.trim();
            SpaceFilter spaceFilter = new SpaceFilter(keyword);
            spaceFilter.setRemoteId(currentUser);
            spaceFilter.setAppId("Wiki");
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            ListAccess spaces = spaceService.getAccessibleSpacesByFilter(currentUser, spaceFilter);
            for (Space space : (Space[])spaces.load(0, spaces.getSize())) {
                String groupId = space.getGroupId();
                String spaceName = space.getDisplayName();
                String avatarUrl = space.getAvatarUrl();
                if (StringUtils.isBlank((String)avatarUrl)) {
                    avatarUrl = this.getDefaultSpaceAvatarUrl();
                }
                spaceBeans.add(new SpaceBean(groupId, spaceName, PortalConfig.GROUP_TYPE, avatarUrl));
            }
        }
        catch (ClassNotFoundException e) {
            List<Wiki> wikis = this.getWikisByType(WikiType.GROUP.toString());
            if (keyword != null) {
                keyword = keyword.trim();
            }
            if (keyword != null) {
                for (Wiki wiki : wikis) {
                    if (!wiki.getId().contains(keyword)) continue;
                    spaceBeans.add(new SpaceBean(wiki.getOwner(), wiki.getId(), PortalConfig.GROUP_TYPE, ""));
                }
            }
        }
        catch (Exception e) {
            throw new WikiException("Error while searching in wikis for user " + currentUser + " - Cause : " + e.getMessage(), e);
        }
        return spaceBeans;
    }

    private String getDefaultSpaceAvatarUrl() {
        return "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
    }

    @Override
    public boolean hasAdminSpacePermission(String wikiType, String owner) throws WikiException {
        Identity user;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            user = conversationState.getIdentity();
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminSpacePermission(wikiType, owner, user);
    }

    @Override
    public String getSpaceNameByGroupId(String groupId) {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(groupId);
        if (space == null) {
            LOG.warn((Object)("Can't find space with group id " + groupId));
            return groupId.substring(groupId.lastIndexOf(47) + 1);
        }
        return space.getDisplayName();
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), page.getName()), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), page.getName()), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", ((Object)((Object)l)).toString(), page.getName()), (Throwable)e);
            }
        }
    }

    public void addAttachment(Attachment attachment, Page page) throws WikiException {
        List<AttachmentWikiListener> listeners = this.getAttachmentListeners();
        for (AttachmentWikiListener l : listeners) {
            try {
                l.addAttachment(attachment, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on attachment with name = [%s] failed", ((Object)((Object)l)).toString(), attachment.getName()), (Throwable)e);
            }
        }
    }

    public void deleteAttachment(String attachmentId, Page page) throws WikiException {
        List<AttachmentWikiListener> listeners = this.getAttachmentListeners();
        for (AttachmentWikiListener l : listeners) {
            try {
                l.deleteAttachment(attachmentId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on attachment with name = [%s] failed", ((Object)((Object)l)).toString(), attachmentId), (Throwable)e);
            }
        }
    }

    @Override
    public List<BreadcrumbData> getBreadcumb(String wikiType, String wikiOwner, String pageId) throws WikiException {
        return this.getBreadcumb(null, wikiType, wikiOwner, pageId);
    }

    @Override
    public WikiPageParams getWikiPageParams(BreadcrumbData data) {
        if (data != null) {
            return new WikiPageParams(data.getWikiType(), data.getWikiOwner(), data.getId());
        }
        return null;
    }

    @Override
    public boolean hasAdminPagePermission(String wikiType, String owner) throws WikiException {
        Identity user;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            user = conversationState.getIdentity();
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminPagePermission(wikiType, owner, user);
    }

    @Override
    public void createEmotionIcon(EmotionIcon emotionIcon) throws WikiException {
        this.dataStorage.createEmotionIcon(emotionIcon);
    }

    @Override
    public int getUploadLimit() {
        return this.uploadLimit;
    }

    private void checkToRemoveDomainInUrl(Page page) {
        block4: {
            if (page == null) {
                return;
            }
            String url = page.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    page.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }

    private List<BreadcrumbData> getBreadcumb(List<BreadcrumbData> list, String wikiType, String wikiOwner, String pageId) throws WikiException {
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (pageId == null) {
            return list;
        }
        Page page = this.getPageOfWikiByName(wikiType, wikiOwner, pageId);
        if (page == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(page.getName(), page.getTitle(), wikiType, wikiOwner));
        Page parentPage = this.getParentPageOf(page);
        if (parentPage != null) {
            this.getBreadcumb(list, wikiType, wikiOwner, parentPage.getName());
        }
        return list;
    }

    private void initEmotionIcons() {
        try {
            List<EmotionIcon> emotionIcons = this.getEmotionIcons();
            if (emotionIcons == null || emotionIcons.isEmpty()) {
                for (WikiEmotionIconsPlugin emotionIconsPlugin : this.emotionIconsPlugins) {
                    for (EmotionIcon emotionIcon : emotionIconsPlugin.getEmotionIcons()) {
                        try {
                            InputStream imageInputStream = this.configManager.getInputStream(emotionIcon.getImageFilePath());
                            emotionIcon.setImage(IOUtils.toByteArray((InputStream)imageInputStream));
                            this.createEmotionIcon(emotionIcon);
                        }
                        catch (Exception e) {
                            log.error((Object)("Cannot create emoticon " + emotionIcon.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (WikiException e) {
            log.error((Object)("Cannot init emotion icons - Cause : " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public List<Page> getPagesOfWiki(String wikiType, String wikiOwner) {
        return this.dataStorage.getPagesOfWiki(wikiType, wikiOwner);
    }
}

