/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.addons.rdbms.listener;

import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.WikiService;

public class WikiActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(WikiActivityUpdaterListener.class);
    private final WikiService service;

    public WikiActivityUpdaterListener(WikiService wikiService) {
        this.service = wikiService;
    }

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if ("ks-wiki:spaces".equals(activity.getType())) {
            String newActivityId = (String)event.getData();
            if (!activity.isComment()) {
                String pageOwner;
                LOG.info((Object)String.format("Migration the wiki activity '%s' with new id:: %s", activity.getTitle(), newActivityId));
                String pageId = (String)activity.getTemplateParams().get("page_id");
                if (pageId == null) {
                    return;
                }
                String pageType = (String)activity.getTemplateParams().get("page_type");
                Page page = this.service.getPageByRootPermission(pageType, pageOwner = (String)activity.getTemplateParams().get("page_owner"), pageId);
                if (page != null) {
                    page.setActivityId(newActivityId);
                    this.service.updatePage(page, null);
                } else {
                    LOG.warn((Object)("Cannot update the activity id of the page " + pageId + " because the page can not be retrieved"));
                }
            }
        }
    }
}

