/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;

public interface DataStorage {
    public Wiki getWikiByTypeAndOwner(String var1, String var2) throws WikiException;

    public List<Wiki> getWikisByType(String var1) throws WikiException;

    public Wiki createWiki(Wiki var1) throws WikiException;

    public Page createPage(Wiki var1, Page var2, Page var3) throws WikiException;

    public Page getPageOfWikiByName(String var1, String var2, String var3) throws WikiException;

    public Page getPageById(String var1) throws WikiException;

    public DraftPage getDraftPageById(String var1) throws WikiException;

    public Page getParentPageOf(Page var1) throws WikiException;

    public List<Page> getChildrenPageOf(Page var1) throws WikiException;

    public void createTemplatePage(Wiki var1, Template var2) throws WikiException;

    public void updateTemplatePage(Template var1) throws WikiException;

    public void deleteTemplatePage(String var1, String var2, String var3) throws WikiException;

    public void deletePage(String var1, String var2, String var3) throws WikiException;

    public Template getTemplatePage(WikiPageParams var1, String var2) throws WikiException;

    public Map<String, Template> getTemplates(WikiPageParams var1) throws WikiException;

    public void deleteDraftOfPage(Page var1, String var2) throws WikiException;

    public void deleteDraftByName(String var1, String var2) throws WikiException;

    public void renamePage(String var1, String var2, String var3, String var4, String var5) throws WikiException;

    public void movePage(WikiPageParams var1, WikiPageParams var2) throws WikiException;

    public List<PermissionEntry> getWikiPermission(String var1, String var2) throws WikiException;

    public void updateWikiPermission(String var1, String var2, List<PermissionEntry> var3) throws WikiException;

    public List<Page> getRelatedPagesOfPage(Page var1) throws WikiException;

    public Page getRelatedPage(String var1, String var2, String var3) throws WikiException;

    public void addRelatedPage(Page var1, Page var2) throws WikiException;

    public void removeRelatedPage(Page var1, Page var2) throws WikiException;

    public Page getExsitedOrNewDraftPageById(String var1, String var2, String var3, String var4) throws WikiException;

    public DraftPage getDraft(WikiPageParams var1, String var2) throws WikiException;

    public DraftPage getLastestDraft(String var1) throws WikiException;

    public DraftPage getDraft(String var1, String var2) throws WikiException;

    public List<DraftPage> getDraftPagesOfUser(String var1) throws WikiException;

    public void createDraftPageForUser(DraftPage var1, String var2) throws WikiException;

    public PageList<SearchResult> search(WikiSearchData var1) throws WikiException;

    public List<TemplateSearchResult> searchTemplate(TemplateSearchData var1) throws WikiException;

    default public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentsOfPage(page);
    }

    public List<Attachment> getAttachmentsOfPage(Page var1) throws WikiException;

    public void addAttachmentToPage(Attachment var1, Page var2) throws WikiException;

    public void deleteAttachmentOfPage(String var1, Page var2) throws WikiException;

    public Page getHelpSyntaxPage(String var1, boolean var2, List<ValuesParam> var3, ConfigurationManager var4) throws WikiException;

    public void createEmotionIcon(EmotionIcon var1) throws WikiException;

    public List<EmotionIcon> getEmotionIcons() throws WikiException;

    public EmotionIcon getEmotionIconByName(String var1) throws WikiException;

    public boolean hasPermissionOnPage(Page var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasPermissionOnWiki(Wiki var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasAdminSpacePermission(String var1, String var2, Identity var3) throws WikiException;

    public boolean hasAdminPagePermission(String var1, String var2, Identity var3) throws WikiException;

    public List<PageVersion> getVersionsOfPage(Page var1) throws WikiException;

    public void addPageVersion(Page var1) throws WikiException;

    public void restoreVersionOfPage(String var1, Page var2) throws WikiException;

    public void updatePage(Page var1) throws WikiException;

    public List<String> getPreviousNamesOfPage(Page var1) throws WikiException;

    public List<String> getWatchersOfPage(Page var1) throws WikiException;

    public void addWatcherToPage(String var1, Page var2) throws WikiException;

    public void deleteWatcherOfPage(String var1, Page var2) throws WikiException;

    public List<Page> getPagesOfWiki(String var1, String var2);
}

