/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.bean.DraftBean;
import org.exoplatform.wiki.webui.bean.WikiDraftListAccess;
import org.exoplatform.wiki.webui.commons.UIWikiDraftGrid;
import org.exoplatform.wiki.webui.popup.UIWikiPagePreview;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/UIWikiMyDraftsForm.gtmpl", events={@EventConfig(listeners={DeleteDraftActionListener.class}, confirm="UIWikiMyDraftsForm.msg.delete-confirm"), @EventConfig(listeners={ResumeDraftActionListener.class}), @EventConfig(listeners={ViewDraftChangeActionListener.class}), @EventConfig(listeners={SortDraftActionListener.class})})
public class UIWikiMyDraftsForm
extends UIForm {
    public static final int ITEMS_PER_PAGE = 20;
    public static final String DRAFT_GRID = "UIWikiDraftGrid";
    public static final String DRAFT_ITER = "DraftIter";
    public static final String ACTION_DELETE = "DeleteDraft";
    public static final String ACTION_RESUME = "ResumeDraft";
    public static final String ACTION_VIEW = "ViewDraftChange";
    public static final String ACTION_SORT = "SortDraft";
    public static final String[] DRAFT_FIELD = new String[]{"pageTitle", "place", "lastEdition"};
    public static final String[] USER_ACTIONS = new String[]{"ViewDraftChange", "DeleteDraft"};
    private WikiService wikiService;

    public UIWikiMyDraftsForm() throws Exception {
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.addChild(UIWikiDraftGrid.class, null, DRAFT_GRID);
        grid.getUIPageIterator().setId(DRAFT_ITER);
        grid.getUIPageIterator().setParent((UIComponent)this);
        grid.configure("id", DRAFT_FIELD, USER_ACTIONS);
        grid.setActionForField("pageTitle", ACTION_RESUME);
        grid.setFieldToDisplayBreadCrumb("place");
        this.initGrid();
        this.wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
    }

    public void initGrid() throws Exception {
        String currentUser = org.exoplatform.wiki.utils.Utils.getCurrentUser();
        if (currentUser == null || IdentityConstants.ANONIM.equals(currentUser)) {
            return;
        }
        WikiService wService = (WikiService)PortalContainer.getComponent(WikiService.class);
        List drafts = wService.getDraftsOfUser(org.exoplatform.wiki.utils.Utils.getCurrentUser());
        ArrayList<DraftBean> draftBeans = new ArrayList<DraftBean>();
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.getChild(UIWikiDraftGrid.class);
        grid.clearBreadcrum();
        ResourceBundle bundle = RequestContext.getCurrentInstance().getApplicationResourceBundle();
        String newPageHint = bundle.getString("UIWikiMyDraftsForm.title.new-page");
        for (DraftPage draftPage : drafts) {
            Page page;
            if (draftPage.getTargetPageId() == null || (page = wService.getPageById(draftPage.getTargetPageId())) == null) continue;
            Wiki wiki = wService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
            if (wiki == null) {
                this.wikiService.removeDraft(draftPage.getName());
                continue;
            }
            List breadcrumbDatas = wService.getBreadcumb(wiki.getType(), wiki.getOwner(), page.getName());
            grid.putBreadCrumbDatas(draftPage.getName(), breadcrumbDatas);
            Object draftTitle = draftPage.getTitle();
            if (draftPage.isNewPage()) {
                draftTitle = (String)draftTitle + newPageHint;
            }
            draftBeans.add(new DraftBean(draftPage.getName(), (String)draftTitle, grid.getWikiName(draftPage.getName()), draftPage.getUpdatedDate()));
        }
        if (grid.getSortField() == null) {
            grid.setSortField("lastEdition");
            grid.setASC(false);
        }
        this.sortDraft(draftBeans, grid.getSortField(), grid.isASC());
        LazyPageList lazylist = new LazyPageList((ListAccess)new WikiDraftListAccess(draftBeans), 20);
        grid.getUIPageIterator().setPageList((PageList)lazylist);
    }

    private void sortDraft(List<DraftBean> drafts, String field, boolean isASC) {
        if (field == null) {
            return;
        }
        if ("pageTitle".equals(field)) {
            Collections.sort(drafts, new Comparator<DraftBean>(){

                @Override
                public int compare(DraftBean o1, DraftBean o2) {
                    return o1.getPageTitle().compareTo(o2.getPageTitle());
                }
            });
        } else if ("place".equals(field)) {
            Collections.sort(drafts, new Comparator<DraftBean>(){

                @Override
                public int compare(DraftBean o1, DraftBean o2) {
                    return o1.getPlace().compareTo(o2.getPlace());
                }
            });
        } else if ("lastEdition".equals(field)) {
            Collections.sort(drafts, new Comparator<DraftBean>(){

                @Override
                public int compare(DraftBean o1, DraftBean o2) {
                    if (o1.getLastEditionInDate() == null) {
                        return 1;
                    }
                    if (o2.getLastEditionInDate() == null) {
                        return -1;
                    }
                    return (int)(o1.getLastEditionInDate().getTime() - o2.getLastEditionInDate().getTime());
                }
            });
        }
        if (!isASC) {
            Collections.reverse(drafts);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    protected String getActionLink(String action, String beanId) throws Exception {
        UIWikiDraftGrid grid = (UIWikiDraftGrid)this.getChild(UIWikiDraftGrid.class);
        return Utils.createFormActionLink(grid, action, beanId);
    }

    public static class SortDraftActionListener
    extends EventListener<UIWikiMyDraftsForm> {
        public void execute(Event<UIWikiMyDraftsForm> event) throws Exception {
            String sortId = event.getRequestContext().getRequestParameter("objectId");
            UIWikiMyDraftsForm uiWikiMyDraftsForm = (UIWikiMyDraftsForm)((Object)event.getSource());
            UIWikiDraftGrid grid = (UIWikiDraftGrid)uiWikiMyDraftsForm.getChildById(UIWikiMyDraftsForm.DRAFT_GRID);
            int underscoreIndex = sortId.indexOf(95);
            if (underscoreIndex > -1) {
                grid.setSortField(sortId.substring(0, underscoreIndex));
                grid.setASC("ASC".equals(sortId.substring(underscoreIndex + 1)));
                ((UIWikiMyDraftsForm)((Object)event.getSource())).initGrid();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
            }
        }
    }

    public static class DeleteDraftActionListener
    extends EventListener<UIWikiMyDraftsForm> {
        public void execute(Event<UIWikiMyDraftsForm> event) throws Exception {
            String draftId = event.getRequestContext().getRequestParameter("objectId");
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            wikiService.removeDraft(draftId);
            ((UIWikiMyDraftsForm)((Object)event.getSource())).initGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }

    public static class ViewDraftChangeActionListener
    extends EventListener<UIWikiMyDraftsForm> {
        public void execute(Event<UIWikiMyDraftsForm> event) throws Exception {
            String draftId = event.getRequestContext().getRequestParameter("objectId");
            UIWikiMyDraftsForm pageEditForm = (UIWikiMyDraftsForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)pageEditForm.getAncestorOfType(UIWikiPortlet.class);
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            DraftPage draftPage = wikiService.getDraft(draftId);
            if (draftPage != null) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                UIWikiMaskWorkspace uiMaskWS = (UIWikiMaskWorkspace)wikiPortlet.getChild(UIWikiMaskWorkspace.class);
                UIWikiPagePreview wikiPagePreview = (UIWikiPagePreview)uiMaskWS.createUIComponent(UIWikiPagePreview.class, null, null);
                wikiPagePreview.setPageTitle(draftPage.getTitle());
                wikiPagePreview.setContent(wikiService.getDraftChanges(draftPage).getDiffHTML());
                uiMaskWS.setUIComponent((UIComponent)wikiPagePreview);
                uiMaskWS.setShow(true);
                uiMaskWS.setPopupTitle(res.getString("DraftPage.title.draft-changes"));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            }
        }
    }

    public static class ResumeDraftActionListener
    extends EventListener<UIWikiMyDraftsForm> {
        public void execute(Event<UIWikiMyDraftsForm> event) throws Exception {
            Page targetPage;
            String draftId = event.getRequestContext().getRequestParameter("objectId");
            UIWikiMyDraftsForm myDraftForm = (UIWikiMyDraftsForm)((Object)event.getSource());
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)myDraftForm.getAncestorOfType(UIWikiPortlet.class);
            WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
            DraftPage draftPage = wikiService.getDraft(draftId);
            HttpSession session = Util.getPortalRequestContext().getRequest().getSession(false);
            session.setAttribute(Utils.getDraftIdSessionKey(), (Object)draftId);
            if (draftPage != null && draftPage.getTargetPageId() != null && (targetPage = wikiService.getPageById(draftPage.getTargetPageId())) != null) {
                Wiki wiki = wikiService.getWikiByTypeAndOwner(targetPage.getWikiType(), targetPage.getWikiOwner());
                WikiPageParams targetParam = new WikiPageParams(wiki.getType(), wiki.getOwner(), targetPage.getName());
                WikiMode mode = WikiMode.ADDPAGE;
                if (!draftPage.isNewPage()) {
                    mode = WikiMode.EDITPAGE;
                }
                UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
                UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
                UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
                String title = draftPage.getTitle();
                String content = draftPage.getContent();
                titleInput.setReadOnly(false);
                titleInput.setValue((Object)StringCommonUtils.decodeSpecialCharToHTMLnumber((String)title));
                pageEditForm.setTitle(title);
                markupInput.setValue((Object)content);
                UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
                if (wikiRichTextArea.isRendered()) {
                    Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
                }
                pageEditForm.setInitDraftName(draftPage.getName());
                wikiPortlet.changeMode(mode);
                Utils.redirect(targetParam, mode);
            }
        }
    }
}

