/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.wiki.service.ExportAction;
import org.exoplatform.wiki.service.ExportData;
import org.exoplatform.wiki.service.ExportResource;
import org.exoplatform.wiki.service.ExportStatus;
import org.exoplatform.wiki.service.ExportThread;
import org.exoplatform.wiki.service.ExportingStatus;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.picocontainer.Startable;

public class NotesExportService
implements Startable {
    private static final Log log = ExoLogger.getLogger(NotesExportService.class);
    private static final List<ExportResource> exportResourceList = new ArrayList<ExportResource>();
    private final NoteService noteService;
    private final WikiService wikiService;
    private final HTMLUploadImageProcessor htmlUploadImageProcessor;
    private ExecutorService exportThreadPool;

    public NotesExportService(NoteService noteService, WikiService wikiService, HTMLUploadImageProcessor htmlUploadImageProcessor) {
        this.noteService = noteService;
        this.wikiService = wikiService;
        this.htmlUploadImageProcessor = htmlUploadImageProcessor;
    }

    public void start() {
        this.exportThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Notes-Export-File-%d").build());
    }

    public void stop() {
        if (this.exportThreadPool != null) {
            this.exportThreadPool.shutdownNow();
        }
    }

    public static void cleanUp(File file) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            Files.delete(file.toPath());
        }
    }

    public void startExportNotes(int exportId, String[] notesToExportIds, boolean exportAll, Identity identity) throws Exception {
        ExportResource exportResource = new ExportResource();
        exportResource.setExportId(exportId);
        exportResource.setStatus(ExportStatus.STARTED.name());
        exportResource.setAction(new ExportAction());
        exportResourceList.add(exportResource);
        this.exportThreadPool.execute(new ExportThread(this.noteService, this.wikiService, this, this.htmlUploadImageProcessor, new ExportData(exportId, notesToExportIds, exportAll, identity)));
    }

    public void cancelExportNotes(int exportId) {
        ExportResource exportResource = this.getExportRessourceById(exportId);
        if (exportResource != null) {
            exportResource.setStatus(ExportStatus.CANCELLED.name());
        }
    }

    public void removeExportResource(int exportId) {
        ExportResource exportResource = this.getExportRessourceById(exportId);
        if (exportResource != null) {
            exportResourceList.remove(exportResource);
        }
    }

    public byte[] getExportedNotes(int exportId) throws IOException {
        ExportResource exportResource = this.getExportRessourceById(exportId);
        if (exportResource != null) {
            File zipped = exportResource.getZipFile();
            byte[] filesBytes = FileUtils.readFileToByteArray((File)zipped);
            NotesExportService.cleanUp(zipped);
            exportResource.setStatus(ExportStatus.DONE.name());
            exportResourceList.remove(exportResource);
            return filesBytes;
        }
        return null;
    }

    public ExportingStatus getStatus(int exportId) {
        ExportResource exportResource = this.getExportRessourceById(exportId);
        if (exportResource != null) {
            return new ExportingStatus(exportResource.getStatus(), exportResource.getAction(), exportResource.getExportedNotesCount());
        }
        return new ExportingStatus();
    }

    public ExportResource getExportRessourceById(int id) {
        return exportResourceList.stream().filter(resource -> id == resource.getExportId()).findFirst().orElse(null);
    }
}

