/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.util.List;
import java.util.Map;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.plugin.WikiEmotionIconsPlugin;
import org.exoplatform.wiki.plugin.WikiTemplatePagePlugin;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.listener.AttachmentWikiListener;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;

public interface WikiService {
    public Page createPage(Wiki var1, String var2, Page var3) throws WikiException;

    public void createTemplatePage(Wiki var1, Template var2) throws WikiException;

    public boolean deletePage(String var1, String var2, String var3) throws WikiException;

    public void deleteTemplatePage(String var1, String var2, String var3) throws WikiException;

    public boolean renamePage(String var1, String var2, String var3, String var4, String var5) throws WikiException;

    public boolean movePage(WikiPageParams var1, WikiPageParams var2) throws WikiException;

    public List<PermissionEntry> getWikiPermission(String var1, String var2) throws WikiException;

    public void updateWikiPermission(String var1, String var2, List<PermissionEntry> var3) throws WikiException;

    public Page getPageOfWikiByName(String var1, String var2, String var3) throws WikiException;

    public Page getPageByRootPermission(String var1, String var2, String var3) throws WikiException;

    public Page getRelatedPage(String var1, String var2, String var3) throws WikiException;

    public Page getExsitedOrNewDraftPageById(String var1, String var2, String var3) throws WikiException;

    public Page getPageById(String var1) throws WikiException;

    public Page getDraftPageById(String var1) throws WikiException;

    public String getPageRenderedContent(Page var1);

    public void addPageLink(WikiPageParams var1, WikiPageParams var2);

    public Page getParentPageOf(Page var1) throws WikiException;

    public List<Page> getChildrenPageOf(Page var1) throws WikiException;

    public Template getTemplatePage(WikiPageParams var1, String var2) throws WikiException;

    public List<BreadcrumbData> getBreadcumb(String var1, String var2, String var3) throws WikiException;

    public WikiPageParams getWikiPageParams(BreadcrumbData var1) throws WikiException;

    public PageList<SearchResult> search(WikiSearchData var1) throws WikiException;

    public List<TemplateSearchResult> searchTemplate(TemplateSearchData var1) throws WikiException;

    public List<Page> getDuplicatePages(Page var1, Wiki var2, List<Page> var3) throws WikiException;

    public String getDefaultWikiSyntaxId();

    public long getSaveDraftSequenceTime();

    public long getEditPageLivingTime();

    public List<Attachment> getAttachmentsOfPage(Page var1) throws WikiException;

    default public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentsOfPage(page);
    }

    public int getNbOfAttachmentsOfPage(Page var1) throws WikiException;

    public Attachment getAttachmentOfPageByName(String var1, Page var2) throws WikiException;

    default public Attachment getAttachmentOfPageByName(String attachmentName, Page page, boolean loadContent) throws WikiException {
        return this.getAttachmentOfPageByName(attachmentName, page);
    }

    public void addAttachmentToPage(Attachment var1, Page var2) throws WikiException;

    public void deleteAttachmentOfPage(String var1, Page var2) throws WikiException;

    @Deprecated
    public Page getHelpSyntaxPage(String var1, boolean var2) throws WikiException;

    public Map<String, Template> getTemplates(WikiPageParams var1) throws WikiException;

    public void updateTemplate(Template var1) throws WikiException;

    public boolean isExisting(String var1, String var2, String var3) throws WikiException;

    public List<PermissionEntry> getWikiDefaultPermissions(String var1, String var2) throws WikiException;

    public void addComponentPlugin(ComponentPlugin var1);

    public void addWikiTemplatePagePlugin(WikiTemplatePagePlugin var1);

    public void addEmotionIconsPlugin(WikiEmotionIconsPlugin var1);

    public List<PageWikiListener> getPageListeners();

    public List<AttachmentWikiListener> getAttachmentListeners();

    public void addRelatedPage(WikiPageParams var1, WikiPageParams var2) throws WikiException;

    public List<Page> getRelatedPagesOfPage(Page var1) throws WikiException;

    public void removeRelatedPage(WikiPageParams var1, WikiPageParams var2) throws WikiException;

    public DraftPage createDraftForExistPage(DraftPage var1, Page var2, String var3, long var4) throws WikiException;

    public DraftPage createDraftForNewPage(DraftPage var1, Page var2, long var3) throws WikiException;

    public DraftPage getDraftOfPage(Page var1) throws WikiException;

    public DraftPage getDraft(String var1) throws WikiException;

    public void removeDraftOfPage(WikiPageParams var1) throws WikiException;

    public void removeDraft(String var1) throws WikiException;

    public List<DraftPage> getDraftsOfUser(String var1) throws WikiException;

    public boolean isDraftOutDated(DraftPage var1) throws WikiException;

    public DraftPage getLastestDraft() throws WikiException;

    public DiffResult getDraftChanges(DraftPage var1) throws WikiException;

    public Wiki getOrCreateUserWiki(String var1) throws WikiException;

    public String getSpaceNameByGroupId(String var1);

    public List<SpaceBean> searchSpaces(String var1) throws WikiException;

    public Wiki getWikiByTypeAndOwner(String var1, String var2) throws WikiException;

    public List<Wiki> getWikisByType(String var1) throws WikiException;

    public Wiki createWiki(String var1, String var2) throws WikiException;

    public String getWikiWebappUri();

    public boolean hasPermissionOnWiki(Wiki var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasPermissionOnPage(Page var1, PermissionType var2, Identity var3) throws WikiException;

    public boolean hasAdminSpacePermission(String var1, String var2) throws WikiException;

    public boolean hasAdminPagePermission(String var1, String var2) throws WikiException;

    public Wiki getWikiById(String var1) throws WikiException;

    public String getWikiNameById(String var1) throws WikiException;

    public boolean canModifyPagePermission(Page var1, String var2) throws WikiException;

    public boolean canPublicAndRetrictPage(Page var1, String var2) throws WikiException;

    public List<PageVersion> getVersionsOfPage(Page var1) throws WikiException;

    public PageVersion getVersionOfPageByName(String var1, Page var2) throws WikiException;

    public void createVersionOfPage(Page var1) throws WikiException;

    public void restoreVersionOfPage(String var1, Page var2) throws WikiException;

    public void updatePage(Page var1, PageUpdateType var2) throws WikiException;

    public List<String> getPreviousNamesOfPage(Page var1) throws WikiException;

    public void createEmotionIcon(EmotionIcon var1) throws WikiException;

    public List<EmotionIcon> getEmotionIcons() throws WikiException;

    public EmotionIcon getEmotionIconByName(String var1) throws WikiException;

    public List<String> getWatchersOfPage(Page var1) throws WikiException;

    public void addWatcherToPage(String var1, Page var2) throws WikiException;

    public void deleteWatcherOfPage(String var1, Page var2) throws WikiException;

    public int getUploadLimit();

    public List<Page> getPagesOfWiki(String var1, String var2);
}

