/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import io.meeds.notes.legacy.search.es.ElasticSearchServiceConnector;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.utils.Utils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WikiElasticSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(WikiElasticSearchServiceConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private final IdentityManager identityManager;
    private final ConfigurationManager configurationManager;
    private String searchQuery;
    private String searchQueryFilePath;
    public static final String SEARCH_QUERY_TERM = ",\"must\":{\n  \"query_string\":{\n    \"fields\": [\"name\",\"title\",\"content\",\"comment\",\"attachment.content\"],\n    \"default_operator\": \"AND\",\n    \"query\": \"@term@\"\n  }\n}\n";

    public WikiElasticSearchServiceConnector(ConfigurationManager configurationManager, InitParams initParams, ElasticSearchingClient client, IdentityManager identityManager) {
        super(initParams, client);
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    @Override
    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("title");
        fields.add("url");
        fields.add("wikiType");
        fields.add("owner");
        fields.add("wikiOwner");
        fields.add("createdDate");
        fields.add("updatedDate");
        fields.add("name");
        fields.add("pageName");
        fields.add("content");
        ArrayList<CallSite> sourceFields = new ArrayList<CallSite>();
        for (String sourceField : fields) {
            sourceFields.add((CallSite)((Object)("\"" + sourceField + "\"")));
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    public List<SearchResult> searchWiki(String searchedText, String userId, List<String> tagNames, boolean isFavorites, int offset, int limit) {
        return this.filteredWikiSearch(searchedText, userId, tagNames, isFavorites, offset, limit);
    }

    protected List<SearchResult> filteredWikiSearch(String query, String userId, List<String> tagNames, boolean isFavorites, int offset, int limit) {
        Set<String> ids = this.getUserSpaceIds(userId);
        String esQuery = this.buildQueryStatement(ids, userId, tagNames, query, isFavorites, offset, limit);
        String jsonResponse = this.getClient().sendRequest(esQuery, this.getIndex());
        return this.buildWikiResult(jsonResponse);
    }

    private String buildTagsQueryStatement(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        List tagsQueryParts = values.stream().map(value -> "{\"term\": {\n" + "            \"metadatas.tags.metadataName.keyword\": {\n" + "              \"value\": \"" + value + "\",\n" + "              \"case_insensitive\":true\n" + "            }\n" + "          }}").collect(Collectors.toList());
        return ",\"should\": [\n" + org.apache.commons.lang3.StringUtils.join(tagsQueryParts, (String)",") + "      ],\n" + "      \"minimum_should_match\": 1";
    }

    private String buildTermQuery(String termQuery) {
        if (StringUtils.isBlank((String)termQuery)) {
            return "";
        }
        termQuery = this.removeSpecialCharacters(termQuery);
        List<String> termsQuery = Arrays.stream(termQuery.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if (((String)(word = ((String)word).trim())).length() > 5) {
                word = (String)word + "~1";
            }
            return word;
        }).toList();
        return SEARCH_QUERY_TERM.replace("@term@", StringUtils.join(termsQuery, (String)" "));
    }

    private String buildQueryStatement(Set<String> calendarOwnersOfUser, String userId, List<String> tagNames, String term, boolean isFavorites, long offset, long limit) {
        term = this.removeSpecialCharacters(term);
        Map<String, List<String>> metadataFilters = this.buildMetadataFilter(isFavorites, userId);
        String metadataQuery = this.buildMetadataQueryStatement(metadataFilters);
        String tagsQuery = this.buildTagsQueryStatement(tagNames);
        String termsQuery = this.buildTermQuery(term);
        return this.retrieveSearchQuery().replace("@term_query@", termsQuery).replace("@metadatas_query@", metadataQuery).replace("@tags_query@", tagsQuery).replace("@permissions@", StringUtils.join(calendarOwnersOfUser, (String)",")).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replace("'", " ");
        return string;
    }

    protected List<SearchResult> buildWikiResult(String jsonResponse) {
        Map json;
        ArrayList<SearchResult> wikiResults = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            long score = ((Double)((JSONObject)jsonHit).get((Object)"_score")).longValue();
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            String title = (String)hitSource.get((Object)"title");
            String url = (String)hitSource.get((Object)"url");
            String lang = (String)hitSource.get((Object)"lang");
            String wikiType = (String)hitSource.get((Object)"wikiType");
            String wikiOwner = (String)hitSource.get((Object)"wikiOwner");
            String owner = (String)hitSource.get((Object)"owner");
            Calendar createdDate = Calendar.getInstance();
            createdDate.setTimeInMillis(Long.parseLong((String)hitSource.get((Object)"createdDate")));
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(Long.parseLong((String)hitSource.get((Object)"updatedDate")));
            SearchResultType type = SearchResultType.PAGE;
            String pageName = (String)hitSource.get((Object)"name");
            String attachmentName = null;
            JSONObject hitHighlight = (JSONObject)((JSONObject)jsonHit).get((Object)"highlight");
            StringBuilder excerpt = new StringBuilder();
            if (hitHighlight != null) {
                for (String key : hitHighlight.keySet()) {
                    JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                    for (Object highlight : highlights) {
                        excerpt.append("... ").append(highlight);
                    }
                }
            }
            SearchResult wikiSearchResult = new SearchResult();
            wikiSearchResult.setLang(lang);
            wikiSearchResult.setWikiType(wikiType);
            wikiSearchResult.setWikiOwner(wikiOwner);
            wikiSearchResult.setPageName(pageName);
            wikiSearchResult.setAttachmentName(attachmentName);
            String content = Utils.html2text(excerpt.toString());
            wikiSearchResult.setExcerpt(content);
            wikiSearchResult.setTitle(title);
            wikiSearchResult.setType(type);
            wikiSearchResult.setCreatedDate(createdDate);
            wikiSearchResult.setUpdatedDate(updatedDate);
            wikiSearchResult.setUrl(url);
            wikiSearchResult.setScore(score);
            if (wikiOwner != null && wikiOwner.startsWith("spaces/")) {
                String wikiOwnerPrettyName = wikiOwner.split("spaces/")[1];
                Identity wikiOwnerIdentity = this.identityManager.getOrCreateIdentity("space", wikiOwnerPrettyName, true);
                wikiSearchResult.setWikiOwnerIdentity(wikiOwnerIdentity);
            }
            if (owner != null) {
                Identity posterIdentity = this.identityManager.getOrCreateIdentity("organization", owner);
                wikiSearchResult.setPoster(posterIdentity);
            }
            wikiResults.add(wikiSearchResult);
        }
        return wikiResults;
    }

    protected Set<String> getUserSpaceIds(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            throw new IllegalStateException("No Identity found: userId is empty");
        }
        HashSet<String> permissions = new HashSet<String>();
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess userSpaces = spaceService.getMemberSpaces(userId);
        List<Object> spaceList = new ArrayList();
        try {
            spaceList = Arrays.asList((Space[])userSpaces.load(0, userSpaces.getSize()));
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't get user space Ids");
        }
        for (Space space : spaceList) {
            if (space == null) continue;
            permissions.add(identityManager.getOrCreateIdentity("space", space.getPrettyName()).getId());
        }
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userId);
        if (userId != null) {
            permissions.add(userIdentity.getId());
        }
        return permissions;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    private String buildMetadataQueryStatement(Map<String, List<String>> metadataFilters) {
        StringBuilder metadataQuerySB = new StringBuilder();
        Set<Map.Entry<String, List<String>>> metadataFilterEntries = metadataFilters.entrySet();
        for (Map.Entry<String, List<String>> metadataFilterEntry : metadataFilterEntries) {
            metadataQuerySB.append("{\"terms\":{\"metadatas.").append(metadataFilterEntry.getKey()).append(".metadataName.keyword").append("\": [\"").append(StringUtils.join((Collection)metadataFilterEntry.getValue(), (String)"\",\"")).append("\"]}},");
        }
        return metadataQuerySB.toString();
    }

    private Map<String, List<String>> buildMetadataFilter(boolean isFavorites, String userId) {
        Identity viewerIdentity = this.identityManager.getOrCreateIdentity("organization", userId);
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        if (isFavorites) {
            metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(viewerIdentity.getId()));
        }
        return metadataFilters;
    }
}

