/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.junit.Test;

public class DraftPageDAOTest
extends BaseWikiJPAIntegrationTest {
    @Test
    public void testInsert() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setName("name");
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        DraftPageEntity got = (DraftPageEntity)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId()));
        got.getTargetPage().setName("name1");
        this.draftPageDAO.update((Object)got);
        DraftPageDAOTest.assertEquals((String)"name1", (String)page.getName());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
        DraftPageDAOTest.assertNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
    }

    @Test
    public void testFindDraftPagesByUser() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setName("name");
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setAuthor("user1");
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        List user1DraftPages = this.draftPageDAO.findDraftPagesByUser("user1");
        DraftPageDAOTest.assertNotNull((Object)user1DraftPages);
        DraftPageDAOTest.assertEquals((int)1, (int)user1DraftPages.size());
        List user2DraftPages = this.draftPageDAO.findDraftPagesByUser("user2");
        DraftPageDAOTest.assertNotNull((Object)user2DraftPages);
        DraftPageDAOTest.assertEquals((int)0, (int)user2DraftPages.size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindLatestDraftPageByUser() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, 1);
        Date oneYearAgo = calendar.getTime();
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setName("page1");
        page.setWiki(wiki);
        page.setUpdatedDate(oneYearAgo);
        page.setCreatedDate(oneYearAgo);
        this.pageDAO.create((Object)page);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setName("draft1");
        dp1.setTargetPage(page);
        dp1.setAuthor("user1");
        dp1.setUpdatedDate(oneYearAgo);
        dp1.setCreatedDate(oneYearAgo);
        dp1.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setName("draft2");
        dp2.setTargetPage(page);
        dp2.setAuthor("user1");
        dp2.setUpdatedDate(now);
        dp2.setCreatedDate(now);
        dp1.setTargetRevision("2");
        this.draftPageDAO.create((Object)dp2);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp2.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        DraftPageEntity user1DraftPage = this.draftPageDAO.findLatestDraftPageByUser("user1");
        DraftPageDAOTest.assertNotNull((Object)user1DraftPage);
        DraftPageDAOTest.assertEquals((String)"2", (String)user1DraftPage.getTargetRevision());
        DraftPageEntity user2DraftPage = this.draftPageDAO.findLatestDraftPageByUser("user2");
        DraftPageDAOTest.assertNull((Object)user2DraftPage);
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindDraftPagesByUserAndTargetPage() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setAuthor("user1");
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        List drafts1 = this.draftPageDAO.findDraftPagesByUserAndTargetPage("user1", page.getId());
        List drafts2 = this.draftPageDAO.findDraftPagesByUserAndTargetPage("user2", page.getId());
        List drafts3 = this.draftPageDAO.findDraftPagesByUserAndTargetPage("user1", page.getId() + 1L);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        DraftPageDAOTest.assertNotNull((Object)drafts1);
        DraftPageDAOTest.assertEquals((int)1, (int)drafts1.size());
        DraftPageDAOTest.assertNotNull((Object)drafts2);
        DraftPageDAOTest.assertEquals((int)0, (int)drafts2.size());
        DraftPageDAOTest.assertNotNull((Object)drafts3);
        DraftPageDAOTest.assertEquals((int)0, (int)drafts3.size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testDeleteDraftPageByUserAndTargetPage() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, 1);
        Date oneYearAgo = calendar.getTime();
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page1 = new PageEntity();
        page1.setName("page1");
        page1.setWiki(wiki);
        page1.setUpdatedDate(oneYearAgo);
        page1.setCreatedDate(oneYearAgo);
        this.pageDAO.create((Object)page1);
        PageEntity page2 = new PageEntity();
        page2.setName("page2");
        page2.setWiki(wiki);
        page2.setUpdatedDate(now);
        page2.setCreatedDate(now);
        this.pageDAO.create((Object)page2);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setTargetPage(page1);
        dp1.setAuthor("user1");
        dp1.setName("draft1");
        dp1.setUpdatedDate(oneYearAgo);
        dp1.setCreatedDate(oneYearAgo);
        dp1.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setTargetPage(page2);
        dp2.setAuthor("user1");
        dp2.setName("draft2");
        dp2.setUpdatedDate(now);
        dp2.setCreatedDate(now);
        dp2.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp2);
        DraftPageDAOTest.assertEquals((int)2, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByUserAndTargetPage("user1", page1.getId());
        DraftPageDAOTest.assertEquals((int)1, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((String)"draft2", (String)((DraftPageEntity)this.draftPageDAO.findAll().get(0)).getName());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByUserAndTargetPage("user1", page2.getId());
        DraftPageDAOTest.assertEquals((int)0, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testDeleteDraftPageByUserAndName() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, 1);
        Date oneYearAgo = calendar.getTime();
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page1 = new PageEntity();
        page1.setName("page1");
        page1.setWiki(wiki);
        page1.setUpdatedDate(oneYearAgo);
        page1.setCreatedDate(oneYearAgo);
        this.pageDAO.create((Object)page1);
        PageEntity page2 = new PageEntity();
        page2.setName("page2");
        page2.setWiki(wiki);
        page2.setUpdatedDate(now);
        page2.setCreatedDate(now);
        this.pageDAO.create((Object)page2);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setTargetPage(page1);
        dp1.setAuthor("user1");
        dp1.setName("draft1");
        dp1.setUpdatedDate(oneYearAgo);
        dp1.setCreatedDate(oneYearAgo);
        dp1.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setTargetPage(page2);
        dp2.setAuthor("user1");
        dp2.setName("draft2");
        dp2.setUpdatedDate(now);
        dp2.setCreatedDate(now);
        dp2.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp2);
        DraftPageDAOTest.assertEquals((int)2, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByUserAndName("draft1", "user1");
        DraftPageDAOTest.assertEquals((int)1, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((String)"draft2", (String)((DraftPageEntity)this.draftPageDAO.findAll().get(0)).getName());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByUserAndName("draft2", "user1");
        DraftPageDAOTest.assertEquals((int)0, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }
}

