/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;

public class TestPageContent
extends BaseTest {
    private WikiService wikiService;
    private NoteService noteService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wikiService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
    }

    public void testGetPageContent() throws Exception {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, WikiType.PORTAL.toString(), "classic");
        Page page = new Page("AddPageContent-001", "AddPageContent-001");
        page.setSyntax("xhtml/1.0");
        page.setContent("This is a content of page");
        this.noteService.createNote(wiki, wiki.getWikiHome(), page);
        page = this.wikiService.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), "AddPageContent-001");
        TestPageContent.assertNotNull((Object)page);
        TestPageContent.assertEquals((String)"xhtml/1.0", (String)page.getSyntax());
        TestPageContent.assertEquals((String)"This is a content of page", (String)page.getContent());
    }
}

