/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.jpa.JPADataStorage;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.junit.Assert;

public class TestNoteService
extends BaseTest {
    private WikiService wService;
    private NoteService noteService;
    private NotesExportService notesExportService;

    public TestNoteService() {
        this.setForceContainerReload(true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
        this.notesExportService = (NotesExportService)this.getContainer().getComponentInstanceOfType(NotesExportService.class);
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
    }

    public void testGetGroupPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wService, PortalConfig.GROUP_TYPE, "/platform/users");
        Identity root = new Identity("root");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "platform/users", "Home"));
        this.noteService.createNote(wiki, "Home", new Page("testGetGroupPageById-101", "testGetGroupPageById-101"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "platform/users", "testGetGroupPageById-101"));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "unknown", "Home"));
    }

    public void testGetUserPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "john");
        Identity john = new Identity("john");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", "Home"));
        this.noteService.createNote(wiki, "Home", new Page("testGetUserPageById-101", "testGetUserPageById-101"), john);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", "testGetUserPageById-101"));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "unknown", "Home"));
    }

    public void testCreatePageAndSubNote() throws WikiException, IllegalAccessException {
        Wiki wiki = new Wiki(PortalConfig.PORTAL_TYPE, "classic");
        Identity root = new Identity("root");
        this.noteService.createNote(wiki, "Home", new Page("parentPage_", "parentPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "parentPage_", root));
        this.noteService.createNote(wiki, "parentPage_", new Page("childPage_", "childPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "childPage_", root));
    }

    public void testGetBreadcumb() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        this.noteService.createNote(portalWiki, "Home", new Page("Breadcumb1_", "Breadcumb1_"), root);
        this.noteService.createNote(portalWiki, "Breadcumb1_", new Page("Breadcumb2_", "Breadcumb2_"), root);
        this.noteService.createNote(portalWiki, "Breadcumb2_", new Page("Breadcumb3_", "Breadcumb3_"), root);
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", "Breadcumb3_", false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1_", (String)((BreadcrumbData)breadCumbs.get(1)).getId());
        TestNoteService.assertEquals((String)"Breadcumb2_", (String)((BreadcrumbData)breadCumbs.get(2)).getId());
        TestNoteService.assertEquals((String)"Breadcumb3_", (String)((BreadcrumbData)breadCumbs.get(3)).getId());
    }

    public void testGetBreadcumbWithLanguage() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("Breadcumb1", "Breadcumb1"), root);
        Page note2 = this.noteService.createNote(portalWiki, "Breadcumb1", new Page("Breadcumb2", "Breadcumb2"), root);
        Page note3 = this.noteService.createNote(portalWiki, "Breadcumb2", new Page("Breadcumb3", "Breadcumb3"), root);
        note1.setLang("fr");
        note1.setTitle("Breadcumb1_fr");
        this.noteService.createVersionOfNote(note1, "root");
        note2.setLang("fr");
        note2.setTitle("Breadcumb2_fr");
        this.noteService.createVersionOfNote(note2, "root");
        note3.setLang("fr");
        note3.setTitle("Breadcumb3_fr");
        this.noteService.createVersionOfNote(note3, "root");
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", "Breadcumb3", false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
        breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", "Breadcumb3", "fr", root, false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1_fr", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2_fr", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3_fr", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
    }

    public void testMoveNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        this.noteService.createNote(portalWiki, "Home", new Page("oldParent_", "oldParent_"), root);
        this.noteService.createNote(portalWiki, "oldParent_", new Page("child_", "child_"), root);
        this.noteService.createNote(portalWiki, "Home", new Page("newParent_", "newParent_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "oldParent_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "child_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "newParent_"));
        WikiPageParams currentLocationParams = new WikiPageParams();
        WikiPageParams newLocationParams = new WikiPageParams();
        currentLocationParams.setPageName("child_");
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner("classic");
        newLocationParams.setPageName("newParent_");
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner("classic");
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        this.noteService.createNote(userWiki, "Home", new Page("acmePage_", "acmePage_"), root);
        this.noteService.createNote(portalWiki, "Home", new Page("classicPage_", "classicPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", "acmePage_", root));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "classicPage_", root));
        currentLocationParams.setPageName("acmePage_");
        currentLocationParams.setType(PortalConfig.USER_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName("classicPage_");
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner("classic");
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki demoWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "root");
        this.noteService.createNote(demoWiki, "Home", new Page("toMovedPage_", "toMovedPage_"), root);
        Page page = this.noteService.createNote(userWiki, "Home", new Page("privatePage_", "privatePage_"), root);
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        permissionMap.put("any", new String[]{PermissionType.VIEWPAGE.toString(), PermissionType.EDITPAGE.toString()});
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        PermissionEntry permissionEntry = new PermissionEntry(IdentityConstants.ANY.toString(), "", IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)});
        permissionEntries.add(permissionEntry);
        page.setPermissions(permissionEntries);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "root", "toMovedPage_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", "privatePage_"));
        currentLocationParams.setPageName("toMovedPage_");
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName("privatePage_");
        newLocationParams.setType(PortalConfig.USER_TYPE);
        newLocationParams.setOwner("root");
    }

    public void testDeleteNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", "deletePage_"));
        this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", "deletePage_"));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "deletePage_"));
        TestNoteService.assertFalse((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", "Home"));
    }

    public void testRenameNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.renameNote(PortalConfig.PORTAL_TYPE, "classic", "currentPage_", "renamedPage_", "renamedPage_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "renamedPage_"));
    }

    public void testRenamePageToExistingNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        this.noteService.createNote(portalWiki, "Home", new Page("currentPage2_", "currentPage2_"), root);
        try {
            this.noteService.renameNote(PortalConfig.PORTAL_TYPE, "classic", "currentPage_", "currentPage2_", "renamedPage2_");
            TestNoteService.fail((String)"Renaming page currentPage to the existing page currentPage2_ should throw an exception");
        }
        catch (WikiException e) {
            TestNoteService.assertEquals((String)"Note portal:classic:currentPage2_ already exists, cannot rename it.", (String)e.getMessage());
        }
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "currentPage_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "currentPage2_"));
    }

    public void testHasPermisionOnSystemPage() throws WikiException, IllegalAccessException, ObjectAlreadyExistsException {
        JPADataStorage storage = (JPADataStorage)this.getContainer().getComponentInstanceOfType(JPADataStorage.class);
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("testHasPermisionOnSystemPage");
        wiki = storage.createWiki(wiki);
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity adminAclIdentity = new Identity("admin", Arrays.asList(new MembershipEntry("/platform/users", "*"), new MembershipEntry("/platform/administrators", "*")));
        identityRegistry.register(adminAclIdentity);
        Identity userAclIdentity = new Identity("user", Arrays.asList(new MembershipEntry("/platform/users", "*")));
        identityRegistry.register(userAclIdentity);
        Page noPermissionPage = new Page();
        noPermissionPage.setWikiId(wiki.getId());
        noPermissionPage.setWikiType(wiki.getType());
        noPermissionPage.setWikiOwner(wiki.getOwner());
        noPermissionPage.setName("page1");
        noPermissionPage.setTitle("Page 1");
        noPermissionPage.setPermissions(new ArrayList());
        noPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), noPermissionPage);
        Page systemPermissionPage = new Page();
        systemPermissionPage.setWikiId(wiki.getId());
        systemPermissionPage.setWikiType(wiki.getType());
        systemPermissionPage.setWikiOwner(wiki.getOwner());
        systemPermissionPage.setName("page1");
        systemPermissionPage.setTitle("Page 1");
        systemPermissionPage.setOwner(IdentityConstants.SYSTEM);
        systemPermissionPage.setPermissions(new ArrayList());
        Page storedSystemPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), systemPermissionPage);
        TestNoteService.assertTrue((boolean)this.noteService.hasPermissionOnPage(noPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertFalse((boolean)this.noteService.hasPermissionOnPage(storedSystemPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteById(storedSystemPermissionPage.getId(), adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.noteService.getNoteById(storedSystemPermissionPage.getId(), userAclIdentity));
    }

    public void testUpdateNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic").getWikiHome();
        Page page = new Page("new page_", "new page_");
        page.setContent("Page content");
        page = this.noteService.createNote(new Wiki(PortalConfig.PORTAL_TYPE, "classic"), "Home", page, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content", (String)page.getContent());
        TestNoteService.assertEquals((String)"new page_", (String)page.getTitle());
        page.setContent("Page content updated_");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content updated_", (String)page.getContent());
        page.setTitle("new page updated_");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"new page updated_", (String)page.getTitle());
    }

    public void testDraftPage() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        DraftPage draftOfNewPage = new DraftPage();
        draftOfNewPage.setTitle("Draft page");
        draftOfNewPage.setContent("Draft page content");
        long now = new Date().getTime();
        draftOfNewPage = this.noteService.createDraftForNewPage(new DraftPage(), now);
        TestNoteService.assertNotNull((Object)draftOfNewPage);
        String draftNameForNewPage = draftOfNewPage.getName();
        TestNoteService.assertTrue((boolean)draftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)draftOfNewPage.isDraftPage());
        TestNoteService.assertEquals((String)("Untitled_" + this.getDraftNameSuffix(now)), (String)draftNameForNewPage);
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage", "TestPage"), root);
        WikiPageParams param = new WikiPageParams(PortalConfig.PORTAL_TYPE, "classic", targetPage.getName());
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        draftOfNewPage.setTitle("Draft page updated");
        draftOfNewPage.setContent("Draft page content updated");
        DraftPage updatedDraftOfNewPage = this.noteService.updateDraftForNewPage(draftOfNewPage, now);
        TestNoteService.assertNotNull((Object)updatedDraftOfNewPage);
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getTitle(), (String)draftOfNewPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getContent(), (String)draftOfNewPage.getContent());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isDraftPage());
        draftOfExistingPage.setTitle("Draft of page");
        draftOfExistingPage.setContent("Draft of page updated");
        DraftPage updatedDraftOfExistingPage = this.noteService.updateDraftForExistPage(draftOfExistingPage, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)updatedDraftOfExistingPage);
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getTitle(), (String)draftOfExistingPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getContent(), (String)draftOfExistingPage.getContent());
        TestNoteService.assertFalse((boolean)updatedDraftOfExistingPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfExistingPage.isDraftPage());
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    public void testGEtNoteById() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("exported1", "exported1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", "exported1"));
        Page note = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetNoteByIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage", "testPage"), root);
        note1.setLang("en");
        this.noteService.createVersionOfNote(note1, "root");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", "testPage"));
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetPageAvailableTranslationLanguages() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLang", "testLang"), root);
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("en");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("fr");
        this.noteService.createVersionOfNote(note, "root");
        List langs = this.noteService.getPageAvailableTranslationLanguages(Long.valueOf(note.getId()), "root", false);
        TestNoteService.assertNotNull((Object)langs);
        TestNoteService.assertEquals((int)3, (int)langs.size());
    }

    public void testGetVersionsHistoryOfNoteByLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testVersionHistory", "testVersionHistory"), root);
        List pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", null);
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "ar");
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNotNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        TestNoteService.assertEquals((String)"ar", (String)((PageHistory)pageHistories.get(0)).getLang());
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "en");
        TestNoteService.assertEquals((int)0, (int)pageHistories.size());
    }

    public void testGetLatestDraftPageByUserAndTargetPageAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLatestDraft", "testLatestDraft"), root);
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test draft");
        draftPage.setContent(note.getContent());
        draftPage.setName("test draft");
        draftPage.setTargetPageId(note.getId());
        this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        DraftPage latestDraft = this.noteService.getLatestDraftPageByUserAndTargetPageAndLang(Long.valueOf(note.getId()), "root", null);
        TestNoteService.assertNotNull((Object)latestDraft);
    }

    public void testGetNoteOfNoteBookByName() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("test1", "test1"), root);
        TestNoteService.assertNotNull((Object)note1);
    }

    public void testExportNotes() throws Exception {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "exportPortal");
        Page page1 = new Page("exported1", "exported1");
        page1.setContent("<figure class=\"image\"><img src=\"/portal/rest/wiki/attachments/group/space//spaces/base_de_connaissances/page/4.01-_Profil_et_param\u00e8tres/Navigation param\u00e8tres.png\"></figure>");
        Page note1 = this.noteService.createNote(portalWiki, "Home", page1, root);
        Page page2 = new Page("exported2", "exported2");
        page2.setContent("<a class=\"noteLink\" href=\"exported1\" target=\"_blank\">R\u00e8gles de r\u00e9daction des tutoriels </a>");
        Page note2 = this.noteService.createNote(portalWiki, "Home", page2, root);
        Page page3 = new Page("exported3", "exported3");
        page3.setContent("<a class=\"noteLink\" href=\"" + note2.getId() + "\">Home</a>");
        Page note3 = this.noteService.createNote(portalWiki, "Home", page3, root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", "exported1"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", "exported2"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", "exported3"));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        this.notesExportService.startExportNotes(200231, notes, true, root);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
    }

    public void testImportNotes() throws Exception {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "importPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), user);
        Page note2 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), user);
        Page note3 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", "to_be_imported1"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", "to_be_imported2"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", "to_be_imported3"));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        File zipFile = File.createTempFile("notesExport", ".zip");
        this.notesExportService.startExportNotes(200231, notes, true, user);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
        FileUtils.writeByteArrayToFile((File)zipFile, (byte[])exportedNotes);
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        int childern = this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), "root", false, false).size();
        this.noteService.importNotes(zipFile.getPath(), userWiki.getWikiHome(), "update", user);
        TestNoteService.assertTrue((boolean)zipFile.delete());
        TestNoteService.assertEquals((int)this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), "root", false, false).size(), (int)(childern + 3));
    }

    public void testGetNotesOfWiki() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal1");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), user);
        Page note2 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), user);
        Page note3 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", "to_be_imported1"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", "to_be_imported2"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", "to_be_imported3"));
        List pages = this.noteService.getNotesOfWiki(portalWiki.getType(), portalWiki.getOwner());
        TestNoteService.assertEquals((int)pages.size(), (int)4);
    }

    public void testDeleteNote1() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal2");
        this.noteService.createNote(portalWiki, "Home", new Page("note1", "note1"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal2", "note1"));
        this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "testPortal2", "note1", user);
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal2", "note1"));
    }

    public void testDeleteVersionsByNoteIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage1", "testPage1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", "testPage1"));
        note1 = this.noteService.getNoteById(note1.getId());
        note1.setLang("en");
        note1.setTitle("englishTitle");
        this.noteService.createVersionOfNote(note1, "root");
        note1.setLang("fr");
        note1.setTitle("frenchTitle");
        this.noteService.createVersionOfNote(note1, "root");
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note1.getId()), "root", "en");
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getTitle(), (String)"frenchTitle");
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note.getId()), "root", "fr");
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        this.noteService.deleteNote(note1.getWikiType(), note1.getWikiOwner(), note1.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetChildrenNoteOf() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "importPortal");
        this.noteService.createNote(portalWiki, "Home", new Page("imported1", "imported1"), user);
        this.noteService.createNote(portalWiki, "Home", new Page("imported2", "imported2"), user);
        Page home = portalWiki.getWikiHome();
        int childern = this.noteService.getChildrenNoteOf(home, user.getUserId(), false, false).size();
        NoteToExport note = new NoteToExport();
        note.setId(home.getId());
        note.setName(home.getName());
        note.setTitle(home.getTitle());
        note.setWikiId(home.getWikiId());
        note.setWikiOwner(home.getWikiOwner());
        note.setWikiType(home.getWikiType());
        int eXportCildren = this.noteService.getChildrenNoteOf(note, user.getUserId()).size();
        TestNoteService.assertEquals((int)eXportCildren, (int)childern);
    }

    public void testRemoveDraftOfNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        this.startSessionAs("root");
        long now = new Date().getTime();
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage1", "TestPage1"), root);
        WikiPageParams param = new WikiPageParams(PortalConfig.PORTAL_TYPE, "classic", targetPage.getName());
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        draftPageTosave.setLang("fr");
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        DraftPage draft = this.noteService.getLatestDraftOfPage(targetPage, root.getUserId());
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        WikiPageParams noteParams = new WikiPageParams(targetPage.getWikiType(), targetPage.getWikiOwner(), targetPage.getName());
        this.noteService.removeDraftOfNote(noteParams, "en");
        draft = this.noteService.getLatestDraftOfPage(targetPage, root.getUserId());
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        this.noteService.removeDraftOfNote(noteParams, "fr");
        draft = this.noteService.getLatestDraftOfPage(targetPage, root.getUserId());
        TestNoteService.assertNull((Object)draft);
    }

    public void testGetNoteOfNoteBookByNameWithLangMetadata() throws WikiException, IllegalAccessException {
        Identity user = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNoteLangMetadata", "testNoteLangMetadata"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(note.getWikiType(), note.getWikiOwner(), note.getName(), "en", user));
    }

    public void testGetPublishedVersionByPageIdAndLang() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNotee", "testNotee"), user);
        TestNoteService.assertNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
        note.setLang("en");
        note.setTitle("english title");
        note.setContent("english content");
        this.noteService.createVersionOfNote(note, user.getUserId());
        TestNoteService.assertNotNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
    }
}

