/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.bean;

import java.util.Date;
import org.exoplatform.wiki.utils.Utils;

public class DraftBean {
    public static final String ID = "id";
    public static final String PAGE_TITLE = "pageTitle";
    public static final String PLACE = "place";
    public static final String LAST_EDITION = "lastEdition";
    private String id;
    private String pageTitle;
    private String place;
    private Date lastEdition;

    public DraftBean(String id, String pageTitle, String place, Date lastEdition) {
        this.id = id;
        this.pageTitle = pageTitle;
        this.place = place;
        this.lastEdition = lastEdition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getLastEdition() {
        return this.getEditTimeInString(this.lastEdition);
    }

    public Date getLastEditionInDate() {
        return this.lastEdition;
    }

    public void setLastEdition(Date lastEdition) {
        this.lastEdition = lastEdition;
    }

    private String getEditTimeInString(Date date) {
        if (date == null) {
            return null;
        }
        long asecond = 1000L;
        long aminute = asecond * 60L;
        long ahour = aminute * 60L;
        long aday = ahour * 24L;
        long timeDistance = System.currentTimeMillis() - date.getTime();
        long days = timeDistance / aday;
        if (days > 0L) {
            return this.appendTime(Utils.getWikiResourceBundle((String)"DraftPage.label.day-ago", (ClassLoader)this.getClass().getClassLoader()), days);
        }
        long hours = timeDistance / ahour;
        if (hours > 0L) {
            return this.appendTime(Utils.getWikiResourceBundle((String)"DraftPage.label.hour-ago", (ClassLoader)this.getClass().getClassLoader()), hours);
        }
        long minutes = timeDistance / aminute;
        if (minutes > 0L) {
            return this.appendTime(Utils.getWikiResourceBundle((String)"DraftPage.label.minute-ago", (ClassLoader)this.getClass().getClassLoader()), minutes);
        }
        long seconds = timeDistance / asecond;
        if (seconds > 0L) {
            return this.appendTime(Utils.getWikiResourceBundle((String)"DraftPage.label.second-ago", (ClassLoader)this.getClass().getClassLoader()), seconds);
        }
        return this.appendTime(Utils.getWikiResourceBundle((String)"DraftPage.label.miliseconds-ago", (ClassLoader)this.getClass().getClassLoader()), timeDistance);
    }

    private String appendTime(String message, long time) {
        return message.replace("{0}", String.valueOf(time));
    }
}

