/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.RestoreRevisionActionComponent;
import org.exoplatform.wiki.webui.control.action.ShowHistoryActionListener;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiVersionSelect.gtmpl", events={@EventConfig(listeners={CompareRevisionActionListener.class}), @EventConfig(listeners={ShowHistoryActionListener.class}), @EventConfig(listeners={NextVersionActionListener.class}), @EventConfig(listeners={PreviousVersionActionListener.class})})
public class UIWikiVersionSelect
extends UIWikiContainer {
    private String versionName;
    public static final String VIEW_CURRENT_VERSION = "ViewCurrentVersion";
    public static final String COMPARE_ACTION = "CompareRevision";
    public static final String RESTORE_ACTION = "Restore";
    public static final String SHOW_HISTORY = "ShowHistory";
    public static final String NEXT_VERSION = "NextVersion";
    public static final String PREVIOUS_VERSION = "PreviousVersion";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String EXTENSION_TYPE = "org.exoplatform.wiki.webui.UIWikiVersionSelect";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiVersionSelect() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.VIEWREVISION);
        this.addChild(RestoreRevisionActionComponent.class, null, null);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    protected boolean isHasPreviousVersion() {
        int version = Integer.valueOf(this.versionName);
        return version > 1;
    }

    protected boolean hasNextVersion() throws Exception {
        int currentVersion;
        Page wikipage = Utils.getCurrentWikiPage();
        List versions = this.wikiService.getVersionsOfPage(wikipage);
        int nbOfVersions = 0;
        if (versions != null) {
            nbOfVersions = versions.size();
        }
        return (currentVersion = Integer.valueOf(this.versionName).intValue()) < nbOfVersions;
    }

    protected boolean renderRestoreRevisionActions() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        RestoreRevisionActionComponent component = (RestoreRevisionActionComponent)this.getChild(RestoreRevisionActionComponent.class);
        component.setVersionName(this.versionName);
        component.setCurrentVersion(!this.hasNextVersion());
        component.setLabel(bundle.getString("UIWikiVersionSelect.label.RestoreThisVersion"));
        component.setTooltip(bundle.getString("UIWikiVersionSelect.label.RestoreThisVersion"));
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        if (manager.accept(EXTENSION_TYPE, "RestoreRevision", null)) {
            this.renderChild(RestoreRevisionActionComponent.class);
            return true;
        }
        return false;
    }

    public static class PreviousVersionActionListener
    extends EventListener<UIWikiVersionSelect> {
        public void execute(Event<UIWikiVersionSelect> event) throws Exception {
            UIWikiVersionSelect versionSelect = (UIWikiVersionSelect)((Object)event.getSource());
            int version = Integer.valueOf(versionSelect.versionName);
            versionSelect.versionName = String.valueOf(--version);
        }
    }

    public static class NextVersionActionListener
    extends EventListener<UIWikiVersionSelect> {
        public void execute(Event<UIWikiVersionSelect> event) throws Exception {
            UIWikiVersionSelect versionSelect = (UIWikiVersionSelect)((Object)event.getSource());
            int version = Integer.valueOf(versionSelect.versionName);
            versionSelect.versionName = String.valueOf(++version);
        }
    }

    public static class CompareRevisionActionListener
    extends org.exoplatform.wiki.webui.control.action.CompareRevisionActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            UIWikiVersionSelect versionSelect = (UIWikiVersionSelect)((Object)event.getSource());
            List versionsList = wikiService.getVersionsOfPage(Utils.getCurrentWikiPage());
            this.setVersionToCompare(versionsList);
            this.setTo(0);
            for (int i = 0; i < versionsList.size(); ++i) {
                if (!((PageVersion)versionsList.get(i)).getName().equals(versionSelect.versionName)) continue;
                this.setFrom(i);
                break;
            }
            super.execute(event);
        }
    }
}

