/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.nps.entity.ScoreEntryEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreEntryDAO
extends GenericDAOJPAImpl<ScoreEntryEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ScoreEntryDAO.class);

    public List<ScoreEntryEntity> getScoreEntries(long typeId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByDesc", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("typeId", (Object)typeId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByDesc", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getFirstScoreEntries(long typeId) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByAsc", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get first scores", (Throwable)e);
            throw e;
        }
    }

    public long getScoreEntriesCount(long typeId, boolean enabled) {
        try {
            if (enabled) {
                return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabled", Long.class).setParameter("typeId", (Object)typeId).getSingleResult();
            }
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.count", Long.class).setParameter("typeId", (Object)typeId).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getPromotersCount(long typeId) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countPromoters", Long.class).setParameter("typeId", (Object)typeId).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getDetractorsCount(long typeId) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countDetractors", Long.class).setParameter("typeId", (Object)typeId).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getScoreEntriesCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getPromotersCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countPromotersByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getDetractorsCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countDetractorsByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntriesByUserId(long typeId, String userId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("typeId", (Object)typeId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setParameter("userId", (Object)userId).setParameter("typeId", (Object)typeId).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntrybyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findById", ScoreEntryEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

