/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.nps.dao.ScoreTypeDAO;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.entity.ScoreTypeEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NpsTypeService {
    private final Log LOG = ExoLogger.getLogger(NpsTypeService.class);
    private ScoreTypeDAO scoreTypeDAO = new ScoreTypeDAO();

    public Boolean save(ScoreTypeDTO entity, boolean newType) {
        try {
            if (entity == null) {
                throw new IllegalStateException("Parameter 'entity' is null");
            }
            if (newType) {
                this.scoreTypeDAO.create(this.convert(entity));
            } else {
                this.scoreTypeDAO.update(this.convert(entity));
            }
        }
        catch (IllegalStateException e) {
            this.LOG.error("Cannot save the score", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    public void remove(ScoreTypeDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.scoreTypeDAO.delete(this.convert(entity));
    }

    public List<ScoreTypeDTO> getScoreTypes(int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getScores - Parameter 'offset' must be positive");
        }
        List<ScoreTypeEntity> entities = this.scoreTypeDAO.getScoreTypes(offset, limit);
        ArrayList<ScoreTypeDTO> dtos = new ArrayList<ScoreTypeDTO>();
        for (ScoreTypeEntity entity : entities) {
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public ScoreTypeDTO getScoreType(long id) {
        List<ScoreTypeEntity> entities = this.scoreTypeDAO.getScoreTypebyId(id);
        if (entities.size() != 0) {
            return this.convert(entities.get(0));
        }
        return null;
    }

    public long getScoreTypeCount() {
        return this.scoreTypeDAO.getScoreTypesCount();
    }

    private ScoreTypeEntity convert(ScoreTypeDTO dto) {
        ScoreTypeEntity entity = new ScoreTypeEntity();
        entity.setId(dto.getId());
        entity.setTypeName(dto.getTypeName());
        entity.setQuestion(dto.getQuestion());
        entity.setIsDefault(dto.getIsDefault());
        entity.setFollowUpPassive(dto.getFollowUpPassive());
        entity.setFollowUpPromoter(dto.getFollowUpPromoter());
        entity.setFollowUpDetractor(dto.getFollowUpDetractor());
        entity.setAnonymous(dto.getAnonymous());
        entity.setLinkedToSpace(dto.getLinkedToSpace());
        entity.setSpaceId(dto.getSpaceId());
        entity.setUserId(dto.getUserId());
        return entity;
    }

    private ScoreTypeDTO convert(ScoreTypeEntity entity) {
        ScoreTypeDTO dto = new ScoreTypeDTO();
        dto.setId(entity.getId());
        dto.setTypeName(entity.getTypeName());
        dto.setQuestion(entity.getQuestion());
        dto.setIsDefault(entity.getIsDefault());
        dto.setFollowUpPassive(entity.getFollowUpPassive());
        dto.setFollowUpPromoter(entity.getFollowUpPromoter());
        dto.setFollowUpDetractor(entity.getFollowUpDetractor());
        dto.setAnonymous(entity.getAnonymous());
        dto.setLinkedToSpace(entity.getLinkedToSpace());
        dto.setSpaceId(entity.getSpaceId());
        dto.setUserId(entity.getUserId());
        return dto;
    }
}

