/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.nps.dao.ScoreEntryDAO;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.entity.ScoreEntryEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NpsService {
    private final Log LOG = ExoLogger.getLogger(NpsService.class);
    private ScoreEntryDAO scoreEntryDAO = new ScoreEntryDAO();

    public Boolean save(ScoreEntryDTO entity, boolean newEntry) {
        try {
            if (entity == null) {
                throw new IllegalStateException("Parameter 'entity' is null");
            }
            Object scoreEntryEntity = null;
            if (newEntry) {
                entity.setPostedTime(System.currentTimeMillis());
                this.scoreEntryDAO.create(this.convert(entity));
            } else {
                this.scoreEntryDAO.update(this.convert(entity));
            }
        }
        catch (IllegalStateException e) {
            this.LOG.error("Cannot save the score", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    public void remove(ScoreEntryDTO entity) {
        if (entity == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        this.scoreEntryDAO.delete(this.convert(entity));
    }

    public List<ScoreEntryDTO> getScores(long typeId, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getScores - Parameter 'offset' must be positive");
        }
        List<ScoreEntryEntity> entities = this.scoreEntryDAO.getScoreEntries(typeId, offset, limit);
        ArrayList<ScoreEntryDTO> dtos = new ArrayList<ScoreEntryDTO>();
        for (ScoreEntryEntity entity : entities) {
            if (entity.getEnabled() == null) {
                entity.setEnabled(true);
            }
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public ScoreEntryDTO getFirstScoreEntries(long typeId) {
        List<ScoreEntryEntity> entities = this.scoreEntryDAO.getFirstScoreEntries(typeId);
        if (entities.size() > 0) {
            return this.convert(entities.get(0));
        }
        return null;
    }

    public ScoreEntryDTO getScoreEntry(long id) {
        List<ScoreEntryEntity> entities = this.scoreEntryDAO.getScoreEntrybyId(id);
        if (entities.size() != 0) {
            return this.convert(entities.get(0));
        }
        return null;
    }

    public List<ScoreEntryDTO> getScoreEntriesByUserId(long typeId, String userId, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("Method getScoreEntriesByUserId - Parameter 'offset' must be positive");
        }
        List<ScoreEntryEntity> entities = this.scoreEntryDAO.getScoreEntriesByUserId(typeId, userId, offset, limit);
        ArrayList<ScoreEntryDTO> dtos = new ArrayList<ScoreEntryDTO>();
        for (ScoreEntryEntity entity : entities) {
            if (entity.getEnabled() == null) {
                entity.setEnabled(true);
            }
            dtos.add(this.convert(entity));
        }
        return dtos;
    }

    public long getPromotersCount(long typeId) {
        return this.scoreEntryDAO.getPromotersCount(typeId);
    }

    public long getDetractorsCount(long typeId) {
        return this.scoreEntryDAO.getDetractorsCount(typeId);
    }

    public long getScoreCount(long typeId, boolean enabled) {
        return this.scoreEntryDAO.getScoreEntriesCount(typeId, enabled);
    }

    public long getPromotersCountByDate(long typeId, long toDate) {
        return this.scoreEntryDAO.getPromotersCountByDate(typeId, toDate);
    }

    public long getDetractorsCountByDate(long typeId, long toDate) {
        return this.scoreEntryDAO.getDetractorsCountByDate(typeId, toDate);
    }

    public long getScoreCountByDate(long typeId, long toDate) {
        return this.scoreEntryDAO.getScoreEntriesCountByDate(typeId, toDate);
    }

    public long getPromotersCountByPeriod(long typeId, long fromDate, long toDate) {
        return this.scoreEntryDAO.getPromotersCountByPeriod(typeId, fromDate, toDate);
    }

    public long getDetractorsCountByPeriod(long typeId, long fromDate, long toDate) {
        return this.scoreEntryDAO.getDetractorsCountByPeriod(typeId, fromDate, toDate);
    }

    public long getScoreCountByPeriod(long typeId, long fromDate, long toDate) {
        return this.scoreEntryDAO.getScoreEntriesCountByPeriod(typeId, fromDate, toDate);
    }

    private ScoreEntryEntity convert(ScoreEntryDTO dto) {
        ScoreEntryEntity entity = new ScoreEntryEntity();
        entity.setId(dto.getId());
        entity.setUserId(dto.getUserId());
        entity.setScore(dto.getScore());
        entity.setPostedTime(dto.getPostedTime());
        entity.setComment(dto.getComment());
        entity.setLastAppereance(dto.getLastAppereance());
        entity.setEnabled(dto.getEnabled());
        entity.setTypeId(dto.getTypeId());
        return entity;
    }

    private ScoreEntryDTO convert(ScoreEntryEntity entity) {
        ScoreEntryDTO dto = new ScoreEntryDTO();
        dto.setId(entity.getId());
        dto.setUserId(entity.getUserId());
        dto.setScore(entity.getScore());
        dto.setPostedTime(entity.getPostedTime());
        dto.setComment(entity.getComment());
        dto.setLastAppereance(entity.getLastAppereance());
        dto.setEnabled(entity.getEnabled());
        dto.setTypeId(entity.getTypeId());
        return dto;
    }
}

