/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MODApplet
extends Applet {
    public static String DIALOG_TITLE = "IT Hit Ajax File Browser";
    public static String NEW_LINE = System.getProperty("line.separator");

    @Override
    public void init() {
        System.out.println("Init applet");
        String string = this.getParameter("file");
        String string2 = this.getParameter("folder");
        String string3 = this.getParameter("mountUrl");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            this.showFailDialog(exception);
        }
        this.open(string3, string, string2);
    }

    public void open(String string, final String string2, final String string3) {
        try {
            final FileSystemOperations fileSystemOperations = this.getFileSystemMouner(string, string2, string3);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MODApplet.this.validate(string2, string3);
                    if (string2 == null) {
                        fileSystemOperations.OpenFolder(new URL(string3));
                    } else if (MODApplet.this.isOpenConfirmed(string2)) {
                        fileSystemOperations.OpenDocument(new URL(string2));
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.showFailDialog(exception);
        }
    }

    private FileSystemOperations getFileSystemMouner(String string, String string2, String string3) throws Exception {
        if (string == null) {
            throw new Exception("'mountUrl' parameter is missing.");
        }
        URL uRL = null;
        if (!string.toLowerCase().startsWith("http")) {
            URL uRL2 = new URL(string2 != null ? string2 : string3);
            uRL = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string);
        } else {
            uRL = new URL(string);
        }
        return FileSystemOperations.Create(uRL);
    }

    private boolean isOpenConfirmed(String string) {
        int n = JOptionPane.showConfirmDialog(null, "Some files can harm your computer. If the file information looks" + NEW_LINE + "suspicious or you do not fully trust the source, do not open the file." + NEW_LINE + NEW_LINE + "You are opening the following file:" + NEW_LINE + NEW_LINE + "Address: " + string + NEW_LINE, "File Download", 2, 3);
        return n == 0;
    }

    private void validate(String string, String string2) {
        if (string == null && string2 == null) {
            throw new RuntimeException("'file' or 'folder' parameter is missing.");
        }
    }

    private void showFailDialog(Exception exception) {
        JOptionPane.showMessageDialog(this, exception.toString(), DIALOG_TITLE, 0);
    }

    private String getFilenameFromPath(String string) {
        if (string == null) {
            throw new RuntimeException("Path can't be empty");
        }
        return new File(string).getName();
    }
}

