/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.jcr;

import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.HierarchyNode;
import org.exoplatform.outlook.jcr.LinkResource;
import org.exoplatform.outlook.jcr.NodeContent;
import org.exoplatform.outlook.jcr.NodeFinder;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public class ContentLink {
    public static final String CONFIG_HOST = "server-host";
    public static final String CONFIG_SCHEMA = "server-schema";
    public static final String LINK_CACHE_NAME = "OutlookContentLinkCache";
    public static final int KEY_EXPIRE_SECONDS = 60;
    protected static final Log LOG = ExoLogger.getLogger(ContentLink.class);
    protected static final Random RANDOM = new Random();
    private final ExoCache<String, KeyPath> activeLinks;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeFinder finder;
    protected final OrganizationService organization;
    protected final IdentityRegistry identityRegistry;
    protected final Map<String, String> config;
    protected final String restUrl;

    public ContentLink(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, OrganizationService organization, IdentityRegistry identityRegistry, CacheService cacheService, InitParams params) throws ConfigurationException {
        String host;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.organization = organization;
        this.identityRegistry = identityRegistry;
        this.activeLinks = cacheService.getCacheInstance(LINK_CACHE_NAME);
        if (params != null) {
            PropertiesParam param = params.getPropertiesParam("link-configuration");
            if (param != null) {
                this.config = Collections.unmodifiableMap(param.getProperties());
            } else {
                LOG.warn((Object)"Property parameters link-configuration not found will use default settings.");
                this.config = Collections.emptyMap();
            }
        } else {
            LOG.warn((Object)"Component configuration not found will use default settings.");
            this.config = Collections.emptyMap();
        }
        String schema = this.config.get(CONFIG_SCHEMA);
        if (schema == null || (schema = schema.trim()).length() == 0) {
            schema = "http";
        }
        if ((host = this.config.get(CONFIG_HOST)) == null || host.trim().length() == 0) {
            host = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (host == null && interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (host == null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress()) continue;
                        host = address.getHostName();
                    }
                }
            }
            catch (SocketException interfaces) {
                // empty catch block
            }
            if (host == null) {
                try {
                    host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
            }
            LOG.warn((Object)("Configuration of server-host is not set, will use " + host));
        }
        StringBuilder restUrl = new StringBuilder();
        restUrl.append(schema);
        restUrl.append("://");
        restUrl.append(host);
        restUrl.append('/');
        restUrl.append(PortalContainer.getCurrentPortalContainerName());
        restUrl.append('/');
        restUrl.append(PortalContainer.getCurrentRestContextName());
        this.restUrl = restUrl.toString();
    }

    public ContentLink(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, OrganizationService organization, IdentityRegistry identityRegistry, CacheService cacheService) throws ConfigurationException {
        this(jcrService, sessionProviders, finder, organization, identityRegistry, cacheService, null);
    }

    public String create(String userId, String workspace, String nodePath) throws Exception {
        Node node = this.node(userId, workspace, nodePath);
        return this.create(userId, node);
    }

    public String create(String userId, Node node) throws RepositoryException {
        String workspace = node.getSession().getWorkspace().getName();
        String path = node.getPath();
        KeyPath keyPath = new KeyPath(userId, workspace, path);
        UUID uuid = this.generateId(workspace, path);
        String key = uuid.toString();
        this.activeLinks.put((Serializable)((Object)key), (Object)keyPath);
        return key;
    }

    public LinkResource createUrl(String userId, String nodePath, String serverLink) throws Exception {
        Node node = this.getNode(userId, nodePath);
        return this.createUrl(userId, node, serverLink);
    }

    public LinkResource createUrl(String userId, Node node, String serverLink) throws RepositoryException {
        String key = this.create(userId, node);
        StringBuilder link = new StringBuilder();
        if (serverLink != null) {
            link.append(serverLink);
            link.append('/');
            link.append(PortalContainer.getCurrentPortalContainerName());
            link.append('/');
            link.append(PortalContainer.getCurrentRestContextName());
        } else {
            link.append(this.restUrl);
        }
        link.append("/outlook/content");
        String name = node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
        if (name.indexOf(46) < 0) {
            try {
                String mimetype = node.isNodeType("nt:file") ? node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : DMSMimeTypeResolver.getInstance().getMimeType(name);
                String ext = DMSMimeTypeResolver.getInstance().getExtension(mimetype);
                StringBuilder nameExt = new StringBuilder(name);
                nameExt.append('.');
                nameExt.append(ext);
                name = nameExt.toString();
            }
            catch (Exception e) {
                LOG.warn((Object)("Error getting file extension by mimetype for " + node), (Throwable)e);
            }
        }
        return new LinkResource(name, link.append('/').append(userId).append('/').append(key).toString());
    }

    public NodeContent consume(String userId, String key) throws Exception {
        KeyPath keyPath = (KeyPath)this.activeLinks.remove((Serializable)((Object)key));
        if (keyPath != null) {
            if (keyPath.userId.equals(userId)) {
                return this.content(keyPath.userId, keyPath.workspace, keyPath.path);
            }
            throw new BadParameterException("User does not mach " + userId);
        }
        return null;
    }

    protected Node getNode(String userId, String nodePath) throws Exception {
        String path;
        String workspace;
        if (nodePath.startsWith("/")) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            path = nodePath;
        } else {
            int i = nodePath.indexOf(47);
            if (i > 0) {
                workspace = nodePath.substring(0, i);
                path = nodePath.substring(i);
            } else {
                throw new BadParameterException("Invalid path " + nodePath);
            }
        }
        return this.node(userId, workspace, path);
    }

    protected NodeContent content(String userId, String workspace, String path) throws Exception {
        Node node = this.node(userId, workspace, path);
        Node content = node.getNode("jcr:content");
        final String mimeType = content.getProperty("jcr:mimeType").getString();
        AutoCloseInputStream data = new AutoCloseInputStream(content.getProperty("jcr:data").getStream());
        return new NodeContent((InputStream)data){
            final /* synthetic */ InputStream val$data;
            {
                this.val$data = inputStream;
            }

            @Override
            public String getType() {
                return mimeType;
            }

            @Override
            public InputStream getData() {
                return this.val$data;
            }
        };
    }

    protected Node node(String userId, String workspace, String path) throws Exception {
        User user = this.organization.getUserHandler().findUserByName(userId);
        String fullPath = HierarchyNode.fullPath(workspace, path);
        if (user == null) {
            LOG.warn((Object)("Attempt to access node (" + fullPath + ") under not existing user " + userId));
            throw new BadParameterException("User not found for " + fullPath);
        }
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        try {
            Identity userIdentity = this.identityRegistry.getIdentity(userId);
            if (userIdentity == null) {
                LOG.warn((Object)("User identity not found " + userId + " for content of " + fullPath));
                throw new OutlookException("User identity not found " + userId);
            }
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            ConversationState.setCurrent((ConversationState)state);
            SessionProvider userProvider = new SessionProvider(state);
            this.sessionProviders.setSessionProvider(null, userProvider);
            SessionProvider sp = this.sessionProviders.getSessionProvider(null);
            Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
            Item item = this.finder.findItem(userSession, path);
            if (item.isNode()) {
                Node node = (Node)item;
                return node;
            }
            throw new BadParameterException("Not a node " + path);
        }
        finally {
            ConversationState.setCurrent((ConversationState)contextState);
            this.sessionProviders.setSessionProvider(null, contextProvider);
        }
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    class KeyPath {
        final String workspace;
        final String path;
        final String userId;

        protected KeyPath(String userId, String workspace, String path) {
            this.workspace = workspace;
            this.path = path;
            this.userId = userId;
        }
    }
}

