/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.social;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.outlook.social.OutlookActivitySupport;
import org.exoplatform.outlook.social.OutlookMessageDocumentPreview;
import org.exoplatform.outlook.social.OutlookMessagePresentation;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/templates/OutlookMessageActivity.gtmpl", events={@EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={FileUIActivity.OpenFileActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})})
public class OutlookMessageActivity
extends FileUIActivity {
    public static final String ACTIVITY_TYPE = "outlook:message";
    public static final String FILE_UUID = "fileUUID";
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "workspace";
    public static final String AUTHOR = "author";
    public static final String DATE_CREATED = "dateCreated";
    public static final String DATE_LAST_MODIFIED = "lastModified";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm";
    public static final String FAKE_TITLE = "SocialIntegration.messages.createdBy";
    protected static final Log LOG = ExoLogger.getLogger(OutlookMessageActivity.class);
    protected static ThreadLocal<Boolean> scriptInitialized = new ThreadLocal();
    protected DocumentService documentService;
    protected String message;
    protected String activityStatus;
    protected final OutlookActivitySupport util;

    public OutlookMessageActivity() throws Exception {
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        this.util = new OutlookActivitySupport((DocumentService)CommonsUtils.getService(DocumentService.class), repositoryService.getCurrentRepository());
    }

    public boolean isFileSupportPreview(Node data) throws Exception {
        if (data != null) {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("mimeType", data.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            context.put(Node.class.getName(), (String)data);
            for (UIExtension extension : extensions) {
                if (!manager.accept("org.exoplatform.ecm.dms.FileViewer", extension.getName(), context) || "Text".equals(extension.getName())) continue;
                return true;
            }
        }
        return super.isFileSupportPreview(data);
    }

    public String getSummary(Node node) {
        block13: {
            try {
                if (!node.isNodeType("mso:message")) break block13;
                String fromEmail = node.getProperty("mso:fromEmail").getString();
                String fromName = node.getProperty("mso:fromName").getString();
                Date time = node.getProperty("mso:created").getDate().getTime();
                Locale userLocale = null;
                RequestContext context = RequestContext.getCurrentInstance();
                OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
                try {
                    UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(context.getRemoteUser());
                    if (userProfile != null) {
                        String lang = (String)userProfile.getUserInfoMap().get("user.language");
                        if (lang != null) {
                            userLocale = LocaleContextInfo.getLocale((String)lang);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("User profile not found for " + context.getRemoteUser()));
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error getting user profile for " + context.getRemoteUser()), (Throwable)e);
                }
                if (userLocale == null) {
                    if (PortletRequestContext.class.isAssignableFrom(context.getClass())) {
                        userLocale = ((PortalRequestContext)((PortletRequestContext)PortletRequestContext.class.cast(context)).getParentAppRequestContext()).getRequest().getLocale();
                    } else if (PortalRequestContext.class.isAssignableFrom(context.getClass())) {
                        userLocale = ((PortalRequestContext)PortalRequestContext.class.cast(context)).getRequest().getLocale();
                    }
                    if (userLocale == null && (userLocale = context.getLocale()) == null) {
                        userLocale = Locale.ENGLISH;
                    }
                }
                DateFormat dateFormat = DateFormat.getDateInstance(0, userLocale);
                DateFormat timeFormat = DateFormat.getTimeInstance(3, userLocale);
                ResourceBundle res = context.getApplicationResourceBundle();
                StringBuilder fromLine = new StringBuilder();
                fromLine.append(fromName);
                fromLine.append('<');
                fromLine.append(fromEmail);
                fromLine.append('>');
                StringBuilder summary = new StringBuilder();
                summary.append(res.getString("Outlook.activity.from"));
                summary.append(": <a href='mailto:");
                summary.append(fromEmail);
                summary.append("' target='_top'>");
                summary.append(ContentReader.simpleEscapeHtml((String)fromLine.toString()));
                summary.append("</a> ");
                summary.append(res.getString("Outlook.activity.on"));
                summary.append(' ');
                summary.append(dateFormat.format(time));
                summary.append(' ');
                summary.append(res.getString("Outlook.activity.at"));
                summary.append(' ');
                summary.append(timeFormat.format(time));
                return summary.toString();
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error generating info for Outlook message activity node " + node), (Throwable)e);
            }
        }
        return super.getSummary(node);
    }

    public void renderContentPresentation() throws Exception {
        OutlookMessagePresentation uicontentpresentation = (OutlookMessagePresentation)this.addChild(OutlookMessagePresentation.class, null, null);
        uicontentpresentation.setNode(this.getContentNode());
        UIComponent fileComponent = uicontentpresentation.getUIComponent(this.getMimeType());
        uicontentpresentation.renderUIComponent(fileComponent);
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Object init = rcontext.getAttribute("outlookView_initialized");
        if (init == null || Boolean.FALSE.equals(init)) {
            rcontext.setAttribute("outlookView_initialized", (Object)Boolean.TRUE);
            JavascriptManager jsManager = rcontext.getJavascriptManager();
            jsManager.require("SHARED/outlookView", "outlookView");
        }
    }

    @Deprecated
    public String getViewLink() {
        try {
            Node data = this.getContentNode();
            if (this.isFileSupportPreview(data)) {
                return this.event("ViewDocument", this.getId(), "");
            }
            return Utils.getEditLink((Node)data, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getPreviewLink(WebuiBindingContext ctx) {
        Node node = null;
        try {
            node = this.getContentNode();
            if (node != null) {
                if (this.isFileSupportPreview(node)) {
                    return this.util.getPreviewLink(ctx, (BaseUIActivity)this, node);
                }
                return Utils.getEditLink((Node)node, (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting document preview link " + node), (Throwable)e);
        }
        return "";
    }

    public String getActivityStatus() {
        if (this.message == null || this.message.length() == 0) {
            return this.activityStatus;
        }
        if (!FAKE_TITLE.equals(this.message)) {
            return this.message;
        }
        return null;
    }

    public void setUIActivityData(Map<String, String> activityParams) {
        this.message = activityParams.get("message");
        this.activityStatus = activityParams.get("MESSAGE");
        super.setUIActivityData(activityParams);
    }

    @Deprecated
    public static class ViewDocumentActionListener
    extends EventListener<OutlookMessageActivity> {
        public void execute(Event<OutlookMessageActivity> event) throws Exception {
            OutlookMessageActivity activity = (OutlookMessageActivity)((Object)event.getSource());
            UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)activity.getAncestorOfType(UIActivitiesContainer.class);
            PopupContainer uiPopupContainer = uiActivitiesContainer.getPopupContainer();
            OutlookMessageDocumentPreview preview = (OutlookMessageDocumentPreview)uiPopupContainer.createUIComponent(OutlookMessageDocumentPreview.class, null, "UIDocumentPreview");
            preview.setBaseUIActivity((BaseUIActivity)activity);
            preview.setContentInfo(activity.docPath, activity.repository, activity.workspace, activity.getContentNode());
            uiPopupContainer.activate((UIComponent)preview, 0, 0, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

