/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.rest;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.ContentLink;
import org.exoplatform.outlook.jcr.NodeContent;
import org.exoplatform.outlook.rest.RESTServiceBase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Path(value="/outlook/content")
public class ContentService
extends RESTServiceBase {
    protected static final Log LOG = ExoLogger.getLogger(ContentService.class);
    protected final ContentLink contentLink;

    public ContentService(ContentLink contentLink) {
        this.contentLink = contentLink;
    }

    @GET
    @Path(value="/{userId}/{key}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        Response.ResponseBuilder resp;
        block11: {
            boolean canDownload;
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Outlook document content: " + userId + "@" + key + " to " + clientHost + "(" + clientIp + ")"));
            }
            if (canDownload = true) {
                if (key != null && key.length() > 0) {
                    try {
                        if (userId != null && userId.length() > 0) {
                            NodeContent content = this.contentLink.consume(userId, key);
                            resp = content != null ? Response.ok().entity((Object)content.getData()).type(content.getType()) : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Content not found for " + key));
                            break block11;
                        }
                        LOG.error((Object)"Error downloading content. User identity not provided");
                        resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User not provided");
                    }
                    catch (BadParameterException e) {
                        LOG.error((Object)("Bad parameter to downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage());
                    }
                    catch (OutlookException e) {
                        LOG.error((Object)("Error downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error downloading content. " + e.getMessage()));
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Storage error.");
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while downloading content for " + key), e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Runtime error.");
                    }
                } else {
                    resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null or empty file key.");
                }
            } else {
                LOG.warn((Object)("Attempt to download content by not allowed host: " + clientHost));
                resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not a document server.");
            }
        }
        return resp.build();
    }
}

