/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.forum;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;

public class ForumUtils {
    public static final String CATEGORY = "category".intern();
    public static final String FORUM = "forum".intern();
    public static final String TOPIC = "topic".intern();
    public static final String POST = "post".intern();
    public static final String TAG = "Tag".intern();
    public static final String COMMA = ",".intern();
    public static final String SLASH = "/".intern();
    public static final String EMPTY_STR = "".intern();
    public static final String SPACE_GROUP_ID = "/spaces".replace(SLASH, EMPTY_STR);
    public static final int MAXSIGNATURE = 300;
    public static final int MAXTITLE = 100;
    public static final long MAXMESSAGE = 10000L;
    protected static final Log LOG = ExoLogger.getLogger(ForumUtils.class);

    private ForumUtils() {
    }

    public static String[] getCensoredKeyword(String stringKey) {
        if (!ForumUtils.isEmpty(stringKey)) {
            String str = EMPTY_STR;
            while (!stringKey.equals(str)) {
                str = stringKey;
                if ((stringKey = stringKey.toLowerCase().replaceAll(";", COMMA).replaceAll(COMMA + " ", COMMA).replaceAll(" " + COMMA, COMMA).replaceAll(COMMA + COMMA, COMMA)).indexOf(COMMA) != 0) continue;
                stringKey = stringKey.replaceFirst(COMMA, EMPTY_STR);
            }
            return stringKey.trim().split(COMMA);
        }
        return new String[0];
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String buildForumLink(String url, String type, String id) {
        StringBuilder link = new StringBuilder(url);
        if (!ForumUtils.isEmpty(type) && !ForumUtils.isEmpty(id)) {
            if (link.lastIndexOf(SLASH) == link.length() - 1) {
                link.append(type);
            } else {
                link.append(SLASH).append(type);
            }
            if (!id.equals(Utils.FORUM_SERVICE)) {
                link.append(SLASH).append(id);
            }
        }
        return link.toString();
    }

    public static String createdForumLink(String type, String id, boolean isPrivate) {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String fullUrl = portalContext.getRequest().getRequestURL().toString();
            String host = fullUrl.substring(0, fullUrl.indexOf(SLASH, 8));
            return new StringBuffer(host).append(ForumUtils.createdSubForumLink(type, id, isPrivate)).toString();
        }
        catch (Exception e) {
            return id;
        }
    }

    public static String createdSubForumLink(String type, String id, boolean isPrivate) {
        try {
            String containerName = ((ExoContainerContext)CommonsUtils.getService(ExoContainerContext.class)).getPortalContainerName();
            String pageNodeSelected = Util.getUIPortal().getSelectedUserNode().getURI();
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            return ForumUtils.buildLink(portalContext.getPortalURI(), containerName, pageNodeSelected, type, id, isPrivate);
        }
        catch (Exception e) {
            return id;
        }
    }

    public static String buildLink(String portalURI, String containerName, String selectedNode, String type, String id, boolean isPrivate) {
        StringBuilder sb = new StringBuilder();
        portalURI = portalURI.concat(selectedNode).concat(SLASH);
        if (!isPrivate) {
            sb.append(ForumUtils.buildForumLink(portalURI, type, id));
        } else {
            String host = portalURI.substring(0, portalURI.indexOf(containerName) - 1);
            sb.append(host).append(SLASH).append(containerName).append(SLASH).append("login?&initialURI=").append(ForumUtils.buildForumLink(portalURI.replaceFirst(host, EMPTY_STR), type, id)).toString();
        }
        return sb.toString();
    }

    public static String[] splitForForum(String str) {
        if (!ForumUtils.isEmpty(str)) {
            if ((str = StringUtils.remove((String)str, (String)" ")).contains(COMMA)) {
                str = str.replaceAll(";", COMMA);
                return str.trim().split(COMMA);
            }
            str = str.replaceAll(COMMA, ";");
            return str.trim().split(";");
        }
        return new String[]{EMPTY_STR};
    }

    public static boolean isArrayEmpty(String[] strs) {
        return strs == null || strs.length == 0 || strs.length == 1 && strs[0].trim().length() <= 0;
    }

    public static String[] arraysMerge(String[] strs1, String[] strs2) {
        if (ForumUtils.isArrayEmpty(strs1)) {
            return strs2;
        }
        if (ForumUtils.isArrayEmpty(strs2)) {
            return strs1;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(strs1));
        set.addAll(Arrays.asList(strs2));
        return set.toArray(new String[set.size()]);
    }

    public static MessageBuilder getDefaultMail() {
        MessageBuilder messageBuilder = new MessageBuilder();
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            messageBuilder.setContent(res.getString("UINotificationForm.label.notifyEmailContentDefault"));
            String header = res.getString("UINotificationForm.label.notifyEmailHeaderSubjectDefault");
            messageBuilder.setHeaderSubject(ForumUtils.isEmpty(header) ? EMPTY_STR : header);
            messageBuilder.setTypes(res.getString("UIForumPortlet.label.category"), res.getString("UIForumPortlet.label.forum"), res.getString("UIForumPortlet.label.topic"), res.getString("UIForumPortlet.label.post"));
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get resource bundle for Forum default content email notification !", (Throwable)e);
        }
        return messageBuilder;
    }
}

