/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.server.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.web.filter.Filter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class OutlookLoginFilter
implements Filter {
    protected static final Logger LOG = LoggerFactory.getLogger(OutlookLoginFilter.class);
    public static final String OUTLOOK_LOGIN = "/outlook/login";
    public static final String OUTLOOK_INITIAL_URI = "initialURI=%2Fportal%2Fdw%2Foutlook";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        String query = httpReq.getQueryString();
        if (query != null && query.startsWith(OUTLOOK_INITIAL_URI)) {
            httpRes.sendRedirect(OUTLOOK_LOGIN + '?' + query);
        } else {
            chain.doFilter(request, response);
        }
    }
}

