/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.rest;

import java.net.URI;
import java.util.Scanner;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.ContentLink;
import org.exoplatform.outlook.jcr.NodeContent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/outlook")
public class ContentService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ContentService.class);
    public static final String DEFAILT_DISPLAY_NAME = "eXo Platform";
    protected final ContentLink contentLink;

    public ContentService(ContentLink contentLink) {
        this.contentLink = contentLink;
    }

    @GET
    @Path(value="/content/{userId}/{key}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        Response.ResponseBuilder resp;
        block11: {
            boolean canDownload;
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Outlook document content: " + userId + "@" + key + " to " + clientHost + "(" + clientIp + ")"));
            }
            if (canDownload = true) {
                if (key != null && key.length() > 0) {
                    try {
                        if (userId != null && userId.length() > 0) {
                            NodeContent content = this.contentLink.consume(userId, key);
                            resp = content != null ? Response.ok().entity((Object)content.getData()).type(content.getType()) : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Content not found for " + key));
                            break block11;
                        }
                        LOG.error((Object)"Error downloading content. User identity not provided");
                        resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User not provided");
                    }
                    catch (BadParameterException e) {
                        LOG.error((Object)("Bad parameter to downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage());
                    }
                    catch (OutlookException e) {
                        LOG.error((Object)("Error downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error downloading content. " + e.getMessage()));
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while downloading content for " + key), (Throwable)e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Storage error.");
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while downloading content for " + key), e);
                        resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Runtime error.");
                    }
                } else {
                    resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null or empty file key.");
                }
            } else {
                LOG.warn((Object)("Attempt to download content by not allowed host: " + clientHost));
                resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not a document server.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/manifest")
    @Produces(value={"text/xml"})
    public Response manifest(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="guid") String guid, @QueryParam(value="hostName") String hostName, @QueryParam(value="displayName") String displayName) {
        Response.ResponseBuilder resp;
        String clientHost = this.getClientHost(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> Outlook manifest for " + clientHost + " as host:" + hostName + " with guid:" + guid));
        }
        URI requestURI = uriInfo.getRequestUri();
        StringBuilder serverHostBuilder = new StringBuilder();
        serverHostBuilder.append(requestURI.getScheme());
        serverHostBuilder.append("://");
        if (hostName != null && hostName.length() > 0) {
            serverHostBuilder.append(hostName);
        } else {
            serverHostBuilder.append(requestURI.getHost());
            int serverPort = requestURI.getPort();
            if (serverPort != 80 || serverPort != 443) {
                serverHostBuilder.append(':');
                serverHostBuilder.append(serverPort);
            }
        }
        String serverURL = serverHostBuilder.toString();
        try (Scanner mScanner = new Scanner(this.getClass().getResourceAsStream("/manifest/exo-outlook-manifest.template.xml"), "UTF-8").useDelimiter("\\A");){
            String mTemplate = mScanner.next();
            String manifest = mTemplate.replaceAll("\\$BASE_URL", serverURL);
            if (guid == null || (guid = guid.trim()).length() == 0) {
                guid = UUID.randomUUID().toString();
            }
            manifest = manifest.replaceAll("\\$GUID", guid);
            if (displayName == null || (displayName = displayName.trim()).length() == 0) {
                displayName = DEFAILT_DISPLAY_NAME;
            }
            manifest = manifest.replaceAll("\\$DISPLAY_NAME", displayName);
            resp = Response.ok().entity((Object)manifest);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error while generating manifest for " + clientHost), e);
            resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Cannot generate manifest");
        }
        return resp.build();
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidName(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidName(host)) {
            return host;
        }
        host = request.getRemoteHost();
        if (this.isValidName(host)) {
            return host;
        }
        return null;
    }

    protected boolean isValidName(String hostName) {
        return hostName != null && hostName.length() > 0 && !"unknown".equalsIgnoreCase(hostName);
    }
}

