/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.social;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.outlook.social.BaseOutlookMessageViewer;
import org.exoplatform.outlook.social.OutlookMessageFileFilter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

@ComponentConfig(template="classpath:groovy/templates/OutlookMessageViewer.gtmpl")
public class OutlookMessageViewer
extends BaseOutlookMessageViewer {
    protected static final Log LOG = ExoLogger.getLogger(OutlookMessageViewer.class);
    public static final String EVENT_NAME = "ShowOutlookMessage";
    protected static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new OutlookMessageFileFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String getWebdavLink() throws Exception {
        Node node = this.getCurrentNode();
        if (node != null) {
            String baseURI;
            RequestContext requestContext = WebuiRequestContext.getCurrentInstance();
            if (PortletRequestContext.class.isAssignableFrom(requestContext.getClass())) {
                PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
                PortletRequest portletRequest = portletRequestContext.getRequest();
                baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
            } else if (PortalRequestContext.class.isAssignableFrom(requestContext.getClass())) {
                PortalRequestContext portalRequestContext = (PortalRequestContext)PortalRequestContext.class.cast(requestContext);
                HttpServletRequest httpRequest = portalRequestContext.getRequest();
                baseURI = httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + String.format("%s", httpRequest.getServerPort());
            } else {
                baseURI = System.getProperty("exo.base.url");
                if (baseURI == null) {
                    LOG.warn((Object)("Cannot construct a base URL of WebDav link for " + node.getPath() + ". Is it a portal/portlet request?"));
                    baseURI = "";
                }
            }
            String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
            String workspace = node.getSession().getWorkspace().getName();
            FriendlyService friendlyService = (FriendlyService)WCMCoreUtils.getService(FriendlyService.class);
            StringBuilder link = new StringBuilder(baseURI);
            link.append('/');
            link.append(PortalContainer.getCurrentPortalContainerName());
            link.append('/');
            link.append(PortalContainer.getCurrentRestContextName());
            link.append("/jcr/");
            link.append(repository);
            link.append('/');
            link.append(workspace);
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                link.append(originalNode.getPath());
                link.append("?version=");
                link.append(node.getParent().getName());
            } else {
                link.append(node.getPath());
            }
            return friendlyService.getFriendlyUri(link.toString());
        }
        return "#";
    }
}

