/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.social;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.ext.filter.impl.FileFilter;

public class OutlookMessageFileFilter
extends FileFilter {
    public boolean accept(Map<String, Object> context) throws Exception {
        Node contextNode = (Node)context.get(Node.class.getName());
        if (contextNode == null) {
            MultivaluedMap pathParams;
            ApplicationContext restContext;
            WebuiRequestContext reqContext;
            UIApplication uiApp;
            UIJcrExplorerContainer jcrExplorerContainer;
            UIJCRExplorer uiExplorer = (UIJCRExplorer)context.get(UIJCRExplorer.class.getName());
            if (uiExplorer != null) {
                contextNode = uiExplorer.getCurrentNode();
            }
            if (contextNode == null && (jcrExplorerContainer = (UIJcrExplorerContainer)(uiApp = (reqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getUIApplication()).getChild(UIJcrExplorerContainer.class)) != null) {
                UIJCRExplorer jcrExplorer = (UIJCRExplorer)jcrExplorerContainer.getChild(UIJCRExplorer.class);
                contextNode = jcrExplorer.getCurrentNode();
            }
            if (contextNode == null && (restContext = ApplicationContextImpl.getCurrent()) != null && restContext.getContainerRequest().getMethod().equals("GET") && restContext.getPath().startsWith("/contentviewer") && (pathParams = restContext.getPathParameters()) != null) {
                List repoNameList = (List)pathParams.get((Object)"repoName");
                List workspaceNameList = (List)pathParams.get((Object)"workspaceName");
                List uuidList = (List)pathParams.get((Object)"uuid");
                if (!(repoNameList == null || repoNameList.isEmpty() || workspaceNameList == null || workspaceNameList.isEmpty() || workspaceNameList == null || workspaceNameList.isEmpty())) {
                    String repoName = (String)repoNameList.get(0);
                    String workspaceName = (String)workspaceNameList.get(0);
                    String uuid = (String)uuidList.get(0);
                    RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    if (repository.getConfiguration().getName().equals(repoName)) {
                        SessionProviderService service = (SessionProviderService)CommonsUtils.getService(SessionProviderService.class);
                        SessionProvider sessionProvider = service.getSystemSessionProvider(null);
                        Session session = sessionProvider.getSession(workspaceName, repository);
                        contextNode = session.getNodeByUUID(uuid);
                    }
                }
            }
        }
        if (contextNode != null && contextNode.isNodeType("mso:message")) {
            context.put(Node.class.getName(), contextNode);
            return true;
        }
        return false;
    }
}

